/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.portlet;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.extended.util.ResourceUtil;
import org.ow2.weblab.core.helper.impl.AdvancedSelector;
import org.ow2.weblab.core.helper.impl.IPredicateValuePairs;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.helper.impl.RDFSelectorFactory;
import org.ow2.weblab.core.helper.impl.Statements;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.Text;
import org.ow2.weblab.core.services.ResourceContainer;
import org.ow2.weblab.core.services.resourcecontainer.LoadResourceArgs;
import org.ow2.weblab.portlet.WebLabPortlet;
import org.ow2.weblab.portlet.bean.LegendField;
import org.ow2.weblab.portlet.tool.LegendFactory;
import org.ow2.weblab.portlet.tool.MediaUnitHighLighter;
import org.ow2.weblab.portlet.tool.MediaUnitLegend;
import org.ow2.weblab.portlet.tool.MediaUnitSplitter;
import org.ow2.weblab.portlet.tool.RepoServiceConfigBean;
import org.ow2.weblab.portlet.tool.ResourceContainerUtil;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;

public class DocViewPortlet
extends WebLabPortlet {
    private static final int DEFAULT_TEXT_SIZE = 10000;
    private static final String ADD_TO_BASKET_ACTION = "addToBasketSelection";
    private static boolean USE_DEFAULT_LEGEND = true;
    private static boolean USE_REDIRECTION = false;
    private static final String POK_PROPERTY_DOC_URI = "http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedTo";
    private static final String USER_MEDIA_UNIT = "user_media_unit";
    private static final String USER_MEDIA_UNIT_WTMAP = "user_mediaunit_triplemap";
    private static final String USER_LEGEND = "user_legend";
    private static boolean SHOW_INSTANCES_LINK = true;
    private static boolean SHOW_TOOLTIPS = true;
    private static final String USER_SPLITTER = "user_spliter";
    private static final String USER_REPO_CONF = "user_repo_service_conf";
    private static final String CURRENT_RESSOURCE_IS_LOADED = "user_resource_is_loaded";
    private static final String ERROR = "message_error";
    private static final String CSS_STYLE_CONTEXT = "doc_view_portlet";
    private static final String USER_RES_ANNOTS_LOADED = "user_wtriple_map_isloaded";
    private HashMap<URL, ResourceContainer> repoMap;
    private static URL WSDL_REPO_URL;
    private static MediaUnitLegend default_legend;
    private static RepoServiceConfigBean default_serv_conf;
    private AdvancedSelector rdfSelector;
    private Log logger;

    public void init() throws PortletException {
        super.init();
        default_serv_conf = new RepoServiceConfigBean();
        default_serv_conf.setServiceURL(this.getInitParameter("repo_service_url"));
        this.repoMap = new HashMap();
        this.logger = LogFactory.getLog(this.getClass());
        try {
            WSDL_REPO_URL = new File(this.getPortletContext().getRealPath("WEB-INF/classes/services/WebLab.wsdl")).toURI().toURL();
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)e);
        }
        if (this.getInitParameter("use_redirection") != null) {
            USE_REDIRECTION = Boolean.parseBoolean(this.getInitParameter("use_redirection"));
        }
        if (this.getInitParameter("use_default_legend") != null) {
            USE_DEFAULT_LEGEND = Boolean.parseBoolean(this.getInitParameter("use_default_legend"));
        }
        if (USE_DEFAULT_LEGEND) {
            ClassPathResource resource = new ClassPathResource(this.getInitParameter("default_legend_bean"));
            XmlBeanFactory factory = new XmlBeanFactory((org.springframework.core.io.Resource)resource);
            default_legend = (MediaUnitLegend)factory.getBean(this.getInitParameter("default_legend_bean_id"), MediaUnitLegend.class);
        }
        if (this.getInitParameter("show_instances_link") != null) {
            SHOW_INSTANCES_LINK = Boolean.parseBoolean(this.getInitParameter("show_instances_link"));
        }
        if (this.getInitParameter("show_tooltips") != null) {
            SHOW_TOOLTIPS = Boolean.parseBoolean(this.getInitParameter("show_tooltips"));
        }
        this.rdfSelector = RDFSelectorFactory.getSelector((boolean)true, (String[])new String[0]);
    }

    public void destroy() {
        default_legend = null;
        default_serv_conf = null;
        this.repoMap = null;
        super.destroy();
    }

    public void doView(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        long start = System.currentTimeMillis();
        res.setTitle(ResourceBundle.getBundle("docview_portlet", req.getLocale()).getString("portlet.title"));
        try {
            if (req.getPortletSession().getAttribute(USER_MEDIA_UNIT, 1) == null || req.getPortletSession().getAttribute(CURRENT_RESSOURCE_IS_LOADED, 1) == null) {
                req.setAttribute("no_doc", (Object)true);
            }
        }
        catch (IllegalStateException e) {
            req.setAttribute("error", (Object)"session expired");
            PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("erro_page_url"));
            rd.include(req, res);
            this.logger.debug((Object)("doView reponse time :" + Long.toString(System.currentTimeMillis() - start)));
        }
        PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("view_page_url"));
        rd.include(req, res);
        this.logger.debug((Object)("doView reponse time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    public void doEdit(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        PortletRequestDispatcher rd;
        long start = System.currentTimeMillis();
        MediaUnit unit = null;
        MediaUnitLegend legend = null;
        MediaUnitSplitter split = null;
        res.setTitle(ResourceBundle.getBundle("docview_portlet", req.getLocale()).getString("portlet.title.edit"));
        if (req.getParameter(ERROR) != null) {
            req.setAttribute(ERROR, (Object)req.getParameter(ERROR));
            rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("error_page_url"));
            rd.include(req, res);
        }
        if (req.getPortletSession().getAttribute(USER_MEDIA_UNIT, 1) != null) {
            unit = (MediaUnit)req.getPortletSession().getAttribute(USER_MEDIA_UNIT, 1);
        }
        if (req.getPortletSession().getAttribute(USER_LEGEND, 1) != null) {
            legend = (MediaUnitLegend)req.getPortletSession().getAttribute(USER_LEGEND, 1);
            legend.setActionURL(res.createActionURL().toString());
        } else if (unit != null) {
            legend = LegendFactory.getLegend((MediaUnit)unit);
            legend.setActionURL(res.createActionURL().toString());
        }
        if (req.getPortletSession().getAttribute(USER_SPLITTER, 1) != null) {
            split = (MediaUnitSplitter)req.getPortletSession().getAttribute(USER_SPLITTER, 1);
        }
        if (unit != null && split != null && legend != null && unit.getUri() != null) {
            String title = this.getTitleFromUnit(unit);
            if (title != null) {
                req.setAttribute("DOCUMENT_TITLE", (Object)title);
            } else {
                req.setAttribute("DOCUMENT_TITLE", (Object)ResourceBundle.getBundle("docview_portlet", req.getLocale()).getString("portlet.no_doc_title"));
            }
            req.setAttribute("current_split_pos", (Object)split.getCurrentPageIndex());
            req.setAttribute("max_positions", (Object)split.getAvaiblePageCount());
            req.setAttribute("HTML_LEGEND", (Object)legend.getHTMLLegend(true, ResourceBundle.getBundle("docview_portlet", req.getLocale())));
        } else {
            req.setAttribute("no_doc", (Object)true);
        }
        rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("edit_page_url"));
        rd.include(req, res);
        this.logger.debug((Object)("doEdit reponse time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    public void processAction(ActionRequest req, ActionResponse res) throws IOException, PortletException {
        String classURI;
        String instanceURI;
        long start = System.currentTimeMillis();
        MediaUnitLegend legend = null;
        if (req.getPortletSession().getAttribute(USER_LEGEND, 1) != null) {
            legend = (MediaUnitLegend)req.getPortletSession().getAttribute(USER_LEGEND, 1);
        }
        if (req.getParameter(MediaUnitLegend.SAVE_LEGEND_SUBMIT) != null && legend != null) {
            this.logger.debug((Object)"update user's legend");
            for (LegendField field : legend.getFields()) {
                String selectedColor = req.getParameter(legend.getColorInputName(field));
                String checkBox = req.getParameter(legend.getCheckBoxInputName(field));
                this.logger.debug((Object)("selected color :" + selectedColor));
                String[] tabColor = selectedColor.split(",");
                if (tabColor.length == 3) {
                    field.setStyleColor(tabColor[0] + "," + tabColor[1] + "," + tabColor[2]);
                } else {
                    field.setStyleColor(req.getParameter(legend.getColorInputName(field)));
                }
                if (checkBox != null) {
                    field.setShow(true);
                    continue;
                }
                field.setShow(false);
            }
            res.setPortletMode(PortletMode.VIEW);
            legend.updateShemColor();
            req.getPortletSession().setAttribute(USER_LEGEND, (Object)legend, 1);
        }
        if (req.getParameter("instance_uri") != null) {
            instanceURI = req.getParameter("instance_uri");
            classURI = req.getParameter("class_uri");
            PieceOfKnowledge pok = (PieceOfKnowledge)ResourceFactory.createResource((String)"docview", (String)("" + new Date().getTime()), PieceOfKnowledge.class);
            JenaPoKHelper h = new JenaPoKHelper(pok);
            h.setAutoCommitMode(false);
            h.createLitStat(instanceURI, "http://weblab.ow2.org/core/1.2/ontology/processing#isCandidate", "false");
            h.createResStat(instanceURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", classURI);
            h.commit();
            this.logger.debug((Object)"Sending event for the action instanceSelection");
            if (USE_REDIRECTION) {
                this.sendEventForActionAndRedirect("instanceSelection", (Resource)pok, res);
            } else {
                this.sendEventForAction("instanceSelection", (Resource)pok, res);
            }
        }
        if (req.getParameter("candidate_instance_uri") != null) {
            instanceURI = req.getParameter("candidate_instance_uri");
            classURI = req.getParameter("class_uri");
            String documentURI = ((Resource)req.getPortletSession().getAttribute(USER_MEDIA_UNIT, 1)).getUri();
            PieceOfKnowledge pok = (PieceOfKnowledge)ResourceFactory.createResource((String)"docview", (String)("" + new Date().getTime()), PieceOfKnowledge.class);
            JenaPoKHelper h = new JenaPoKHelper(pok);
            h.setAutoCommitMode(false);
            h.createLitStat(instanceURI, "http://weblab.ow2.org/core/1.2/ontology/processing#isCandidate", "true");
            h.createResStat(instanceURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", classURI);
            h.createResStat(documentURI, "http://weblab.ow2.org/core/1.2/ontology/processing#refersTo", instanceURI);
            h.commit();
            if (USE_REDIRECTION) {
                this.sendEventForActionAndRedirect("candidateInstanceSelection", (Resource)pok, res);
            } else {
                this.sendEventForAction("candidateInstanceSelection", (Resource)pok, res);
            }
        }
        if (req.getParameter("add_doc_to_basket_action") != null && req.getParameter("add_doc_to_basket_action").equals("add")) {
            this.sendEventForAction(ADD_TO_BASKET_ACTION, (Resource)req.getPortletSession().getAttribute(USER_MEDIA_UNIT, 1), res);
        }
        this.logger.debug((Object)("process action reponse time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    public void processEvent(EventRequest req, EventResponse resp) throws PortletException, IOException {
        long start = System.currentTimeMillis();
        this.logger.debug((Object)(req.getEvent().getQName() + " event received in document viewer portlet."));
        Document doc_evt = null;
        if (this.getReaction(req.getEvent().getQName()).getLocalPart().equals("displayDocument")) {
            this.logger.debug((Object)"Received a event containing a complete Document in document viewer portlet.");
            req.getPortletSession().setAttribute(CURRENT_RESSOURCE_IS_LOADED, (Object)true, 1);
            doc_evt = (Document)req.getEvent().getValue();
            this.logger.info((Object)"receive a loaded document");
        } else if (this.getReaction(req.getEvent().getQName()).getLocalPart().equals("loadAndDisplayDocument")) {
            this.logger.debug((Object)"Received a event containing a PieceOfKnowledge about a document in document viewer portlet.");
            req.getPortletSession().setAttribute(CURRENT_RESSOURCE_IS_LOADED, (Object)false, 1);
            PieceOfKnowledge pok = (PieceOfKnowledge)req.getEvent().getValue();
            String docURI = this.getURIFromPoK(pok);
            if (docURI != null) {
                doc_evt = new Document();
                doc_evt.setUri(docURI);
                this.logger.info((Object)("receive an unloaded document with URI : " + doc_evt.getUri()));
            } else {
                try {
                    this.logger.info((Object)("receive an unloaded document with unavailable URI (null), corresponding PoK :" + ResourceUtil.saveToXMLString((Resource)pok)));
                }
                catch (WebLabCheckedException e) {
                    this.logger.info((Object)"Unable to get PoK XML");
                }
            }
        }
        if (doc_evt != null) {
            req.getPortletSession().setAttribute(USER_MEDIA_UNIT, (Object)doc_evt, 1);
            req.getPortletSession().setAttribute(USER_RES_ANNOTS_LOADED, (Object)false, 1);
        }
        this.logger.debug((Object)("process event reponse time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        long start = System.currentTimeMillis();
        MediaUnit unit = null;
        if (request.getPortletSession().getAttribute(USER_MEDIA_UNIT, 1) != null && request.getPortletSession().getAttribute(CURRENT_RESSOURCE_IS_LOADED, 1) != null) {
            String uri_to_load;
            unit = (MediaUnit)request.getPortletSession().getAttribute(USER_MEDIA_UNIT, 1);
            if (!((Boolean)request.getPortletSession().getAttribute(CURRENT_RESSOURCE_IS_LOADED, 1)).booleanValue() && (uri_to_load = unit.getUri()) != null) {
                boolean loaded = false;
                this.logger.info((Object)("new resource to load : " + uri_to_load));
                LoadResourceArgs args = new LoadResourceArgs();
                args.setResourceId(uri_to_load);
                Resource loadedResource = null;
                if (request.getPortletSession().getAttribute(USER_REPO_CONF, 1) == null) {
                    RepoServiceConfigBean repo_conf = new RepoServiceConfigBean();
                    repo_conf.setServiceURL(this.getInitParameter("repo_service_url"));
                    request.getPortletSession().setAttribute(USER_REPO_CONF, (Object)repo_conf, 1);
                }
                URL repoURL = new URL(((RepoServiceConfigBean)request.getPortletSession().getAttribute(USER_REPO_CONF, 1)).getServiceURL());
                try {
                    ResourceContainer repo = this.getRepoService(repoURL);
                    loadedResource = repo.loadResource(args).getResource();
                    loaded = true;
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                    request.setAttribute(ERROR, (Object)"Unable to get resource on repository service");
                    loaded = false;
                }
                if (loaded && loadedResource instanceof Document) {
                    unit = (Document)loadedResource;
                    boolean containsTextUnits = false;
                    boolean bl = containsTextUnits = !ResourceUtil.getSelectedSubResources((Resource)unit, Text.class).isEmpty();
                    if (containsTextUnits) {
                        request.getPortletSession().setAttribute(USER_MEDIA_UNIT, (Object)unit, 1);
                        request.getPortletSession().setAttribute(CURRENT_RESSOURCE_IS_LOADED, (Object)true, 1);
                        MediaUnitSplitter split = new MediaUnitSplitter(unit, 10000);
                        request.getPortletSession().setAttribute(USER_SPLITTER, (Object)split, 1);
                    } else {
                        request.setAttribute(ERROR, (Object)true);
                        request.setAttribute("no_doc", (Object)true);
                        request.getPortletSession().removeAttribute(USER_SPLITTER, 1);
                        request.getPortletSession().removeAttribute(USER_MEDIA_UNIT, 1);
                        request.getPortletSession().removeAttribute(CURRENT_RESSOURCE_IS_LOADED, 1);
                    }
                }
            }
            if (request.getAttribute(ERROR) != null) {
                response.setContentType("text/html");
                PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("error_page_url"));
                rd.include((PortletRequest)request, (PortletResponse)response);
            } else {
                MediaUnitLegend legend;
                if (request.getPortletSession().getAttribute(USER_SPLITTER, 1) == null) {
                    request.getPortletSession().setAttribute(USER_SPLITTER, (Object)new MediaUnitSplitter(unit, 10000), 1);
                } else if (!((MediaUnitSplitter)request.getPortletSession().getAttribute(USER_SPLITTER, 1)).getMediaUnit().getUri().equals(unit.getUri())) {
                    request.getPortletSession().setAttribute(USER_SPLITTER, (Object)new MediaUnitSplitter(unit, 10000), 1);
                }
                if (request.getPortletSession().getAttribute(USER_LEGEND, 1) == null) {
                    legend = USE_DEFAULT_LEGEND ? default_legend : LegendFactory.getLegend((MediaUnit)((MediaUnit)request.getPortletSession().getAttribute(USER_MEDIA_UNIT, 1)));
                    legend.setStyleContext(CSS_STYLE_CONTEXT);
                    legend.setAppContext(request.getContextPath());
                    legend.setActionURL(response.createActionURL().toString());
                    request.getPortletSession().setAttribute(USER_LEGEND, (Object)legend, 1);
                }
                if (request.getParameter("page_part").equals("legend")) {
                    legend = (MediaUnitLegend)request.getPortletSession().getAttribute(USER_LEGEND, 1);
                    request.setAttribute("HTML_LEGEND", (Object)legend.getHTMLLegend(false, ResourceBundle.getBundle("docview_portlet", request.getLocale())));
                    response.setContentType("text/html");
                    PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("legend_document_page_url"));
                    rd.include((PortletRequest)request, (PortletResponse)response);
                } else if (request.getParameter("page_part").equals("text")) {
                    legend = (MediaUnitLegend)request.getPortletSession().getAttribute(USER_LEGEND, 1);
                    MediaUnitSplitter split = (MediaUnitSplitter)request.getPortletSession().getAttribute(USER_SPLITTER, 1);
                    String title = this.getTitleFromUnit(unit);
                    if (title != null) {
                        request.setAttribute("DOCUMENT_TITLE", (Object)title);
                    } else {
                        request.setAttribute("DOCUMENT_TITLE", (Object)ResourceBundle.getBundle("docview_portlet", request.getLocale()).getString("portlet.no_doc_title"));
                    }
                    request.setAttribute("doc_uri", (Object)unit.getUri());
                    if (request.getParameter("splitter_position") != null) {
                        split.setCurrentPageIndex(Integer.parseInt(request.getParameter("splitter_position")));
                    }
                    Statements mediaUnitWTMap = null;
                    if (request.getPortletSession().getAttribute(USER_RES_ANNOTS_LOADED, 1) != null && !((Boolean)request.getPortletSession().getAttribute(USER_RES_ANNOTS_LOADED, 1)).booleanValue()) {
                        AdvancedSelector RDFSel = RDFSelectorFactory.getSelector((boolean)true, (String[])new String[]{unit.getUri()});
                        mediaUnitWTMap = RDFSel.searchFor((Resource)unit, new String[]{"http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://weblab.ow2.org/core/1.2/ontology/processing#isCandidate", "http://www.w3.org/2000/01/rdf-schema#label", "http://weblab.ow2.org/core/1.2/ontology/processing#refersTo"});
                        request.getPortletSession().setAttribute(USER_MEDIA_UNIT_WTMAP, (Object)mediaUnitWTMap, 1);
                        request.getPortletSession().setAttribute(USER_RES_ANNOTS_LOADED, (Object)true, 1);
                    }
                    if (request.getPortletSession().getAttribute(USER_MEDIA_UNIT_WTMAP, 1) != null) {
                        mediaUnitWTMap = (Statements)request.getPortletSession().getAttribute(USER_MEDIA_UNIT_WTMAP, 1);
                    }
                    PortletURL actionURL = response.createActionURL();
                    request.setAttribute("HTML_DOCUMENT", (Object)MediaUnitHighLighter.getHtmlRepresentation((MediaUnit)unit, (String)"docview_portlet", (MediaUnitLegend)legend, (int)split.getCurrentPageStartOffset(), (int)split.getCurrentPageEndOffset(), (PortletURL)actionURL, (ResourceBundle)ResourceBundle.getBundle("docview_portlet", request.getLocale()), (boolean)SHOW_INSTANCES_LINK, (boolean)SHOW_TOOLTIPS, (Statements)mediaUnitWTMap));
                    request.setAttribute("current_split_pos", (Object)split.getCurrentPageIndex());
                    request.setAttribute("max_positions", (Object)split.getAvaiblePageCount());
                    response.setContentType("text/html");
                    PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("hightlighted_document_page_url"));
                    rd.include((PortletRequest)request, (PortletResponse)response);
                }
            }
        }
        this.logger.debug((Object)("serveresource reponse time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    private ResourceContainer getRepoService(URL serviceURL) {
        if (!this.repoMap.containsKey(serviceURL)) {
            this.logger.info((Object)("Building repo at [" + serviceURL + "]"));
            this.repoMap.put(serviceURL, ResourceContainerUtil.getResourceContainerService((URL)WSDL_REPO_URL, (URL)serviceURL));
        }
        return (ResourceContainer)this.repoMap.get(serviceURL);
    }

    private String getURIFromPoK(PieceOfKnowledge pok) {
        if (pok != null) {
            Statements map = this.rdfSelector.searchFor((Resource)pok, new String[]{POK_PROPERTY_DOC_URI});
            if (map != null && !map.entrySet().isEmpty()) {
                return (String)((IPredicateValuePairs)((Map.Entry)map.entrySet().iterator().next()).getValue()).getValue(POK_PROPERTY_DOC_URI);
            }
        } else {
            this.logger.error((Object)"Received Pok is null");
        }
        return null;
    }

    private String getTitleFromUnit(MediaUnit unit) {
        String title = null;
        Statements map = null;
        if (unit != null) {
            map = this.rdfSelector.searchFor((Resource)unit, new String[]{"http://purl.org/dc/elements/1.1/title"});
            if (map != null && map.get((Object)unit.getUri()) != null && ((IPredicateValuePairs)map.get((Object)unit.getUri())).getValue("http://purl.org/dc/elements/1.1/title") != null) {
                title = ((IPredicateValuePairs)map.get((Object)unit.getUri())).getValue("http://purl.org/dc/elements/1.1/title").toString();
            }
            if (title == null && (map = this.rdfSelector.searchFor((Resource)unit, new String[]{"http://weblab.ow2.org/core/1.2/ontology/processing#hasOriginalFileName"})) != null && map.get((Object)unit.getUri()) != null && ((IPredicateValuePairs)map.get((Object)unit.getUri())).getValue("http://weblab.ow2.org/core/1.2/ontology/processing#hasOriginalFileName") != null) {
                title = ((IPredicateValuePairs)map.get((Object)unit.getUri())).getValue("http://weblab.ow2.org/core/1.2/ontology/processing#hasOriginalFileName").toString();
            }
        }
        return title;
    }
}

