/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.portlet.tool;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import org.ow2.weblab.portlet.bean.LegendField;
import org.ow2.weblab.portlet.bean.NamedEntity;

public class MediaUnitLegend {
    public static String SAVE_LEGEND_SUBMIT = "save_legend";
    public static String LEGEND_COLOR_INPUT = "hidden_color_";
    public static String LEGEND_CHECKBOX_INPUT = "_showCheckBox";
    public static String LEGEND_CHECKBOX_COLOR = "checkbox_color_";
    private String appContext;
    private String styleContext;
    private String actionURL;
    private List<LegendField> fields;
    private Map<String, String> colorMap;
    private Map<String, String> styleMap;
    private Set<String> predicats;
    private Map<String, TreeSet<String>> predicatValuesMap;
    private Map<String, Boolean> checkedMap;

    public MediaUnitLegend() {
        this.colorMap = new HashMap();
        this.styleMap = new HashMap();
        this.checkedMap = new HashMap();
        this.predicats = new TreeSet();
        this.predicatValuesMap = new HashMap();
    }

    public MediaUnitLegend(List<LegendField> fields, String appContext, String styleContext) {
        this.fields = fields;
        this.appContext = appContext;
        this.styleContext = styleContext;
    }

    public String getHTMLLegend(boolean editable, ResourceBundle resourceBundle) {
        StringBuilder strBuf = new StringBuilder("<div id='");
        strBuf.append(this.styleContext);
        strBuf.append("_div_legend'>");
        strBuf.append("<fieldset title='Legend'");
        strBuf.append(" id='");
        strBuf.append(this.styleContext);
        strBuf.append("_div_legend_fieldset'");
        strBuf.append(" class='");
        strBuf.append(this.styleContext);
        strBuf.append("_div_legend_fieldset'>");
        strBuf.append("<legend>" + resourceBundle.getString("portlet.legend.title") + "</legend>");
        strBuf.append("<form id='");
        strBuf.append(this.styleContext);
        strBuf.append("_div_legend_fieldset_form'");
        strBuf.append("method='post' action='");
        strBuf.append(this.actionURL);
        strBuf.append("'>");
        strBuf.append("<table class='");
        strBuf.append(this.styleContext);
        strBuf.append("_div_legend_fieldset_form_table'>");
        strBuf.append("<tr><td><div class='instance_candidate_legend_box'><div> </div></div></td><td>&nbsp;" + resourceBundle.getString("portlet.legend.instance_candidate") + "</tr><br>");
        int i = 0;
        for (LegendField f : this.fields) {
            if (i % 3 == 0) {
                strBuf.append("<tr>");
            }
            strBuf.append("<td style='width=20'>");
            strBuf.append("<div class='");
            strBuf.append(this.styleContext);
            strBuf.append("_div_legend_box'>");
            strBuf.append("<div class='");
            strBuf.append(this.styleContext);
            strBuf.append(f.getStyleClassName());
            strBuf.append("_legend'");
            strBuf.append(" style='background-color:rgba(");
            strBuf.append(f.getStyleColor());
            strBuf.append(")' >&nbsp;");
            strBuf.append("</div>");
            strBuf.append("</div>");
            strBuf.append("</td>");
            strBuf.append("<td class='");
            strBuf.append(this.styleContext);
            strBuf.append("_entityType'>&nbsp;");
            if (resourceBundle.containsKey(f.getDisplayName())) {
                strBuf.append(resourceBundle.getString(f.getDisplayName()));
            } else {
                strBuf.append(f.getDisplayName());
            }
            strBuf.append("</td>");
            if (editable) {
                strBuf.append("<td>");
                strBuf.append("<img src='");
                strBuf.append(this.appContext);
                strBuf.append("/js/images/color.png' ");
                strBuf.append("width='16' alt='Change color' height='16'");
                strBuf.append(" onclick=\"jQuery.ColorPickerManager.OpenColorPicker2(");
                strBuf.append("'");
                strBuf.append(this.styleContext);
                strBuf.append(f.getStyleClassName());
                strBuf.append("',event)\" ");
                strBuf.append(" id='");
                strBuf.append(this.styleContext);
                strBuf.append(f.getStyleClassName());
                strBuf.append("picker'");
                strBuf.append(" class='use-colorpicker'/>");
                strBuf.append("</td>");
                strBuf.append("<td>");
                strBuf.append("&nbsp;&nbsp;");
                strBuf.append("<input type='checkbox' ");
                strBuf.append("id='");
                strBuf.append(this.styleContext);
                strBuf.append(f.getStyleClassName());
                strBuf.append(LEGEND_CHECKBOX_INPUT);
                strBuf.append("' onclick=\"jQuery.ColorPickerManager.ShowEntity('");
                strBuf.append(this.styleContext);
                strBuf.append(f.getStyleClassName());
                strBuf.append("')\" ");
                strBuf.append("name='");
                strBuf.append(LEGEND_CHECKBOX_COLOR);
                strBuf.append(this.styleContext);
                strBuf.append(f.getStyleClassName());
                strBuf.append("'");
                strBuf.append("value='yes' ");
                if (f.isShow()) {
                    strBuf.append("checked='true'");
                }
                strBuf.append(" >");
                strBuf.append("Show");
                strBuf.append("</input>");
                strBuf.append("<input type='hidden'");
                strBuf.append("id='");
                strBuf.append(LEGEND_COLOR_INPUT);
                strBuf.append(this.styleContext);
                strBuf.append(f.getStyleClassName());
                strBuf.append("' ");
                strBuf.append("value='");
                strBuf.append(f.getStyleColor());
                strBuf.append("'");
                strBuf.append("name='");
                strBuf.append(LEGEND_COLOR_INPUT);
                strBuf.append(this.styleContext);
                strBuf.append(f.getStyleClassName());
                strBuf.append("' >");
                strBuf.append("</td>");
            }
            if (i % 3 == 2) {
                strBuf.append("</tr>");
            }
            ++i;
        }
        strBuf.append("</table>");
        if (editable) {
            strBuf.append("<input name='");
            strBuf.append(SAVE_LEGEND_SUBMIT);
            strBuf.append("'");
            strBuf.append("type='submit'");
            strBuf.append("value='Save'>");
        }
        strBuf.append("</form>");
        strBuf.append("</fieldset>");
        strBuf.append("</div>");
        return strBuf.toString();
    }

    public String getColor(NamedEntity ne) {
        StringBuilder color = new StringBuilder();
        color.append((String)this.colorMap.get(ne.getEntityClassURI()));
        return color.toString();
    }

    public String getStyle(NamedEntity ne) {
        return (String)this.styleMap.get(ne.getEntityClassURI());
    }

    public boolean show(NamedEntity ne) {
        return (Boolean)this.checkedMap.get(ne.getEntityClassURI());
    }

    public Set<String> getPredicats() {
        return this.predicats;
    }

    public Set<String> getMachedValuesOnPredicat(String predicat) {
        return (Set)this.predicatValuesMap.get(predicat);
    }

    private void fieldsToMap() {
        for (LegendField field : this.fields) {
            String key = field.getEntityType();
            String matchedValue = field.getMatchedValue();
            String color = field.getStyleColor();
            String style = field.getStyleClassName();
            boolean check = field.isShow();
            if (this.predicatValuesMap.get(key) == null) {
                this.predicatValuesMap.put(key, new TreeSet());
            }
            if (matchedValue != null) {
                this.colorMap.put(key + "#" + matchedValue, color);
                this.styleMap.put(key + "#" + matchedValue, style);
                this.checkedMap.put(key + "#" + matchedValue, check);
                ((TreeSet)this.predicatValuesMap.get(key)).add(matchedValue);
            } else {
                this.colorMap.put(key, color);
                this.styleMap.put(key, style);
                this.checkedMap.put(key, check);
            }
            this.predicats.add(key);
        }
    }

    public String getColorInputName(LegendField field) {
        return LEGEND_COLOR_INPUT + this.styleContext + field.getStyleClassName();
    }

    public String getCheckBoxInputName(LegendField field) {
        return LEGEND_CHECKBOX_COLOR + this.styleContext + field.getStyleClassName();
    }

    public String getDisplayName(NamedEntity ne, ResourceBundle resourceBundle) {
        String classURI = ne.getEntityClassURI();
        for (LegendField field : this.fields) {
            if (!field.getEntityType().equals(classURI)) continue;
            return resourceBundle.getString(field.getDisplayName());
        }
        return null;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public void setAppContext(String appContext) {
        this.appContext = appContext;
    }

    public String getStyleContext() {
        return this.styleContext;
    }

    public void setStyleContext(String styleContext) {
        this.styleContext = styleContext;
    }

    public List<LegendField> getFields() {
        return this.fields;
    }

    public void setFields(List<LegendField> fields) {
        this.fields = fields;
        this.fieldsToMap();
    }

    public String getActionURL() {
        return this.actionURL;
    }

    public void setActionURL(String actionURL) {
        this.actionURL = actionURL;
    }

    public void updateShemColor() {
        this.fieldsToMap();
    }

    public Map<String, String> getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(Map<String, String> colorMap) {
        this.colorMap = colorMap;
    }

    public Map<String, String> getStyleMap() {
        return this.styleMap;
    }

    public void setStyleMap(Map<String, String> styleMap) {
        this.styleMap = styleMap;
    }

    public Map<String, Boolean> getCheckedMap() {
        return this.checkedMap;
    }

    public void setCheckedMap(Map<String, Boolean> checkedMap) {
        this.checkedMap = checkedMap;
    }
}

