/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.portlet.tool;

import java.util.ArrayList;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.Text;

public class MediaUnitSplitter {
    private MediaUnit mu;
    private int textSize;
    private int current_page;
    private int total_text_size;
    private int pageCount;

    public MediaUnitSplitter() {
        this.current_page = 1;
    }

    public MediaUnitSplitter(MediaUnit unit, int textSize) {
        this.mu = unit;
        this.textSize = textSize;
        this.current_page = 1;
        this.total_text_size = 0;
        this.getUnitTextSize();
        this.pageCount = this.total_text_size / textSize;
        if (this.total_text_size % textSize > 0) {
            ++this.pageCount;
        }
    }

    public int getCurrentPageStartOffset() {
        return (this.current_page - 1) * this.textSize;
    }

    public int getCurrentPageEndOffset() {
        if (this.current_page == this.pageCount) {
            return this.current_page * this.textSize + this.total_text_size - this.current_page * this.textSize;
        }
        return this.current_page * this.textSize;
    }

    public int nextPage() {
        if (this.current_page < this.pageCount) {
            ++this.current_page;
        }
        return this.current_page;
    }

    public int prevPage() {
        if (this.current_page > 0) {
            --this.current_page;
        }
        return this.current_page;
    }

    public int getAvaiblePageCount() {
        return this.pageCount;
    }

    public int getCurrentPageIndex() {
        return this.current_page;
    }

    public int setCurrentPageIndex(int currentPage) {
        if (currentPage > 0 && currentPage <= this.pageCount) {
            this.current_page = currentPage;
        }
        return this.current_page;
    }

    private void getUnitTextSize() {
        if (this.mu instanceof Document) {
            ArrayList<Text> subText = new ArrayList<Text>();
            for (MediaUnit subMU : ((Document)this.mu).getMediaUnit()) {
                if (!(subMU instanceof Text)) continue;
                subText.add((Text)subMU);
            }
            for (Text text : subText) {
                if (text.getContent() == null) continue;
                this.total_text_size += text.getContent().length();
            }
        } else if (this.mu instanceof Text && ((Text)this.mu).getContent() != null) {
            this.total_text_size = ((Text)this.mu).getContent().length();
        }
    }

    public MediaUnit getMediaUnit() {
        return this.mu;
    }

    public void setMediaUnit(MediaUnit mu) {
        this.mu = mu;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }
}

