/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.portlet;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.chain.ChainPortType;
import org.ow2.weblab.chain.ChainRequest;
import org.ow2.weblab.chain.ChainResponse;
import org.ow2.weblab.chain.ChainService;

public class LaunchChainPortlet
extends GenericPortlet {
    private ChainPortType chainPortType;
    private Log logger = LogFactory.getLog(LaunchChainPortlet.class);
    private static final String CONTEXT = "context";
    private static final String FILES_CONTEXT = "files";
    private static final String WARCS_CONTEXT = "warcs";

    public void init() throws PortletException {
        super.init();
        try {
            URL wsdlUrl = new File(this.getPortletContext().getRealPath("WEB-INF/classes/ChainDefinition.wsdl")).toURI().toURL();
            this.chainPortType = new ChainService(wsdlUrl, new QName("http://weblab.ow2.org/Chain/", "ChainService")).getChainEndpoint();
            Map context = ((BindingProvider)this.chainPortType).getRequestContext();
            context.put("javax.xml.ws.service.endpoint.address", this.getInitParameter("chain_url"));
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setTitle(ResourceBundle.getBundle("chain_launcher_portlet", request.getLocale()).getString("portlet.title"));
        PortletRequestDispatcher prdis = this.getPortletContext().getRequestDispatcher(this.getInitParameter("launch_page_url"));
        prdis.include(request, response);
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        try {
            String context = this.readContext(request);
            ChainRequest chainRequest = new ChainRequest();
            chainRequest.setContext(context);
            ChainResponse ret = this.chainPortType.process(chainRequest);
            request.setAttribute("res", (Object)ret);
            PortletRequestDispatcher prdis = this.getPortletContext().getRequestDispatcher(this.getInitParameter("res_page_url"));
            prdis.include((PortletRequest)request, (PortletResponse)response);
        }
        catch (Exception e) {
            PortletRequestDispatcher prdis = this.getPortletContext().getRequestDispatcher(this.getInitParameter("error_page_url"));
            request.setAttribute("message", (Object)e.getMessage());
            prdis.include((PortletRequest)request, (PortletResponse)response);
        }
    }

    private String readContext(ResourceRequest request) {
        String value = request.getParameter(CONTEXT);
        this.logger.debug((Object)("Received context is : " + value));
        String context = FILES_CONTEXT;
        if (value != null && value.equals(WARCS_CONTEXT)) {
            context = WARCS_CONTEXT;
        }
        this.logger.debug((Object)("Context uses : " + context));
        return context;
    }
}

