/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.demo.portlet;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;

import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;

import org.ow2.weblab.chain.ChainPortType;
import org.ow2.weblab.chain.ChainRequest;
import org.ow2.weblab.chain.ChainResponse;
import org.ow2.weblab.chain.ChainService;


public class LaunchChainPortlet extends GenericPortlet {

	protected ChainPortType chainDemoPortType;

	@Override
	public void init() throws PortletException {
		super.init();
		try {
			URL wsdlUrl = new File(getPortletContext().getRealPath(
					"WEB-INF/classes/ChainDemoDefinition.wsdl")).toURI().toURL();
			this.chainDemoPortType = new ChainService(wsdlUrl,
					new QName("http://weblab.ow2.org/Chain/",
							"ChainService")).getChainEndpoint();
			Map<String, Object> context = ((BindingProvider) this.chainDemoPortType)
					.getRequestContext();
			context.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
					getInitParameter("chain_url"));

		} catch (final Exception e) {
			throw new PortletException(e);
		}
	}

	@Override
	protected void doView(RenderRequest request, RenderResponse response)
			throws PortletException, IOException {
		/*
		 * changing portlet title
		 */
		response.setTitle(ResourceBundle.getBundle("chain_launcher_portlet",
				request.getLocale()).getString("portlet.title"));

		PortletRequestDispatcher rd = getPortletContext().getRequestDispatcher(
				getInitParameter("launch_page_url"));
		rd.include(request, response);
	}

	@Override
	public void serveResource(ResourceRequest request, ResourceResponse response)
			throws PortletException, IOException {
		try {
			ChainRequest chainDemoRequest = new ChainRequest();
			ChainResponse ret = this.chainDemoPortType
					.process(chainDemoRequest);
			request.setAttribute("res", ret);

			PortletRequestDispatcher rd = getPortletContext()
					.getRequestDispatcher(getInitParameter("res_page_url"));
			rd.include(request, response);
		} catch (final Exception e) {
			PortletRequestDispatcher rd = getPortletContext()
					.getRequestDispatcher(getInitParameter("error_page_url"));
			request.setAttribute("message", e.getMessage());
			rd.include(request, response);
		}

	}

}
