/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.demo.portlet;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.ow2.weblab.chain.ChainPortType;
import org.ow2.weblab.chain.ChainRequest;
import org.ow2.weblab.chain.ChainResponse;
import org.ow2.weblab.chain.ChainService;

public class LaunchChainPortlet
extends GenericPortlet {
    protected ChainPortType chainDemoPortType;

    public void init() throws PortletException {
        super.init();
        try {
            URL wsdlUrl = new File(this.getPortletContext().getRealPath("WEB-INF/classes/ChainDemoDefinition.wsdl")).toURI().toURL();
            this.chainDemoPortType = new ChainService(wsdlUrl, new QName("http://weblab.ow2.org/Chain/", "ChainService")).getChainEndpoint();
            Map context = ((BindingProvider)this.chainDemoPortType).getRequestContext();
            context.put("javax.xml.ws.service.endpoint.address", this.getInitParameter("chain_url"));
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setTitle(ResourceBundle.getBundle("chain_launcher_portlet", request.getLocale()).getString("portlet.title"));
        PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("launch_page_url"));
        rd.include(request, response);
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        try {
            ChainRequest chainDemoRequest = new ChainRequest();
            ChainResponse ret = this.chainDemoPortType.process(chainDemoRequest);
            request.setAttribute("res", (Object)ret);
            PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("res_page_url"));
            rd.include((PortletRequest)request, (PortletResponse)response);
        }
        catch (Exception e) {
            PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("error_page_url"));
            request.setAttribute("message", (Object)e.getMessage());
            rd.include((PortletRequest)request, (PortletResponse)response);
        }
    }
}

