/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.portlet;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.helper.impl.AdvancedSelector;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.helper.impl.RDFSelectorFactory;
import org.ow2.weblab.core.helper.impl.Statements;
import org.ow2.weblab.core.helper.impl.WTriple;
import org.ow2.weblab.core.model.ComposedResource;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.services.ResourceContainer;
import org.ow2.weblab.core.services.resourcecontainer.LoadResourceArgs;
import org.ow2.weblab.portlet.WebLabPortlet;
import org.ow2.weblab.portlet.bean.AnnotationsDescBean;
import org.ow2.weblab.portlet.bean.HitDescriptionBean;
import org.ow2.weblab.portlet.bean.RepoServiceConfigBean;
import org.ow2.weblab.portlet.bean.ResultConfBean;
import org.ow2.weblab.portlet.tool.ResourceContainerUtil;
import org.ow2.weblab.portlet.tool.ResourceRankFactory;
import org.ow2.weblab.portlet.tool.ResultSetSplitter;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;

public class ResultPortlet
extends WebLabPortlet {
    private static String LOADED_DOCUMENT_ACTION = "documentSelection";
    private static String NOT_LOADED_IMAGE_ACTION = "notLoadedImageSelection";
    private static String NOT_LOADED_DOCUMENT_ACTION = "notLoadedDocumentSelection";
    private static String LOADED_DOCUMENTS_ACTION = "documentsSelection";
    private static String NOT_LOADED_DOCUMENTS_ACTION = "notLoadedDocumentsSelection";
    private static String NEXT_RESULT_ACTION = "nextDocumentsSelection";
    private static final String ALL_NOT_LOADED_DOCUMENTS_GEO_ACTION = "viewNotLoadedDocumentsGeo";
    private static final String ALL_NOT_LOADED_DOCUMENTS_TIME_ACTION = "viewNotLoadedDocumentsTime";
    private static String DISPLAY_RESULTS = "displayResults";
    private static boolean USE_REDIRECTION = false;
    private static int RANK_DIGIT_NUMBER = 5;
    private static int MAX_DISPLAYED_RESOURCES = 5;
    private static int MAX_DISPLAYED_PAGES = 8;
    private static boolean loadResource;
    private static final String SORT_METHOD = "RANK";
    private static final String TITLE_RANK_MODE = "title - rank";
    private static final String DEFAULT_SORT_METHOD = "DEFAULT";
    private static final String HIT_PROPERTY = "http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit";
    private static final String USER_RESULT_SET = "resultSet";
    private static final String DISPLAY_MODE = "display_mode";
    private static final String USER_RESULTSET_SPLITTER = "user_rs_splitter";
    private static final String META_CONF_BEAN_ID = "meta_conf_bean";
    private static final String DEFAULT_REPO_BEAN = "repo_conf_bean";
    public static final String LOAD_RESOURCE_ACTION = "load_resource_uri";
    public static final String SELECTED_RESOURCES = "selected_res";
    private static final String UPDATE_SPLITTER_ACTION = "next_splitter_position";
    public static final String RESULTS_MAP_DESC = "resultSet_desc";
    public static ResultConfBean DEFAULT_META_CONF_BEAN;
    public static final String USER_META_CONF = "meta_conf_bean";
    public static final String USER_REPO_CONF = "user_repo_service_conf";
    public static final String ERROR = "message_error";
    private Map<URL, ResourceContainer> repoMap;
    private AnnotationsDescBean rdfProperties;
    private Log logger = LogFactory.getLog(this.getClass());
    private static URL WSDL_REPO_URL;
    private static final String EXPOSED_PROPERTY = "http://weblab.ow2.org/core/1.2/ontology/processing#isExposedAsThumbnail";
    private static final String LINKED_TO_RELEVANT_MU = "http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedToRelevantMediaUnit";

    public void init() throws PortletException {
        super.init();
        this.repoMap = new HashMap();
        try {
            WSDL_REPO_URL = new File(this.getPortletContext().getRealPath("WEB-INF/classes/services/WebLab.wsdl")).toURI().toURL();
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)e);
        }
        ClassPathResource resource = new ClassPathResource("result_portlet_meta.xml");
        XmlBeanFactory factory = new XmlBeanFactory((org.springframework.core.io.Resource)resource);
        this.rdfProperties = (AnnotationsDescBean)factory.getBean("resultPortletMeta", AnnotationsDescBean.class);
        loadResource = this.getInitParameter("load_resources_on_repository") != null ? Boolean.parseBoolean(this.getInitParameter("load_resources_on_repository")) : false;
        if (this.getInitParameter("rank_digit_number") != null) {
            RANK_DIGIT_NUMBER = Integer.parseInt(this.getInitParameter("rank_digit_number"));
        }
        if (this.getInitParameter("max_displayed_resources") != null) {
            MAX_DISPLAYED_RESOURCES = Integer.parseInt(this.getInitParameter("max_displayed_resources"));
        }
        if (this.getInitParameter("max_displayed_pages") != null) {
            MAX_DISPLAYED_PAGES = Integer.parseInt(this.getInitParameter("max_displayed_pages"));
        }
        USE_REDIRECTION = this.getInitParameter("use_redirection") != null ? Boolean.parseBoolean(this.getInitParameter("use_redirection")) : false;
        DEFAULT_META_CONF_BEAN = (ResultConfBean)factory.getBean("meta_conf_bean", ResultConfBean.class);
    }

    public void destroy() {
        this.repoMap = null;
        this.rdfProperties = null;
        super.destroy();
    }

    public void doView(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        long start = System.currentTimeMillis();
        boolean sessionExpired = false;
        res.setTitle(ResourceBundle.getBundle("result_portlet", req.getLocale()).getString("portlet.title"));
        if (req.getPortletSession().getLastAccessedTime() + (long)(req.getPortletSession().getMaxInactiveInterval() * 1000) < System.currentTimeMillis()) {
            sessionExpired = true;
            req.setAttribute("message_warning", (Object)ResourceBundle.getBundle("result_portlet", req.getLocale()).getString("portlet.warning.session_expired"));
        }
        if (!sessionExpired) {
            if (req.getParameter(ERROR) != null) {
                req.setAttribute(ERROR, (Object)req.getParameter(ERROR));
                PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("error_page_url"));
                rd.include(req, res);
            }
            ResultSet resultset = (ResultSet)req.getPortletSession().getAttribute(USER_RESULT_SET, 1);
            ResultSetSplitter splitter = (ResultSetSplitter)req.getPortletSession().getAttribute(USER_RESULTSET_SPLITTER, 1);
            if (resultset != null) {
                String[] properties = new String[]{"http://weblab.ow2.org/core/1.2/ontology/retrieval#hasNumberOfResults", "http://www.w3.org/2000/01/rdf-schema#label"};
                AdvancedSelector rdfSelector = RDFSelectorFactory.getSelector((boolean)true, (String[])new String[0]);
                Statements map = rdfSelector.searchFor((Resource)resultset, properties);
                req.setAttribute("hasNumberOfResults", map.getTypedValue(resultset.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasNumberOfResults", Integer.class));
                if (splitter != null) {
                    req.setAttribute("current_split_pos", (Object)splitter.getCurrentPosition());
                    req.setAttribute("max_positions", (Object)splitter.getAvaibleSubResourcesNumber());
                    if (splitter.getSortMethod().equals(DEFAULT_SORT_METHOD)) {
                        req.setAttribute("not_sortable", (Object)true);
                    }
                }
            }
            PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("result_page_url"));
            rd.include(req, res);
        } else {
            PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("warning_page_url"));
            rd.include(req, res);
        }
        this.logger.info((Object)("doView reponse time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    public void doEdit(RenderRequest req, RenderResponse res) throws PortletException, IOException {
        long start = System.currentTimeMillis();
        ResultConfBean metaConfbean = req.getPortletSession().getAttribute("meta_conf_bean", 1) == null ? DEFAULT_META_CONF_BEAN : (ResultConfBean)req.getPortletSession().getAttribute("meta_conf_bean", 1);
        req.setAttribute("meta_conf_bean", (Object)metaConfbean);
        RepoServiceConfigBean repoConfBean = req.getPortletSession().getAttribute(USER_REPO_CONF, 1) == null ? new RepoServiceConfigBean() : (RepoServiceConfigBean)req.getPortletSession().getAttribute(USER_REPO_CONF, 1);
        req.setAttribute(USER_REPO_CONF, (Object)repoConfBean);
        PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("edit_page_url"));
        rd.include(req, res);
        this.logger.info((Object)("doEdit reponse time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    public void processEvent(EventRequest req, EventResponse resp) throws PortletException, IOException {
        long start = System.currentTimeMillis();
        req.getPortletSession().removeAttribute(ERROR);
        this.logger.debug((Object)("Event received : " + req.getEvent()));
        if (req.getEvent() != null && req.getEvent().getValue() instanceof ResultSet) {
            ResultSet receveidResultSet;
            if (this.getReaction(req.getEvent().getQName()).getLocalPart().equals(DISPLAY_RESULTS)) {
                receveidResultSet = (ResultSet)req.getEvent().getValue();
                this.logger.info((Object)("Event received, a new query : " + receveidResultSet));
                AdvancedSelector rdfSelector = RDFSelectorFactory.getSelector((boolean)true, (String[])new String[0]);
                boolean isSortable = !rdfSelector.searchFor((Resource)receveidResultSet, new String[]{"http://weblab.ow2.org/core/1.2/ontology/retrieval#hasRank"}).isEmpty();
                ResultSetSplitter splitter = null;
                if (isSortable) {
                    this.logger.info((Object)"processEvent : creating splitter with rank sort method");
                    splitter = new ResultSetSplitter(receveidResultSet, MAX_DISPLAYED_RESOURCES, this.rdfProperties, SORT_METHOD);
                    this.logger.info((Object)("processEvent reponse time (creating splitter with rank sort method):" + Long.toString(System.currentTimeMillis() - start)));
                } else {
                    this.logger.info((Object)"processEvent : creating splitter with default sort method");
                    try {
                        splitter = new ResultSetSplitter(receveidResultSet, MAX_DISPLAYED_RESOURCES, this.rdfProperties, DEFAULT_SORT_METHOD);
                    }
                    catch (Exception e) {
                        req.getPortletSession().setAttribute(ERROR, (Object)"Unable to process received result", 1);
                        req.getPortletSession().removeAttribute(USER_RESULTSET_SPLITTER, 1);
                        req.getPortletSession().removeAttribute(USER_RESULT_SET, 1);
                        this.logger.error((Object)("unable to create splitter from received resultSet" + e.getMessage()));
                    }
                    this.logger.info((Object)("processEvent reponse time (creating splitter with default sort):" + Long.toString(System.currentTimeMillis() - start)));
                }
                if (splitter != null) {
                    req.getPortletSession().setAttribute(USER_RESULTSET_SPLITTER, (Object)splitter, 1);
                    if (!splitter.currentSplitIsInMemory() && splitter.getAvaibleSubResourcesNumber() > 0) {
                        this.logger.info((Object)("resultset is too small : " + receveidResultSet));
                        this.sendEventForAction(NEXT_RESULT_ACTION, (Resource)splitter.getCurrentSplitPOK(), resp);
                    }
                    req.getPortletSession().setAttribute(USER_RESULT_SET, (Object)receveidResultSet, 1);
                }
            }
            if (this.getReaction(req.getEvent().getQName()).getLocalPart().equals("updateResults")) {
                receveidResultSet = (ResultSet)req.getEvent().getValue();
                this.logger.info((Object)("Event received, updating Resultset : " + receveidResultSet));
                ((ResultSetSplitter)req.getPortletSession().getAttribute(USER_RESULTSET_SPLITTER, 1)).updateResultSet(receveidResultSet);
                this.logger.info((Object)("processEvent reponse time (updating splitter):" + Long.toString(System.currentTimeMillis() - start)));
            }
        }
        this.logger.info((Object)("processEvent reponse time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        long start = System.currentTimeMillis();
        this.logger.info((Object)"Process action....");
        if (request.getParameter("visualize_all") != null) {
            String action = request.getParameter("visualize_all");
            if (action != null && (action.equals("viewTime") || action.equals("viewGeo"))) {
                this.logger.info((Object)("Process action : " + action));
                ResultSet rs = (ResultSet)request.getPortletSession().getAttribute(USER_RESULT_SET, 1);
                PieceOfKnowledge pok = (PieceOfKnowledge)ResourceFactory.createResource((String)"resultporlet", (String)("" + System.nanoTime()), PieceOfKnowledge.class);
                JenaPoKHelper h = new JenaPoKHelper(pok);
                h.setAutoCommitMode(false);
                AdvancedSelector rdfSelector = RDFSelectorFactory.getSelector((boolean)true, (String[])new String[0]);
                List list = rdfSelector.findInResource((Resource)rs, null, "http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedTo", null);
                for (WTriple wtriple : list) {
                    String hitURI = "http://weblab.ow2.org/portlet/resultportlet/" + System.nanoTime();
                    h.createResStat(hitURI, "http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedTo", wtriple.getObject());
                    h.createResStat(hitURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", HIT_PROPERTY);
                }
                h.commit();
                String redirection_uri = ALL_NOT_LOADED_DOCUMENTS_GEO_ACTION;
                if (action.equals("viewTime")) {
                    redirection_uri = ALL_NOT_LOADED_DOCUMENTS_TIME_ACTION;
                }
                if (USE_REDIRECTION) {
                    this.sendEventForActionAndRedirect(redirection_uri, (Resource)pok, response);
                } else {
                    this.sendEventForAction(redirection_uri, (Resource)pok, response);
                }
            }
        } else {
            JenaPoKHelper h;
            PieceOfKnowledge pok;
            RepoServiceConfigBean repo_conf;
            String form_name = request.getParameter("form_name");
            if (form_name != null && form_name.equals("meta_conf_form")) {
                this.logger.info((Object)"meta config update");
                ResultConfBean newConf = this.getMetaBean(request);
                request.getPortletSession().setAttribute("meta_conf_bean", (Object)newConf, 1);
                response.setPortletMode(PortletMode.VIEW);
            }
            if (form_name != null && form_name.equals(DEFAULT_REPO_BEAN)) {
                request.getPortletSession().removeAttribute(ERROR);
                this.logger.info((Object)"repo config update");
                RepoServiceConfigBean rc = (RepoServiceConfigBean)request.getPortletSession().getAttribute(USER_REPO_CONF, 1);
                Object newConf = null;
                if (rc == null) {
                    repo_conf = new RepoServiceConfigBean();
                    repo_conf.setServiceURL(this.getInitParameter("repo_service_url"));
                }
                request.getPortletSession().setAttribute(USER_REPO_CONF, newConf, 1);
                response.setPortletMode(PortletMode.VIEW);
            }
            if (request.getParameter(LOAD_RESOURCE_ACTION) != null) {
                if (loadResource) {
                    boolean loaded = false;
                    String uri = URLDecoder.decode(request.getParameter(LOAD_RESOURCE_ACTION), "UTF-8");
                    this.logger.info((Object)("new resource to load : " + uri));
                    LoadResourceArgs args = new LoadResourceArgs();
                    args.setResourceId(uri);
                    Resource loadedResource = null;
                    if (request.getPortletSession().getAttribute(USER_REPO_CONF, 1) == null) {
                        RepoServiceConfigBean repo_conf2 = new RepoServiceConfigBean();
                        repo_conf2.setServiceURL(this.getInitParameter("repo_service_url"));
                        request.getPortletSession().setAttribute(USER_REPO_CONF, (Object)repo_conf2, 1);
                    }
                    URL repoURL = new URL(((RepoServiceConfigBean)request.getPortletSession().getAttribute(USER_REPO_CONF, 1)).getServiceURL());
                    try {
                        ResourceContainer repo = this.getRepoService(repoURL);
                        loadedResource = repo.loadResource(args).getResource();
                        loaded = true;
                    }
                    catch (Exception e) {
                        loaded = false;
                        this.logger.error((Object)e);
                        request.getPortletSession().setAttribute(ERROR, (Object)"Unable to get resource on repository service");
                    }
                    if (loaded) {
                        if (loadedResource == null) {
                            loadedResource = ResourceFactory.createResource((String)"temporary", (String)("" + System.nanoTime()), Document.class);
                        }
                        if (loadedResource instanceof Document) {
                            if (USE_REDIRECTION) {
                                this.sendEventForActionAndRedirect(LOADED_DOCUMENT_ACTION, loadedResource, response);
                            } else {
                                this.sendEventForAction(LOADED_DOCUMENT_ACTION, loadedResource, response);
                            }
                        }
                    }
                } else {
                    String isLinkedTo = URLDecoder.decode(request.getParameter(LOAD_RESOURCE_ACTION), "UTF-8");
                    String[] selectedResourceURISplitRelevant = isLinkedTo.split("@relevantMu:");
                    String linkedRelevantMU = null;
                    if (selectedResourceURISplitRelevant.length > 1) {
                        isLinkedTo = selectedResourceURISplitRelevant[0];
                        linkedRelevantMU = selectedResourceURISplitRelevant[1];
                    }
                    this.logger.info((Object)("unloaded selection , pok about :" + isLinkedTo));
                    pok = (PieceOfKnowledge)ResourceFactory.createResource((String)"resultporlet", (String)("" + System.nanoTime()), PieceOfKnowledge.class);
                    h = new JenaPoKHelper(pok);
                    h.setAutoCommitMode(false);
                    String hitURI = "http://weblab.ow2.org/portlet/resultportlet/" + System.nanoTime();
                    h.createResStat(hitURI, "http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedTo", isLinkedTo);
                    if (linkedRelevantMU != null && !linkedRelevantMU.equals("")) {
                        h.createResStat(hitURI, LINKED_TO_RELEVANT_MU, linkedRelevantMU);
                    }
                    h.createResStat(hitURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", HIT_PROPERTY);
                    h.commit();
                    String format = "";
                    if (request.getPortletSession().getAttribute(USER_RESULTSET_SPLITTER, 1) != null) {
                        ResultSetSplitter rsp = (ResultSetSplitter)request.getPortletSession().getAttribute(USER_RESULTSET_SPLITTER, 1);
                        for (Map.Entry hit : rsp.getCurrentWTripleMap().getDescriptionMap().entrySet()) {
                            if (!((List)((HashMap)hit.getValue()).get("http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedTo")).contains(isLinkedTo)) continue;
                            if (!((HashMap)hit.getValue()).containsKey("http://purl.org/dc/elements/1.1/format")) break;
                            format = (String)((List)((HashMap)hit.getValue()).get("http://purl.org/dc/elements/1.1/format")).get(0);
                            break;
                        }
                    }
                    this.logger.debug((Object)("selected resource type is:" + format));
                    if (USE_REDIRECTION) {
                        if (format.contains("jpeg") || format.contains("png") || format.contains("bmp") || format.contains("gif")) {
                            this.sendEventForActionAndRedirect(NOT_LOADED_IMAGE_ACTION, (Resource)pok, response);
                        } else {
                            this.sendEventForActionAndRedirect(NOT_LOADED_DOCUMENT_ACTION, (Resource)pok, response);
                        }
                    } else if (format.contains("jpeg") || format.contains("png") || format.contains("bmp") || format.contains("gif")) {
                        this.sendEventForAction(NOT_LOADED_IMAGE_ACTION, (Resource)pok, response);
                    } else {
                        this.sendEventForAction(NOT_LOADED_DOCUMENT_ACTION, (Resource)pok, response);
                    }
                }
            }
            if (request.getParameter(SELECTED_RESOURCES) != null && request.getParameter(SELECTED_RESOURCES) != "") {
                ComposedResource collect = (ComposedResource)ResourceFactory.createResource((String)(this.getDefaultNamespace() + this.getPortletName()), (String)"CollectionSelection", ComposedResource.class);
                List l = collect.getResource();
                if (loadResource) {
                    if (request.getPortletSession().getAttribute(USER_REPO_CONF, 1) == null) {
                        repo_conf = new RepoServiceConfigBean();
                        repo_conf.setServiceURL(this.getInitParameter("repo_service_url"));
                        request.getPortletSession().setAttribute(USER_REPO_CONF, (Object)repo_conf, 1);
                    }
                    URL repoURL = new URL(((RepoServiceConfigBean)request.getPortletSession().getAttribute(USER_REPO_CONF, 1)).getServiceURL());
                    ResourceContainer repo = this.getRepoService(repoURL);
                    for (String selectedResourceURI : request.getParameterValues(SELECTED_RESOURCES)) {
                        String uri = URLDecoder.decode(selectedResourceURI, "UTF-8");
                        this.logger.info((Object)("new resource to load : " + uri));
                        LoadResourceArgs args = new LoadResourceArgs();
                        args.setResourceId(uri);
                        try {
                            l.add(repo.loadResource(args).getResource());
                        }
                        catch (Exception e) {
                            this.logger.error((Object)e);
                            response.setRenderParameter(ERROR, "Unable to get resource on repository service");
                        }
                    }
                    if (USE_REDIRECTION) {
                        this.sendEventForActionAndRedirect(LOADED_DOCUMENTS_ACTION, (Resource)collect, response);
                    } else {
                        this.sendEventForAction(LOADED_DOCUMENTS_ACTION, (Resource)collect, response);
                    }
                } else {
                    String[] parameters = request.getParameterValues(SELECTED_RESOURCES)[0].split(",");
                    pok = (PieceOfKnowledge)ResourceFactory.createResource((String)"resultporlet", (String)("" + System.nanoTime()), PieceOfKnowledge.class);
                    h = new JenaPoKHelper(pok);
                    h.setAutoCommitMode(false);
                    ResultSetSplitter splitter = (ResultSetSplitter)request.getPortletSession().getAttribute(USER_RESULTSET_SPLITTER, 1);
                    HitDescriptionBean hitDesc = splitter.getCurrentWTripleMap();
                    for (String selectedResourceURI : parameters) {
                        selectedResourceURI = URLDecoder.decode(selectedResourceURI, "UTF-8");
                        String[] selectedResourceURISplitRelevant = selectedResourceURI.split("@relevantMu:");
                        String linkedRelevantMU = null;
                        if (selectedResourceURISplitRelevant.length > 1) {
                            selectedResourceURI = selectedResourceURISplitRelevant[0];
                            linkedRelevantMU = selectedResourceURISplitRelevant[1];
                        }
                        this.logger.debug((Object)selectedResourceURI);
                        String hitURI = "http://weblab.ow2.org/portlet/resultportlet/selectedHit" + System.nanoTime();
                        h.createResStat(hitURI, "http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedTo", selectedResourceURI);
                        h.createResStat(hitURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", HIT_PROPERTY);
                        if (linkedRelevantMU != null && !linkedRelevantMU.equals("")) {
                            h.createResStat(hitURI, LINKED_TO_RELEVANT_MU, linkedRelevantMU);
                        }
                        for (Map.Entry entry : hitDesc.getDescriptionMap().entrySet()) {
                            if (!((String)((List)((HashMap)entry.getValue()).get("http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedTo")).get(0)).equals(selectedResourceURI)) continue;
                            String title = null;
                            if (((HashMap)entry.getValue()).get("http://purl.org/dc/elements/1.1/title") != null && !((List)((HashMap)entry.getValue()).get("http://purl.org/dc/elements/1.1/title")).isEmpty()) {
                                title = (String)((List)((HashMap)entry.getValue()).get("http://purl.org/dc/elements/1.1/title")).get(0);
                            }
                            String fileName = null;
                            if (((HashMap)entry.getValue()).get("http://weblab.ow2.org/core/1.2/ontology/processing#hasOriginalFileName") != null && !((List)((HashMap)entry.getValue()).get("http://weblab.ow2.org/core/1.2/ontology/processing#hasOriginalFileName")).isEmpty()) {
                                fileName = (String)((List)((HashMap)entry.getValue()).get("http://weblab.ow2.org/core/1.2/ontology/processing#hasOriginalFileName")).get(0);
                            }
                            String format = null;
                            if (((HashMap)entry.getValue()).get("http://purl.org/dc/elements/1.1/format") != null && !((List)((HashMap)entry.getValue()).get("http://purl.org/dc/elements/1.1/format")).isEmpty()) {
                                format = (String)((List)((HashMap)entry.getValue()).get("http://purl.org/dc/elements/1.1/format")).get(0);
                            }
                            String thumbnail = null;
                            if (((HashMap)entry.getValue()).get(EXPOSED_PROPERTY) != null && !((List)((HashMap)entry.getValue()).get(EXPOSED_PROPERTY)).isEmpty()) {
                                thumbnail = (String)((List)((HashMap)entry.getValue()).get(EXPOSED_PROPERTY)).get(0);
                            }
                            if (title != null && !title.equals("")) {
                                h.createLitStat(hitURI, "http://purl.org/dc/elements/1.1/title", title);
                            }
                            if (fileName != null && !fileName.equals("")) {
                                h.createLitStat(hitURI, "http://weblab.ow2.org/core/1.2/ontology/processing#hasOriginalFileName", fileName);
                            }
                            if (format != null && !format.equals("")) {
                                h.createLitStat(hitURI, "http://purl.org/dc/elements/1.1/format", format);
                            }
                            if (thumbnail == null || thumbnail.equals("")) continue;
                            h.createLitStat(hitURI, EXPOSED_PROPERTY, thumbnail);
                        }
                    }
                    h.commit();
                    if (USE_REDIRECTION) {
                        this.sendEventForActionAndRedirect(NOT_LOADED_DOCUMENTS_ACTION, (Resource)pok, response);
                    } else {
                        this.sendEventForAction(NOT_LOADED_DOCUMENTS_ACTION, (Resource)pok, response);
                    }
                }
            }
            if (request.getParameter(UPDATE_SPLITTER_ACTION) != null) {
                int splitterPosition = Integer.parseInt(request.getParameter(UPDATE_SPLITTER_ACTION));
                this.logger.debug((Object)("Processing Action update splitter: " + splitterPosition));
                ResultSetSplitter splitter = (ResultSetSplitter)request.getPortletSession().getAttribute(USER_RESULTSET_SPLITTER, 1);
                if (splitter != null) {
                    splitter.setCurrentPageIndex(splitterPosition);
                    if (!splitter.isInMemory(splitterPosition)) {
                        this.sendEventForAction(NEXT_RESULT_ACTION, (Resource)splitter.getCurrentSplitPOK(), response);
                    }
                } else {
                    this.logger.debug((Object)"Splitter is NULL.");
                }
                this.logger.debug((Object)"Update splitter done.");
            }
            this.logger.info((Object)("processAction reponse time :" + Long.toString(System.currentTimeMillis() - start)));
        }
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        PortletRequestDispatcher rd;
        long start = System.currentTimeMillis();
        response.setContentType("text/html");
        boolean error = false;
        String messageError = null;
        ResultSetSplitter splitter = (ResultSetSplitter)request.getPortletSession().getAttribute(USER_RESULTSET_SPLITTER, 1);
        if (splitter != null && splitter.getAvaibleSubResourcesNumber() > 0) {
            if (request.getParameter("splitter_position") != null) {
                splitter.setCurrentPageIndex(Integer.parseInt(request.getParameter("splitter_position")));
            }
            HitDescriptionBean hitsDescription = splitter.getCurrentWTripleMap();
            this.logger.debug((Object)("result map : " + hitsDescription));
            if (hitsDescription == null || hitsDescription.getDescriptionMap() == null) {
                error = true;
                messageError = ResourceBundle.getBundle("result_portlet", request.getLocale()).getString("resultset.unvalid");
                this.logger.error((Object)("unable to get hits description Map null or empty :" + hitsDescription));
            } else {
                request.setAttribute(RESULTS_MAP_DESC, (Object)hitsDescription.getDescriptionMap());
                ResultConfBean res_conf = (ResultConfBean)request.getPortletSession().getAttribute("meta_conf_bean", 1);
                if (res_conf == null) {
                    request.setAttribute("meta_conf_bean", (Object)DEFAULT_META_CONF_BEAN);
                } else {
                    request.setAttribute("meta_conf_bean", (Object)res_conf);
                }
                request.setAttribute("current_split_pos", (Object)splitter.getCurrentPosition());
                HashMap<Integer, Boolean> isInMemory = new HashMap<Integer, Boolean>();
                int min_position = splitter.getCurrentPosition() - MAX_DISPLAYED_PAGES / 2;
                int max_position = splitter.getCurrentPosition() + MAX_DISPLAYED_PAGES / 2;
                if (min_position < 1) {
                    min_position = 1;
                }
                if (max_position > splitter.getTotalNumberOfResources()) {
                    max_position = splitter.getTotalNumberOfResources();
                }
                for (int i = min_position; i <= max_position; ++i) {
                    isInMemory.put(i, splitter.isInMemory(i));
                }
                request.setAttribute("isInMemory", isInMemory);
                request.setAttribute("min_position", (Object)min_position);
                request.setAttribute("max_position", (Object)max_position);
                request.setAttribute("last_splitter_pos", (Object)splitter.getAvaibleSubResourcesNumber());
                if (RANK_DIGIT_NUMBER > 0) {
                    request.setAttribute("rankBean", (Object)ResourceRankFactory.getResourceRankBean((HashMap)hitsDescription.getDescriptionMap(), (int)RANK_DIGIT_NUMBER));
                }
                request.setAttribute("rdfProperties", (Object)this.rdfProperties.getProperties());
                request.setAttribute(DISPLAY_MODE, (Object)TITLE_RANK_MODE);
            }
        }
        if (error) {
            request.setAttribute(ERROR, messageError);
            rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("error_page_url"));
            rd.include((PortletRequest)request, (PortletResponse)response);
        } else {
            rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("resources_page_url"));
            rd.include((PortletRequest)request, (PortletResponse)response);
            this.logger.info((Object)("serveResource reponse time :" + Long.toString(System.currentTimeMillis() - start)));
        }
    }

    private ResourceContainer getRepoService(URL serviceURL) {
        if (!this.repoMap.containsKey(serviceURL)) {
            this.logger.info((Object)("Building repo at [" + serviceURL + "]"));
            this.repoMap.put(serviceURL, ResourceContainerUtil.getResourceContainerService((URL)WSDL_REPO_URL, (URL)serviceURL));
        }
        return (ResourceContainer)this.repoMap.get(serviceURL);
    }

    private ResultConfBean getMetaBean(ActionRequest request) {
        ResultConfBean ret = new ResultConfBean();
        for (String property : DEFAULT_META_CONF_BEAN.getProperties().keySet()) {
            if (request.getParameter(property) != null) {
                ret.getProperties().put(property, true);
                continue;
            }
            ret.getProperties().put(property, false);
        }
        return ret;
    }
}

