/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.portlet.tool;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.helper.impl.AdvancedSelector;
import org.ow2.weblab.core.helper.impl.IPredicateValuePairs;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.helper.impl.RDFSelectorFactory;
import org.ow2.weblab.core.helper.impl.Statements;
import org.ow2.weblab.core.helper.impl.WTriple;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.portlet.bean.AnnotationsDescBean;
import org.ow2.weblab.portlet.bean.HitDescriptionBean;

public class ResultSetSplitter {
    private String SORT_METHOD;
    private static final String OFFSET_PROPERTY = "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasExpectedOffset";
    private static final String LIMIT_PROPERTY = "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasExpectedLimit";
    private int splitSize;
    private int totalNumberOfResults;
    private int totalSplitterPartNumber;
    private String queryURI;
    private int currentPosition;
    private AnnotationsDescBean descBean;
    private HitDescriptionBean allRSMap;
    private AdvancedSelector rdfSelector;
    private Log logger = LogFactory.getLog(this.getClass());

    public ResultSetSplitter() {
    }

    public ResultSetSplitter(ResultSet rs, int splitSize, AnnotationsDescBean annotDesc, String sortMethod) {
        this.SORT_METHOD = sortMethod;
        this.descBean = annotDesc;
        this.splitSize = splitSize;
        this.rdfSelector = RDFSelectorFactory.getSelector((boolean)true, (String[])new String[0]);
        this.allRSMap = new HitDescriptionBean();
        Statements fullResutSetDecMap = this.rdfSelector.searchFor((Resource)rs, annotDesc.getDisctinctAnnotationsNS());
        this.totalNumberOfResults = (Integer)this.rdfSelector.searchFor((Resource)rs, new String[]{"http://weblab.ow2.org/core/1.2/ontology/retrieval#hasNumberOfResults"}).getTypedValue(rs.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasNumberOfResults", Integer.class);
        this.logger.info((Object)("totalNumberOfResults: " + this.totalNumberOfResults));
        this.totalSplitterPartNumber = (int)Math.ceil((float)this.totalNumberOfResults / (float)this.splitSize);
        this.currentPosition = 1;
        this.queryURI = (String)((IPredicateValuePairs)this.rdfSelector.searchFor((Resource)rs, new String[]{"http://weblab.ow2.org/core/1.2/ontology/retrieval#isResultOf"}).get((Object)rs.getUri())).getValue("http://weblab.ow2.org/core/1.2/ontology/retrieval#isResultOf");
        if (this.SORT_METHOD.equals("DEFAULT")) {
            this.fillMapDefault(fullResutSetDecMap);
        } else {
            this.fillMapByRank(fullResutSetDecMap);
        }
    }

    public HitDescriptionBean getWTripleMap(int splitNumber) {
        HitDescriptionBean res = new HitDescriptionBean();
        this.logger.debug((Object)("Asking for index:" + splitNumber));
        if (this.isInMemory(splitNumber)) {
            int startOffset = splitNumber == 1 ? 1 : (splitNumber - 1) * this.splitSize + 1;
            int endOffset = splitNumber == this.totalSplitterPartNumber ? this.totalNumberOfResults : startOffset + this.splitSize - 1;
            for (int i = startOffset; i <= endOffset; ++i) {
                res.getDescriptionMap().put(Integer.toString(i), this.allRSMap.getDescriptionMap().get(Integer.toString(i)));
            }
            return res;
        }
        return null;
    }

    public HitDescriptionBean getCurrentWTripleMap() {
        return this.getWTripleMap(this.currentPosition);
    }

    public int nextPosition() {
        if (this.currentPosition < this.totalSplitterPartNumber) {
            ++this.currentPosition;
        }
        return this.currentPosition;
    }

    public int prevPostion() {
        if (this.currentPosition > 1) {
            --this.currentPosition;
        }
        return this.currentPosition;
    }

    public int getAvaibleSubResourcesNumber() {
        return this.totalSplitterPartNumber;
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public int setCurrentPageIndex(int currentPosition) {
        if (currentPosition > 0 && currentPosition <= this.totalSplitterPartNumber) {
            this.currentPosition = currentPosition;
        }
        return this.currentPosition;
    }

    public int getTotalNumberOfResources() {
        return this.totalSplitterPartNumber;
    }

    public boolean isInMemory(int splitNumber) {
        int startOffset = splitNumber == 1 ? 1 : (splitNumber - 1) * this.splitSize + 1;
        int endOffset = splitNumber == this.totalSplitterPartNumber ? this.totalNumberOfResults : startOffset + this.splitSize - 1;
        this.logger.debug((Object)(startOffset + " - " + endOffset + this.allRSMap));
        if (startOffset == endOffset) {
            return this.allRSMap.getDescriptionMap().containsKey(Integer.toString(startOffset));
        }
        for (int i = startOffset; i < endOffset; ++i) {
            if (this.allRSMap.getDescriptionMap().containsKey(Integer.toString(i))) continue;
            return false;
        }
        return true;
    }

    public boolean currentSplitIsInMemory() {
        return this.isInMemory(this.currentPosition);
    }

    public void updateResultSet(ResultSet rs) {
        Statements fullResutSetDecMap = this.rdfSelector.searchFor((Resource)rs, new String[0]);
        if (this.SORT_METHOD.equals("RANK")) {
            this.fillMapByRank(fullResutSetDecMap);
        } else if (this.SORT_METHOD.equals("DEFAULT")) {
            this.fillMapDefault(fullResutSetDecMap);
        }
        int nbRes = (Integer)this.rdfSelector.searchFor((Resource)rs, new String[]{"http://weblab.ow2.org/core/1.2/ontology/retrieval#hasNumberOfResults"}).getTypedValue(null, "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasNumberOfResults", Integer.class);
        this.totalSplitterPartNumber = (int)Math.ceil((float)nbRes / (float)this.splitSize);
    }

    public PieceOfKnowledge getPOK(int splitNumber) {
        if (this.isInMemory(splitNumber)) {
            return null;
        }
        int startOffset = splitNumber == 1 ? 0 : (splitNumber - 1) * this.splitSize;
        PieceOfKnowledge pok = (PieceOfKnowledge)ResourceFactory.createResource((String)"resultporlet", (String)("" + new Date().getTime()), PieceOfKnowledge.class);
        JenaPoKHelper h = new JenaPoKHelper(pok);
        h.setAutoCommitMode(false);
        h.createLitStat(pok.getUri(), "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://weblab.ow2.org/core/1.2/ontology/retrieval#SearchOrder");
        h.createLitStat(pok.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasOrderedQuery", this.queryURI);
        h.createLitStat(pok.getUri(), OFFSET_PROPERTY, Integer.toString(startOffset));
        h.createLitStat(pok.getUri(), LIMIT_PROPERTY, Integer.toString(this.splitSize));
        h.commit();
        return pok;
    }

    public PieceOfKnowledge getCurrentSplitPOK() {
        return this.getPOK(this.currentPosition);
    }

    public String getSortMethod() {
        return this.SORT_METHOD;
    }

    private void fillMapByRank(Statements fullResutSetDecMap) {
        Iterator hitIt = fullResutSetDecMap.entrySet().iterator();
        while (hitIt.hasNext()) {
            String resURI = null;
            Map.Entry entry = (Map.Entry)hitIt.next();
            if (((IPredicateValuePairs)entry.getValue()).getValue("http://weblab.ow2.org/core/1.2/ontology/retrieval#hasRank") == null) continue;
            String rank = (String)((IPredicateValuePairs)entry.getValue()).getValue("http://weblab.ow2.org/core/1.2/ontology/retrieval#hasRank");
            resURI = fullResutSetDecMap.getFirstValue((String)entry.getKey(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedTo", null);
            HashMap hitDescription = new HashMap();
            for (WTriple triple : ((IPredicateValuePairs)entry.getValue()).getStatements()) {
                if (triple.getObject() == null && triple.getObject().equals("")) continue;
                if (hitDescription.containsKey(triple.getPredicate())) {
                    ((List)hitDescription.get(triple.getPredicate())).add(triple.getObject());
                    continue;
                }
                LinkedList<String> values = new LinkedList<String>();
                values.add(triple.getObject());
                hitDescription.put(triple.getPredicate(), values);
            }
            if (fullResutSetDecMap.containsKey((Object)resURI)) {
                IPredicateValuePairs resDesc = (IPredicateValuePairs)fullResutSetDecMap.get((Object)resURI);
                for (WTriple triple : resDesc.getStatements()) {
                    if (triple.getObject() == null && triple.getObject().equals("")) continue;
                    if (hitDescription.containsKey(triple.getPredicate())) {
                        ((List)hitDescription.get(triple.getPredicate())).add(triple.getObject());
                        continue;
                    }
                    LinkedList<String> values = new LinkedList<String>();
                    values.add(triple.getObject());
                    hitDescription.put(triple.getPredicate(), values);
                }
            }
            this.allRSMap.getDescriptionMap().put(rank, hitDescription);
        }
    }

    private void fillMapDefault(Statements fullResutSetDecMap) {
        int rank = this.currentPosition == 1 ? 1 : (this.currentPosition - 1) * this.splitSize + 1;
        Iterator hitIt = fullResutSetDecMap.entrySet().iterator();
        while (hitIt.hasNext()) {
            String resURI = null;
            Map.Entry entry = (Map.Entry)hitIt.next();
            if (((IPredicateValuePairs)entry.getValue()).getValue("http://weblab.ow2.org/core/1.2/ontology/retrieval#hasRank") == null) continue;
            resURI = fullResutSetDecMap.getFirstValue((String)entry.getKey(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedTo", null);
            LinkedHashMap hitDescription = new LinkedHashMap();
            for (WTriple triple : ((IPredicateValuePairs)entry.getValue()).getStatements()) {
                if (triple.getObject() == null && triple.getObject().equals("")) continue;
                if (hitDescription.containsKey(triple.getPredicate())) {
                    ((List)((HashMap)hitDescription).get(triple.getPredicate())).add(triple.getObject());
                    continue;
                }
                LinkedList<String> values = new LinkedList<String>();
                values.add(triple.getObject());
                hitDescription.put(triple.getPredicate(), values);
            }
            if (fullResutSetDecMap.containsKey((Object)resURI)) {
                IPredicateValuePairs resDesc = (IPredicateValuePairs)fullResutSetDecMap.get((Object)resURI);
                for (WTriple triple : resDesc.getStatements()) {
                    if (triple.getObject() == null && triple.getObject().equals("")) continue;
                    if (hitDescription.containsKey(triple.getPredicate())) {
                        ((List)((HashMap)hitDescription).get(triple.getPredicate())).add(triple.getObject());
                        continue;
                    }
                    LinkedList<String> values = new LinkedList<String>();
                    values.add(triple.getObject());
                    hitDescription.put(triple.getPredicate(), values);
                }
            }
            this.allRSMap.getDescriptionMap().put(Integer.toString(rank), hitDescription);
            ++rank;
        }
    }
}

