<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jstl/core_rt" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jstl/fmt_rt" prefix="fmt"%>


<portlet:defineObjects />
<!--rendering resourceCollection  -->

<portlet:actionURL var="formURL"/>


<fmt:setLocale value="${pageContext.request.locale}" />
<fmt:setBundle basename="result_portlet" />



<portlet:resourceURL var="resourceURL" escapeXml="false" />


<script type="text/javascript">
jQuery(document).ready(function() {
	jQuery("#result_portlet_resources_view").load("${resourceURL}");
});

function resultPortlet_invertSelection(){
	jQuery('#resultPortlet_table tr td input').each(
		function() { this.checked = !this.checked; 
	});
}

function resultPortlet_submitForm() {
	var form=jQuery('#selected_document')[0];
	var uris="";
	jQuery("#resultPortlet_table input:checked").each(
			function(){
				
				uris = uris.concat(this.value+",");
			});
		if (uris == "") {
			alert("<fmt:message key="portlet.no_doc_selected" />");
		} else {
			form.selected_res.value = ""+uris;
			form.submit();
		}
}

</script>

<div id="result_portlet_content" class='contenu_portlet'>

<c:choose>
	<c:when test="${hasNumberOfResults==null || hasNumberOfResults==0}">
		<div class="portlet-msg-info">
			<fmt:message key="portlet.no_results" />
		</div>
	</c:when>
	<c:otherwise>

		<!-- icons definition -->
		<c:url value="/images/" var="baseURL"></c:url>

		<c:if test="${not_sortable}">
			<div class="portlet-msg-info"><fmt:message key="portlet.not_sortable_results" /></div>
		</c:if>
		
		<div id="result_portlet_top_nbresults" class="portlet-msg-info">
			<!-- number of results -->
			${hasNumberOfResults} <fmt:message key="portlet.results.nb" />
			
			<!-- ResultSet info -->
			<div id="resultset_info">${resultSet_label }</div>
		</div>
		
		<!-- AJAX resource collection -->
		<div id="result_portlet_resources_view">
			<div id="result_portlet_loading_image">
				<img alt="loading" src="${baseURL}ajax-loader.gif"/>
			</div>
		</div>
		<!-- main form -->
		<form action="${formURL}" method="post" id="selected_document" name="selected_doc_form">
			<input id='selection_action' name='selection_action' type='hidden'> 
			<input name="selected_res" type="hidden"/>
		</form>
	</c:otherwise>
</c:choose>

</div>



