/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 *
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of the
 * GNU Lesser General Public License as published by the Free Software Foundation; either version
 * 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.portlet.bean;

import java.util.Map;

/**
 * Bean to store annotations description and it value. 
 * @author emilien
 *
 */
public class AnnotationsDescBean {
	public static final String DEFAULT_CONF_FILE = "result_portlet_meta.xml";
	public static final String DEFAULT_BEAN_NAME = "resultPortletMeta";
	
	/*
	 * attributes
	 */
	private Map<String, String> properties;

	/**
	 * @return the properties
	 */
	public Map<String, String> getProperties() {
		return properties;
	}
	/**
	 * @param properties the properties to set
	 */
	public void setProperties(Map<String, String> properties) {
		this.properties = properties;
	}
	

	/*
	 * getters and setter
	 */
	public String[] getDisctinctAnnotationsNS() {	
		return  this.properties.values().toArray(new String[this.properties.values().size()]);
	}
	
	/*
	 * getters and setter
	 */
	
	/**
	 * get the value for the annotation name-space.
	 * @param namespace of annotation
	 * @return value for this annotation
	 */
	public String getAnnotationValue(String namespace) {
		return this.properties.get(namespace).toString();
	}
}
