/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 *
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of the
 * GNU Lesser General Public License as published by the Free Software Foundation; either version
 * 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.portlet.tool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.ow2.weblab.core.extended.ontologies.WebLabRetrieval;
import org.ow2.weblab.portlet.bean.RankBean;

/**
 * Factory to get RankBean from a WTripleMap, according a number of digit.
 * 
 * @author emilien
 * 
 */
public class ResourceRankFactory {
	
	private ResourceRankFactory() {
		super();
	}

	/**
	 * To get RankBean from WTripleMap
	 * @param rankMap the map
	 * @param digitNumber number of digit of the bean
	 * @return a rankBean
	 */
	public static RankBean getResourceRankBean(HashMap<String, HashMap<String, List<String>>> rankMap,
			int digitNumber) {

		Map<String, List<Integer>> rankList = new HashMap<String, List<Integer>>();

		for (Entry<String, HashMap<String, List<String>>> entry : rankMap
				.entrySet()) {

			if (entry.getValue() != null
					&& entry.getValue().containsKey(WebLabRetrieval.HAS_SCORE)) {

				Double rank = Double.parseDouble(entry.getValue().get(
						WebLabRetrieval.HAS_SCORE).get(0).toString());

				List<Integer> l = getRankList(rank, digitNumber);
				rankList.put(entry.getKey(), l);
			}
		}
		RankBean bean = new RankBean(rankList);
		return bean;
	}

	/**
	 * To get List of integer (O, 1 or 2) list corresponding full, half and empty stars
	 * @param rank
	 * @param digitNumber
	 * @return list of integer
	 */
	private static List<Integer> getRankList(Double rank, int digitNumber) {
		Double rankValue = rank * digitNumber * 100;

		List<Integer> ranks = new ArrayList<Integer>();
		// normalized score

		int half_star = 0;
		int full_star = rankValue.intValue() / 100;
		if (rankValue.intValue() % 100 >= digitNumber * 10) {
			half_star = 1;
		}
		int no_star = digitNumber - (full_star + half_star);
		for (int i = 0; i < full_star; i++) {
			ranks.add(2);
		}
		for (int i = 0; i < half_star; i++) {
			ranks.add(1);
		}
		for (int i = 0; i < no_star; i++) {
			ranks.add(0);
		}
		return ranks;
	}
}
