/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.portlet;

import java.io.IOException;
import java.io.Serializable;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.ProcessAction;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.components.client.WebLabClient;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.helper.ResourceHelper;
import org.ow2.weblab.core.helper.impl.AdvancedSelector;
import org.ow2.weblab.core.helper.impl.JenaResourceHelper;
import org.ow2.weblab.core.helper.impl.RDFSelectorFactory;
import org.ow2.weblab.core.helper.impl.Statements;
import org.ow2.weblab.core.model.ComposedQuery;
import org.ow2.weblab.core.model.Operator;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.StringQuery;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.Searcher;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.searcher.SearchArgs;
import org.ow2.weblab.core.services.searcher.SearchReturn;
import org.ow2.weblab.portlet.WebLabPortlet;
import org.ow2.weblab.util.PortletQueryParser;
import org.ow2.weblab.util.WebLabQueryParser;

public class SearchPortlet
extends WebLabPortlet {
    private static Log logger = LogFactory.getLog(SearchPortlet.class);
    private static String defaultSearcherURI;
    private static int distinct_submit_query;
    protected PortletRequestDispatcher normalView;
    protected PortletRequestDispatcher maximizedView;
    protected PortletRequestDispatcher helpView;
    protected PortletRequestDispatcher errorView;
    protected WebLabQueryParser parser;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        super.init();
        this.parser = new PortletQueryParser();
        this.normalView = config.getPortletContext().getRequestDispatcher(this.getInitParameter("normal_page"));
        this.maximizedView = config.getPortletContext().getRequestDispatcher(this.getInitParameter("maximized_page"));
        this.helpView = config.getPortletContext().getRequestDispatcher(this.getInitParameter("edit_page"));
        this.errorView = config.getPortletContext().getRequestDispatcher(this.getInitParameter("error_page"));
        defaultSearcherURI = this.getInitParameter("search_service_uri");
        try {
            WebLabClient.getSearcher((String)"default", (String)"init", (String)defaultSearcherURI);
            logger.info((Object)(SearchPortlet.class.getSimpleName() + " is ready to serve request my Lord."));
        }
        catch (WebLabCheckedException e) {
            throw new PortletException("Cannot access the searcher from WebLab client.", (Throwable)e);
        }
        logger.info((Object)("Default searcher service uri [" + defaultSearcherURI + "]."));
        distinct_submit_query = 0;
    }

    public void destroy() {
        super.destroy();
    }

    public void doView(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        long start = System.currentTimeMillis();
        res.setTitle(ResourceBundle.getBundle("search_portlet", req.getLocale()).getString("portlet.title"));
        if (req.getPortletSession().getAttribute("user_service_conf") == null) {
            logger.info((Object)("Setting default searcher uri [" + defaultSearcherURI + "] in session"));
            req.getPortletSession().setAttribute("user_service_conf", (Object)defaultSearcherURI);
        }
        if (req.getParameter("searcher_error") != null) {
            req.setAttribute("searcher_error", (Object)req.getParameter("searcher_error"));
            logger.info((Object)"error in searcher");
            this.errorView.include(req, res);
        }
        if (req.getPortletSession().getAttribute("user_last_search", 1) == null) {
            req.setAttribute("user_last_search", (Object)ResourceBundle.getBundle("search_portlet", req.getLocale()).getString("search.defaultText"));
            req.setAttribute("def_mess", (Object)Boolean.TRUE);
        } else {
            Query query = ((SearchArgs)req.getPortletSession().getAttribute("user_last_search", 1)).getQuery();
            try {
                req.setAttribute("user_last_search", (Object)this.parser.getRequest(query, (ResourceHelper)new JenaResourceHelper((Resource)query)));
            }
            catch (WebLabCheckedException e) {
                logger.info((Object)("Cannot convert query to String: " + e.getMessage()), (Throwable)e);
                this.errorView.include(req, res);
            }
            req.setAttribute("def_mess", (Object)Boolean.FALSE);
        }
        if (req.getWindowState() == WindowState.NORMAL) {
            this.normalView.include(req, res);
        } else if (req.getWindowState() == WindowState.MAXIMIZED) {
            this.maximizedView.include(req, res);
        }
        logger.info((Object)("doView reponse time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    public void doEdit(RenderRequest req, RenderResponse res) throws PortletException, IOException {
        long start = System.currentTimeMillis();
        res.setContentType("text/html; charset=utf-8");
        req.setAttribute("search_service_uri", req.getPortletSession().getAttribute("user_service_conf"));
        this.helpView.include(req, res);
        logger.info((Object)("doEdit reponse time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    @ProcessAction(name="do_search")
    public void doSearch(ActionRequest req, ActionResponse res) throws PortletException, IOException {
        logger.debug((Object)"An action has been received [do_search].");
        if (req.getParameter("queryInput") == null || req.getParameter("queryInput") == "") {
            throw new PortletException("An error occured while launching query : cannot get query inputs.");
        }
        StringQuery q = (StringQuery)ResourceFactory.createResource((String)(this.getDefaultNamespace() + this.getPortletName()), (String)("queryID_" + distinct_submit_query++), StringQuery.class);
        q.setRequest(req.getParameter("queryInput"));
        SearchArgs args = this.createSearchArgs((Query)q);
        QName qnOfEvent = QName.valueOf(this.getPortletConfig().getInitParameter("{http://weblab.ow2.org/portlet/action}publish_query"));
        logger.info((Object)("publishing searchArgs in event : [" + qnOfEvent + "]"));
        res.setEvent(qnOfEvent, (Serializable)args);
    }

    @ProcessAction(name="do_adv_search")
    public void doAdvSearch(ActionRequest req, ActionResponse res) throws PortletException, IOException {
        logger.debug((Object)"An expected action has been received [do_adv_search].");
        if (req.getParameter("and_keywords") == null || req.getParameter("phrase_keywords") == null || req.getParameter("or_keywords") == null || req.getParameter("not_keywords") == null) {
            logger.error((Object)"An error occured while launching query : cannot get query inputs.");
        } else {
            ComposedQuery metaQuery = this.createAdvQuery(req);
            SearchArgs args = this.createSearchArgs((Query)metaQuery);
            QName qnOfEvent = QName.valueOf(this.getPortletConfig().getInitParameter("{http://weblab.ow2.org/portlet/action}publish_query"));
            res.setEvent(qnOfEvent, (Serializable)args);
        }
        res.setWindowState(WindowState.NORMAL);
    }

    @ProcessAction(name="get_advanced_search")
    public void getAdvSearch(ActionRequest req, ActionResponse res) throws PortletException, IOException {
        logger.debug((Object)"An action has been received [get_advanced_search].");
        res.setWindowState(WindowState.MAXIMIZED);
    }

    @ProcessAction(name="change_service_config")
    public void changeService(ActionRequest req, ActionResponse res) throws PortletException, IOException {
        logger.debug((Object)"An expected action has been received [change_service_config].");
        String searcherURI = req.getParameter("service_uri_input");
        try {
            WebLabClient.getSearcher((String)"default", (String)"init", (String)searcherURI);
            logger.info((Object)(SearchPortlet.class.getSimpleName() + " is ready to serve request my Lord."));
        }
        catch (WebLabCheckedException e) {
            logger.error((Object)"Searcher URI is invalid.", (Throwable)e);
            req.setAttribute("searcher_error", (Object)"Searcher URI is invalid.");
            this.errorView.include((PortletRequest)req, (PortletResponse)res);
        }
        logger.info((Object)("New searcher service uri :" + searcherURI));
        req.getPortletSession().setAttribute("user_service_conf", (Object)searcherURI);
        res.setPortletMode(PortletMode.VIEW);
    }

    public void processAction(ActionRequest req, ActionResponse res) throws IOException, PortletException {
        logger.info((Object)("Action receveid : [" + req.getParameter("javax.portlet.action") + "]."));
        super.processAction(req, res);
    }

    public void processEvent(EventRequest req, EventResponse res) throws PortletException, IOException {
        long start = System.currentTimeMillis();
        String reaction = this.getReaction(req.getEvent().getQName()).getLocalPart();
        logger.info((Object)("Event received " + req.getEvent().getQName() + " - launching reaction : " + reaction));
        if ("query".equals(reaction)) {
            if (req.getEvent().getValue() == null || !(req.getEvent().getValue() instanceof SearchArgs)) {
                logger.error((Object)("The Event passed has no (or incorrect) value: [" + req.getEvent().getValue() + "]"));
                res.setRenderParameter("searcher_error", "The Event passed has no (or incorrect) value: [" + req.getEvent().getValue() + "]");
            }
            SearchArgs args = (SearchArgs)req.getEvent().getValue();
            String userURI = req.getRemoteUser();
            String context = "defaultContext";
            String searcherURI = null;
            if (req.getPortletSession().getAttribute("user_service_conf") != null) {
                searcherURI = req.getPortletSession().getAttribute("user_service_conf").toString();
            }
            try {
                SearchReturn searchResult = this.doSearch(userURI, "defaultContext", searcherURI, args);
                req.getPortletSession().setAttribute("user_last_search", (Object)args, 1);
                this.sendEventForAction("search", (Resource)searchResult.getResultSet(), res);
            }
            catch (WebLabCheckedException e) {
                String error = "Search service is not accessible.";
                logger.error((Object)"Search service is not accessible.", (Throwable)e);
                res.setRenderParameter("searcher_error", "Search service is not accessible.");
            }
        } else if ("sendNextDocuments".equals(reaction)) {
            if (req.getEvent().getValue() != null && req.getEvent().getValue() instanceof PieceOfKnowledge) {
                PieceOfKnowledge pok = (PieceOfKnowledge)req.getEvent().getValue();
                AdvancedSelector rdfSelector = RDFSelectorFactory.getSelector((boolean)true, (String[])new String[0]);
                Statements map = rdfSelector.searchFor((Resource)pok, new String[0]);
                String queryURI = map.getFirstValue(null, "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasOrderedQuery", null);
                logger.info((Object)("query URI :" + queryURI));
                SearchArgs userSearchArg = (SearchArgs)req.getPortletSession().getAttribute("user_last_search", 1);
                if (userSearchArg != null && userSearchArg.getQuery().getUri().equals(queryURI)) {
                    userSearchArg.setOffset((Integer)map.getTypedValue(userSearchArg.getQuery().getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasExpectedOffset", Integer.class));
                    userSearchArg.setLimit((Integer)map.getTypedValue(userSearchArg.getQuery().getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasExpectedLimit", Integer.class));
                    String userURI = req.getRemoteUser();
                    String context = "defaultContext";
                    String searcherURI = null;
                    if (req.getPortletSession().getAttribute("user_service_conf") != null) {
                        searcherURI = req.getPortletSession().getAttribute("user_service_conf").toString();
                    }
                    logger.info((Object)("searcher : updating a resultSet, offset:" + userSearchArg.getOffset() + " limit:" + userSearchArg.getLimit()));
                    try {
                        SearchReturn searchResult = this.doSearch(userURI, "defaultContext", searcherURI, userSearchArg);
                        this.sendEventForAction("search", (Resource)searchResult.getResultSet(), res);
                    }
                    catch (WebLabCheckedException e) {
                        logger.error((Object)"An error occured while querying the search service.", (Throwable)e);
                        res.setRenderParameter("searcher_error", "An error occured while querying the search service.");
                    }
                }
            }
        } else {
            logger.error((Object)("An unknown event has been receveid [" + req.getEvent().getQName() + "]."));
            res.setRenderParameter("searcher_error", "An unknown event has been receveid [" + req.getEvent().getQName() + "].");
        }
        logger.info((Object)("processEvent reponse time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    protected ComposedQuery createAdvQuery(ActionRequest req) {
        String not_keywords;
        String or_keywords;
        String phrase_keywords;
        ComposedQuery metaQuery = (ComposedQuery)ResourceFactory.createResource((String)(this.getDefaultNamespace() + this.getPortletName()), (String)("queryID_" + distinct_submit_query++), ComposedQuery.class);
        metaQuery.setOperator(Operator.AND);
        String and_keywords = req.getParameter("and_keywords").toString().trim();
        if (and_keywords != "") {
            StringQuery q = (StringQuery)ResourceFactory.createResource((String)(this.getDefaultNamespace() + this.getPortletName()), (String)("queryID_" + distinct_submit_query++), StringQuery.class);
            q.setRequest(and_keywords.replaceAll(" ", " " + Operator.AND + " "));
            metaQuery.getQuery().add(q);
        }
        if ((phrase_keywords = req.getParameter("phrase_keywords").toString().trim()) != "") {
            StringQuery q = (StringQuery)ResourceFactory.createResource((String)(this.getDefaultNamespace() + this.getPortletName()), (String)("queryID_" + distinct_submit_query++), StringQuery.class);
            q.setRequest('\"' + phrase_keywords + '\"');
            metaQuery.getQuery().add(q);
        }
        if ((or_keywords = req.getParameter("or_keywords").toString().trim()) != "") {
            StringQuery q = (StringQuery)ResourceFactory.createResource((String)(this.getDefaultNamespace() + this.getPortletName()), (String)("queryID_" + distinct_submit_query++), StringQuery.class);
            q.setRequest('(' + or_keywords.replaceAll(" ", " " + Operator.OR + " ") + ')');
            metaQuery.getQuery().add(q);
        }
        if ((not_keywords = req.getParameter("not_keywords").toString().trim()) != "") {
            StringQuery q = (StringQuery)ResourceFactory.createResource((String)(this.getDefaultNamespace() + this.getPortletName()), (String)("queryID_" + distinct_submit_query++), StringQuery.class);
            q.setRequest("" + Operator.NOT + ' ' + "(" + not_keywords.replaceAll(" ", " " + Operator.OR + " ") + ')');
            metaQuery.getQuery().add(q);
        }
        return metaQuery;
    }

    protected SearchArgs createSearchArgs(Query q) {
        try {
            logger.info((Object)("Creating search args for [" + this.parser.getRequest(q, (ResourceHelper)new JenaResourceHelper((Resource)q)) + "]."));
        }
        catch (WebLabCheckedException e) {
            logger.warn((Object)("Cannot convert query " + q + " to String. May not be a real issue."));
        }
        SearchArgs args = new SearchArgs();
        args.setLimit(Integer.valueOf(10));
        args.setOffset(Integer.valueOf(0));
        args.setQuery(q);
        return args;
    }

    protected SearchReturn doSearch(String userURI, String context, String searcherURI, SearchArgs args) throws WebLabCheckedException {
        logger.debug((Object)"Launching search query...");
        String error_message = "An error occured during search.";
        logger.info((Object)("Searching with user [" + userURI + "] and context [" + context + "] on service [" + searcherURI + "]."));
        try {
            Searcher client = WebLabClient.getSearcher((String)userURI, (String)context, (String)searcherURI);
            if (client != null) {
                SearchReturn searchResult = client.search(args);
                if (searchResult == null) {
                    throw new WebLabCheckedException("An error occured during search. Search results are null.");
                }
                logger.debug((Object)searchResult.getResultSet());
                logger.info((Object)("Results received for search [" + args + "]."));
                return searchResult;
            }
            throw new WebLabCheckedException("An error occured during search. Search client is invalid.");
        }
        catch (UnsupportedRequestException e) {
            throw new WebLabCheckedException("An error occured during search. [" + ((Object)((Object)e)).getClass().getSimpleName() + "].", (Throwable)e);
        }
        catch (ServiceNotConfiguredException e) {
            throw new WebLabCheckedException("An error occured during search. [" + ((Object)((Object)e)).getClass().getSimpleName() + "].", (Throwable)e);
        }
        catch (AccessDeniedException e) {
            throw new WebLabCheckedException("An error occured during search. [" + ((Object)((Object)e)).getClass().getSimpleName() + "].", (Throwable)e);
        }
        catch (ContentNotAvailableException e) {
            throw new WebLabCheckedException("An error occured during search. [" + ((Object)((Object)e)).getClass().getSimpleName() + "].", (Throwable)e);
        }
        catch (InvalidParameterException e) {
            throw new WebLabCheckedException("An error occured during search. [" + ((Object)((Object)e)).getClass().getSimpleName() + "].", (Throwable)e);
        }
        catch (InsufficientResourcesException e) {
            throw new WebLabCheckedException("An error occured during search. [" + ((Object)((Object)e)).getClass().getSimpleName() + "].", (Throwable)e);
        }
        catch (UnexpectedException e) {
            throw new WebLabCheckedException("An error occured during search. [" + ((Object)((Object)e)).getClass().getSimpleName() + "].", (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebLabCheckedException("An error occured during search. [" + e.getClass().getSimpleName() + "]", (Throwable)e);
        }
    }
}

