/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.util;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.helper.ResourceHelper;
import org.ow2.weblab.core.model.ComposedQuery;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.SimilarityQuery;
import org.ow2.weblab.core.model.StringQuery;
import org.ow2.weblab.util.WebLabQueryParser;

public class PortletQueryParser
extends WebLabQueryParser {
    private final Log logger = LogFactory.getLog(PortletQueryParser.class);

    public String getRequest(Query q, ResourceHelper hlpr) throws WebLabCheckedException {
        if (q instanceof StringQuery) {
            return ((StringQuery)q).getRequest();
        }
        if (q instanceof ComposedQuery) {
            return this.getComposedRequest((ComposedQuery)q, hlpr);
        }
        if (q instanceof SimilarityQuery) {
            SimilarityQuery query = (SimilarityQuery)q;
            StringBuffer queryString = new StringBuffer();
            List resources = query.getResource();
            if (resources.size() == 1) {
                queryString.append("id");
                queryString.append(':');
                queryString.append('\"');
                queryString.append(((Resource)resources.get(0)).getUri());
                queryString.append('\"');
            } else {
                for (int i = 0; i < resources.size(); ++i) {
                    Resource r = (Resource)resources.get(i);
                    if (i > 0) {
                        queryString.append(" OR ");
                    }
                    queryString.append("id");
                    queryString.append(':');
                    queryString.append('\"');
                    queryString.append(r.getUri());
                    queryString.append('\"');
                }
            }
            return queryString.toString();
        }
        throw new WebLabCheckedException("Cannot parse query type : " + q.getClass() + ".");
    }

    public String getComposedRequest(ComposedQuery q, ResourceHelper hlpr) throws WebLabCheckedException {
        String operator = q.getOperator().value();
        StringBuffer queryString = new StringBuffer();
        queryString.append('(');
        for (Query subQ : q.getQuery()) {
            if (queryString.length() > 1) {
                queryString.append(' ');
                queryString.append(operator);
                queryString.append(' ');
            }
            if (subQ instanceof StringQuery) {
                queryString.append(this.getRequestWithScope(subQ, hlpr));
                continue;
            }
            if (subQ instanceof ComposedQuery) {
                queryString.append(this.getComposedRequest((ComposedQuery)subQ, hlpr));
                continue;
            }
            throw new WebLabCheckedException("Solr engine service can only process " + ComposedQuery.class.getSimpleName() + " or " + StringQuery.class.getSimpleName() + ".");
        }
        queryString.append(')');
        return queryString.toString();
    }

    public String getRequestWithScope(Query q, ResourceHelper hlpr) throws WebLabCheckedException {
        List values = hlpr.getRessOnPredSubj(q.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasScope");
        if (values.size() == 0) {
            this.logger.debug((Object)"No scope.");
        } else if (values.size() > 1) {
            this.logger.info((Object)"Query is holding multiple values for [http://weblab.ow2.org/core/1.2/ontology/retrieval#hasScope]. That's not cool, so we ignore all of them.");
        } else {
            String scope = (String)values.get(0);
            scope = scope.contains("#") ? scope.substring(scope.indexOf(35) + 1).trim().toLowerCase() : scope.substring(scope.lastIndexOf(47) + 1).trim().toLowerCase();
            return scope + ":(" + this.getRequest(q, hlpr) + ")";
        }
        return this.getRequest(q, hlpr);
    }

    public String getOrderBy(Query q, ResourceHelper hlpr) throws WebLabCheckedException {
        throw new WebLabCheckedException("Not yet implemented...");
    }

    public boolean getOrder(Query q, ResourceHelper hlpr) throws WebLabCheckedException {
        List values = hlpr.getLitsOnPredSubj(q.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#ascendentOrderingModeExpected");
        if (values.size() == 1) {
            return Boolean.parseBoolean((String)values.get(0));
        }
        this.logger.info((Object)"Query is holding multiple values for [http://weblab.ow2.org/core/1.2/ontology/retrieval#ascendentOrderingModeExpected]. That's not well perceived, so we ignore all of them.");
        return false;
    }
}

