/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2010 EADS - CASSIDIAN
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.portlet.bean;

import java.util.List;

public class FacetBean {

	protected String label;
	protected int position;
	protected List<FacetValueBean> values;
	
	public FacetBean() {
		super();
	}

	public FacetBean(String label, List<FacetValueBean> values) {
		super();
		this.label = label;
		this.values = values;
	}

	/**
	 * @return the label
	 */
	public String getLabel() {
		return this.label;
	}

	/**
	 * @param label the label to set
	 */
	public void setLabel(String label) {
		this.label = label;
	}

	/**
	 * @return the position
	 */
	public int getPosition() {
		return this.position;
	}

	/**
	 * @param position the position to set
	 */
	public void setPosition(int position) {
		this.position = position;
	}

	/**
	 * @return the values
	 */
	public List<FacetValueBean> getValues() {
		return this.values;
	}

	/**
	 * @param values the values to set
	 */
	public void setValues(List<FacetValueBean> values) {
		this.values = values;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.label == null) ? 0 : this.label.hashCode());
		result = prime * result + this.position;
		result = prime * result + ((this.values == null) ? 0 : this.values.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		FacetBean other = (FacetBean) obj;
		if (this.label == null) {
			if (other.label != null)
				return false;
		}
		else if (!this.label.equals(other.label))
			return false;
		if (this.position != other.position)
			return false;
		if (this.values == null) {
			if (other.values != null)
				return false;
		}
		else if (!this.values.equals(other.values))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "FacetBean [label=" + this.label + ", position=" + this.position + ", values=" + this.values + "]";
	}

}
