/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2010 EADS - CASSIDIAN
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.portlet.bean;

import org.ow2.weblab.portlet.tool.FacetUtil;

public class FacetValueBean {

	protected String label;
	protected int count;
	protected String filterQuery;
	
	public FacetValueBean() {
		super();
	}

	public FacetValueBean(String label, int count, String filterQuery) {
		super();
		setLabel(label);
		setCount(count);
		setFilterQuery(filterQuery);
	}

	/**
	 * @return the label
	 */
	public String getLabel() {
		return this.label;
	}

	/**
	 * @param label the label to set
	 */
	public void setLabel(String label) {
		this.label = FacetUtil.normaliseLabel(label);
	}

	/**
	 * @return the count
	 */
	public int getCount() {
		return this.count;
	}

	/**
	 * @param count the count to set
	 */
	public void setCount(int count) {
		this.count = count;
	}

	/**
	 * @return the filterQuery
	 */
	public String getFilterQuery() {
		return this.filterQuery;
	}

	/**
	 * @param filterQuery the filterQuery to set
	 */
	public void setFilterQuery(String filterQuery) {
		this.filterQuery = filterQuery;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + this.count;
		result = prime * result + ((this.filterQuery == null) ? 0 : this.filterQuery.hashCode());
		result = prime * result + ((this.label == null) ? 0 : this.label.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		FacetValueBean other = (FacetValueBean) obj;
		if (this.count != other.count)
			return false;
		if (this.filterQuery == null) {
			if (other.filterQuery != null)
				return false;
		}
		else if (!this.filterQuery.equals(other.filterQuery))
			return false;
		if (this.label == null) {
			if (other.label != null)
				return false;
		}
		else if (!this.label.equals(other.label))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "FacetValueBean [count=" + this.count + ", filterQuery=" + this.filterQuery + ", label=" + this.label + "]";
	}
}
