<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jstl/core_rt" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jstl/fmt_rt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>


<portlet:defineObjects />
<!--rendering resourceCollection  -->


<fmt:setLocale value="${pageContext.request.locale}" />
<fmt:setBundle basename="meta_portlet" />


<portlet:resourceURL var="first_splitter_pos">
	<portlet:param name="splitter_position" value="1"></portlet:param>
</portlet:resourceURL>

<!-- icons definition -->
<c:url value="/images/" var="baseURL"></c:url>

<!-- meta-data -->
<div>
	<table class="meta_data_table"><tbody>
		<!--<tr><th class="titre_ligne premier_titre"><fmt:message key="meta.meta_name" /></th><th class="titre_ligne premier_titre"><fmt:message key="meta.meta_value" /></th></tr>-->
		
		<c:if
			test="${meta_conf_bean.properties['title'] && ! empty resource_desc.value[rdfProperties['title']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.title" />&nbsp;:
			</th>
			<td>
				<b><i>${resource_desc[rdfProperties['title']][0]}</i></b>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['hasScore'] && ! empty resource_desc[rdfProperties['hasScore']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.hasScore" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['hasScore']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['hasNativeContent'] && ! empty resource_desc[rdfProperties['hasNativeContent']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.hasNativeContent" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['hasNativeContent']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['hasNormalisedContent'] && ! empty resource_desc[rdfProperties['hasNormalisedContent']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.hasNormalisedContent" />&nbsp;:
			<i>${resource_desc[rdfProperties['hasNormalisedContent']][0]}</i>
			<br>
		</c:if> <c:if
			test="${meta_conf_bean.properties['isExposedAs'] && ! empty resource_desc[rdfProperties['isExposedAs']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.isExposedAs" />&nbsp;:
			</th>
			<td>
				<a class="meta_link" target="_blank"
				href="${resource_desc[rdfProperties['isExposedAs']][0]}">
			${resource_desc[rdfProperties['isExposedAs']][0]}</a>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['isGeneratedFrom'] && ! empty resource_desc[rdfProperties['isGeneratedFrom']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.isGeneratedFrom" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['isGeneratedFrom']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['abstract'] && ! empty resource_desc[rdfProperties['abstract']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.abstract" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['abstract']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['isResultOf'] && ! empty resource_desc[rdfProperties['isResultOf']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.isResultOf" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['isResultOf']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['isProducedFrom'] && ! empty resource_desc[rdfProperties['isProducedFrom']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.isProducedFrom" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['isProducedFrom']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['creator'] && ! empty resource_desc[rdfProperties['creator']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.creator" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['creator']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['date'] && ! empty resource_desc[rdfProperties['date']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.date" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['date']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['description'] && ! empty resource_desc[rdfProperties['description']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.description" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['description']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['format'] && ! empty resource_desc[rdfProperties['format']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.format" />&nbsp;:
			</th>
			<td>
				<c:choose>
					<c:when test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'html')}">
							<img src="${baseURL}html.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'xml')}">
							<img src="${baseURL}xml.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'rss')}">
							<img src="${baseURL}rss-icon.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'pdf')}">
							<img src="${baseURL}pdf.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'word')}">
							<img src="${baseURL}doc.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'powerpoint')}">
							<img src="${baseURL}ppt.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'excel')}">
							<img src="${baseURL}xls.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'visio')}">
							<img src="${baseURL}vsd.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'opendocument.spreadsheet')}">
							<img src="${baseURL}ods.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'opendocument.text')}">
							<img src="${baseURL}odt.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'application/rtf')}">
							<img src="${baseURL}rtf.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'text/plain')}">
							<img src="${baseURL}txt.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'opendocument.presentation')}">
							<img src="${baseURL}odp.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'opendocument.graphics')}">
							<img src="${baseURL}odg.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'gif')}">
							<img src="${baseURL}gif.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'jpeg')}">
							<img src="${baseURL}jpg.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'png')}">
							<img src="${baseURL}png.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'bitmap')}">
							<img src="${baseURL}bmp.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'bmp')}">
							<img src="${baseURL}bmp.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'zip')}">
							<img src="${baseURL}zip.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'wav')}">
							<img src="${baseURL}sound.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'audio.mpeg')}">
							<img src="${baseURL}sound.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'video.mpeg')}">
							<img src="${baseURL}video.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'quicktime')}">
							<img src="${baseURL}quicktime.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'msvideo')}">
							<img src="${baseURL}wmv.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:when
							test="${fn:containsIgnoreCase(resource_desc[rdfProperties['format']][0],'movie')}">
							<img src="${baseURL}video.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:when>
						<c:otherwise>
							<img src="${baseURL}unknown.png" /> (${resource_desc[rdfProperties['format']][0]})
						</c:otherwise>				
				</c:choose>	
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['identifier'] && ! empty resource_desc[rdfProperties['identifier']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.identifier" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['identifier']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['language'] && ! empty resource_desc[rdfProperties['language']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.language" />&nbsp;:
			</th>
			<td>
				<c:choose>
					<c:when
						test="${resource_desc[rdfProperties['language']][0]=='en'}">
						<img src="${baseURL}en_US.png" />&nbsp;<fmt:message key="meta.language.en" />
					</c:when>
					<c:when
						test="${resource_desc[rdfProperties['language']][0]=='fr'}">
						<img src="${baseURL}fr_FR.png" />&nbsp;<fmt:message key="meta.language.fr" />
					</c:when>
					<c:when
						test="${resource_desc[rdfProperties['language']][0]=='de'}">
						<img src="${baseURL}de_DE.png" />&nbsp;<fmt:message key="meta.language.de" />
					</c:when>
					<c:when
						test="${resource_desc[rdfProperties['language']][0]=='ar'}">
						<img src="${baseURL}ar_SA.png" />&nbsp;<fmt:message key="meta.language.ar" />
					</c:when>
					<c:when
						test="${resource_desc[rdfProperties['language']][0]=='es'}">
						<img src="${baseURL}es_ES.png" />&nbsp;<fmt:message key="meta.language.es" />
					</c:when>
					<c:when
						test="${resource_desc[rdfProperties['language']][0]=='gr'}">
						<img src="${baseURL}el_GR.png" />&nbsp;<fmt:message key="meta.language.gr" />
					</c:when>
					<c:when
						test="${resource_desc[rdfProperties['language']][0]=='ir'}">
						<img src="${baseURL}fa_IR.png" />&nbsp;<fmt:message key="meta.language.ir" />
					</c:when>
					<c:when
						test="${resource_desc[rdfProperties['language']][0]=='in'}">
						<img src="${baseURL}ind.png" />&nbsp;<fmt:message key="meta.language.in" />
					</c:when>
					<c:when
						test="${resource_desc[rdfProperties['language']][0]=='hr'}">
						<img src="${baseURL}croa.png" />&nbsp;<fmt:message key="meta.language.hr" />
					</c:when>
					<c:when
						test="${resource_desc[rdfProperties['language']][0]=='it'}">
						<img src="${baseURL}it_IT.png" />&nbsp;<fmt:message key="meta.language.it" />
					</c:when>
					<c:when
						test="${resource_desc[rdfProperties['language']][0]=='jp'}">
						<img src="${baseURL}ja_JP.png" />&nbsp;<fmt:message key="meta.language.jp" />
					</c:when>
					<c:when
						test="${resource_desc[rdfProperties['language']][0]=='kr'}">
						<img src="${baseURL}ko_KR.png" />&nbsp;<fmt:message key="meta.language.ko" />
					</c:when>
					<c:when
						test="${resource_desc[rdfProperties['language']][0]=='nl'}">
						<img src="${baseURL}nl_NL.png" />&nbsp;<fmt:message key="meta.language.nl" />
					</c:when>
					<c:when
						test="${resource_desc[rdfProperties['language']][0]=='pt'}">
						<img src="${baseURL}pt_PT.png" />&nbsp;<fmt:message key="meta.language.pt" />
					</c:when>
					
					<c:when
						test="${resource_desc[rdfProperties['language']][0]=='ru'}">
						<img src="${baseURL}ru_RU.png" />&nbsp;<fmt:message key="meta.language.ru" />
					</c:when>
					<c:when
						test="${resource_desc[rdfProperties['language']][0]=='ch'}">
						<img src="${baseURL}chi.png" />&nbsp;<fmt:message key="meta.language.ch" />
					</c:when>
					<c:otherwise>
						<i>${resource_desc[rdfProperties['language']][0]}</i>
					</c:otherwise>
				</c:choose>	
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['source'] && ! empty resource_desc[rdfProperties['source']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.source" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['source']][0]}</i>
			</td>
			</tr>
		</c:if>  <c:if
			test="${meta_conf_bean.properties['subject'] && ! empty resource_desc[rdfProperties['subject']]}">
			<tr>
			<th>
				<fmt:message key="meta.subject" />&nbsp;:
			</th>
			<td>
				<i>
				<c:forEach var="subject" items="${resource_desc[rdfProperties['subject']]}" varStatus="status">
					<c:if test="${status.count != 1}">
					,
					</c:if>
					${subject }
				</c:forEach>				
				</i>
			</td>
			</tr>
		</c:if><c:if
			test="${meta_conf_bean.properties['catego'] && ! empty resource_desc[rdfProperties['catego']]}">
			<tr>
			<th>
				<fmt:message key="meta.catego" />&nbsp;:
			</th>
			<td>
				<i>
				<c:forEach var="catego" items="${resource_desc[rdfProperties['catego']]}" varStatus="status">
					<c:if test="${status.count != 1}">
					,
					</c:if>
					${catego }
				</c:forEach>
				</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['type'] && ! empty resource_desc[rdfProperties['type']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.type" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['type']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['coverage'] && ! empty resource_desc[rdfProperties['coverage']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.coverage" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['coverage']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['extent'] && ! empty resource_desc[rdfProperties['extent']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.extent" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['extent']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['created'] && ! empty resource_desc[rdfProperties['created']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.created" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['created']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['gatheringDate'] && ! empty resource_desc[rdfProperties['gatheringDate']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.gatheringDate" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['gatheringDate']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['projectName'] && ! empty resource_desc[rdfProperties['projectName']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.projectName" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['projectName']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['hasOriginalFileSize'] && ! empty resource_desc[rdfProperties['hasOriginalFileSize']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.hasOriginalFileSize" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['hasOriginalFileSize']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['refersTo'] && ! empty resource_desc[rdfProperties['refersTo']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.refersTo" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['refersTo']][0]}</i>
			</td>
			</tr>
		</c:if> <c:if
			test="${meta_conf_bean.properties['seeAlso'] && ! empty resource_desc[rdfProperties['seeAlso']][0]}">
			<tr>
			<th>
				<fmt:message key="meta.seeAlso" />&nbsp;:
			</th>
			<td>
				<i>${resource_desc[rdfProperties['seeAlso']][0]}</i>
			</td>
			</tr>
		</c:if>
	</tbody></table>
</div>
