/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.portlet;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.util.ResourceUtil;
import org.ow2.weblab.core.helper.impl.AdvancedSelector;
import org.ow2.weblab.core.helper.impl.IPredicateValuePairs;
import org.ow2.weblab.core.helper.impl.RDFSelectorFactory;
import org.ow2.weblab.core.helper.impl.Statements;
import org.ow2.weblab.core.helper.impl.WTriple;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.services.ResourceContainer;
import org.ow2.weblab.core.services.resourcecontainer.LoadResourceArgs;
import org.ow2.weblab.portlet.WebLabPortlet;
import org.ow2.weblab.portlet.bean.AnnotationsDescBean;
import org.ow2.weblab.portlet.bean.MetaConfBean;
import org.ow2.weblab.portlet.bean.RepoServiceConfigBean;
import org.ow2.weblab.portlet.tool.ResourceContainerUtil;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;

public class MetaDataPortlet
extends WebLabPortlet {
    private static final String POK_PROPERTY_DOC_URI = "http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedTo";
    private static final String USER_MEDIA_UNIT = "user_media_unit";
    private static final String USER_MEDIA_UNIT_WTMAP = "user_mediaunit_triplemap";
    private static final String META_CONF_BEAN_ID = "meta_conf_bean";
    public static final String META_MAP_DESC = "resource_desc";
    public static MetaConfBean DEFAULT_META_CONF_BEAN;
    public static final String USER_META_CONF = "meta_conf_bean";
    private static final String USER_RES_ANNOTS_LOADED = "user_wtriple_map_isloaded";
    private static final String USER_MEDIA_UNIT_URI = "resource_uri";
    public static final String USER_REPO_CONF = "user_repo_service_conf";
    public static final String ERROR = "message_error";
    private static final String CURRENT_RESSOURCE_IS_LOADED = "user_resource_is_loaded";
    private Map<URL, ResourceContainer> repoMap;
    private AnnotationsDescBean rdfProperties;
    private Log logger;
    private static URL WSDL_REPO_URL;

    public void init() throws PortletException {
        super.init();
        this.repoMap = new HashMap();
        try {
            WSDL_REPO_URL = new File(this.getPortletContext().getRealPath("WEB-INF/classes/services/WebLab.wsdl")).toURI().toURL();
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)e);
        }
        ClassPathResource resource = new ClassPathResource("conf_meta.xml");
        XmlBeanFactory factory = new XmlBeanFactory((org.springframework.core.io.Resource)resource);
        this.rdfProperties = (AnnotationsDescBean)factory.getBean("metaConf", AnnotationsDescBean.class);
        DEFAULT_META_CONF_BEAN = (MetaConfBean)factory.getBean("meta_conf_bean", MetaConfBean.class);
        this.logger = LogFactory.getLog(this.getClass());
    }

    public void destroy() {
        this.repoMap = null;
        this.rdfProperties = null;
        super.destroy();
    }

    public void doView(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        long start = System.currentTimeMillis();
        boolean sessionExpired = false;
        res.setTitle(ResourceBundle.getBundle("meta_portlet", req.getLocale()).getString("portlet.title"));
        if (req.getPortletSession().getLastAccessedTime() + (long)(req.getPortletSession().getMaxInactiveInterval() * 1000) < System.currentTimeMillis()) {
            sessionExpired = true;
            req.setAttribute("message_warning", (Object)ResourceBundle.getBundle("meta_portlet", req.getLocale()).getString("portlet.warning.session_expired"));
        }
        if (!sessionExpired) {
            PortletRequestDispatcher rd;
            if (req.getParameter(ERROR) != null && !req.getParameter(ERROR).equals("")) {
                this.logger.error((Object)ERROR);
                req.setAttribute(ERROR, (Object)req.getParameter(ERROR));
                rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("error_page_url"));
                rd.include(req, res);
            }
            req.setAttribute(USER_MEDIA_UNIT, req.getPortletSession().getAttribute(USER_MEDIA_UNIT, 1));
            rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("view_page_url"));
            rd.include(req, res);
        } else {
            PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("warning_page_url"));
            rd.include(req, res);
        }
        this.logger.info((Object)("doView reponse time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    public void doEdit(RenderRequest req, RenderResponse res) throws PortletException, IOException {
        long start = System.currentTimeMillis();
        MetaConfBean metaConfbean = req.getPortletSession().getAttribute("meta_conf_bean", 1) == null ? DEFAULT_META_CONF_BEAN : (MetaConfBean)req.getPortletSession().getAttribute("meta_conf_bean", 1);
        req.setAttribute("meta_conf_bean", (Object)metaConfbean);
        RepoServiceConfigBean repoConfBean = req.getPortletSession().getAttribute(USER_REPO_CONF, 1) == null ? new RepoServiceConfigBean() : (RepoServiceConfigBean)req.getPortletSession().getAttribute(USER_REPO_CONF, 1);
        req.setAttribute(USER_REPO_CONF, (Object)repoConfBean);
        PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("edit_page_url"));
        rd.include(req, res);
        this.logger.info((Object)("doEdit reponse time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    public void processEvent(EventRequest req, EventResponse resp) throws PortletException, IOException {
        long start = System.currentTimeMillis();
        Document doc_evt = null;
        if (this.getReaction(req.getEvent().getQName()).getLocalPart().equals("displayMeta")) {
            req.getPortletSession().setAttribute(CURRENT_RESSOURCE_IS_LOADED, (Object)true, 1);
            doc_evt = (Document)req.getEvent().getValue();
            this.logger.info((Object)"receive a loaded document");
        } else if (this.getReaction(req.getEvent().getQName()).getLocalPart().equals("loadAndDisplayMeta")) {
            req.getPortletSession().setAttribute(CURRENT_RESSOURCE_IS_LOADED, (Object)false, 1);
            PieceOfKnowledge pok = (PieceOfKnowledge)req.getEvent().getValue();
            String docURI = this.getURIFromPoK(pok);
            if (docURI != null) {
                doc_evt = new Document();
                doc_evt.setUri(docURI);
                this.logger.info((Object)("receive an unloaded document with URI : " + doc_evt.getUri()));
            } else {
                try {
                    this.logger.info((Object)("receive an unloaded document with unavailable URI (null), corresponding PoK :" + ResourceUtil.saveToXMLString((Resource)pok)));
                }
                catch (WebLabCheckedException e) {
                    this.logger.debug((Object)"Unable to get PoK XML");
                }
            }
        } else {
            this.logger.info((Object)("Unsupported event :" + req.getEvent().getQName()));
        }
        if (doc_evt != null) {
            req.getPortletSession().setAttribute(USER_MEDIA_UNIT, (Object)doc_evt, 1);
            req.getPortletSession().setAttribute(USER_RES_ANNOTS_LOADED, (Object)false, 1);
        }
        this.logger.info((Object)("process event " + req.getEvent().getQName() + "reponse time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        long start = System.currentTimeMillis();
        MediaUnit unit = null;
        if (request.getPortletSession().getAttribute(USER_MEDIA_UNIT, 1) != null && request.getPortletSession().getAttribute(CURRENT_RESSOURCE_IS_LOADED, 1) != null) {
            String uri_to_load;
            unit = (MediaUnit)request.getPortletSession().getAttribute(USER_MEDIA_UNIT, 1);
            if (!((Boolean)request.getPortletSession().getAttribute(CURRENT_RESSOURCE_IS_LOADED, 1)).booleanValue() && (uri_to_load = unit.getUri()) != null) {
                boolean loaded = false;
                this.logger.info((Object)("new resource to load : " + uri_to_load));
                LoadResourceArgs args = new LoadResourceArgs();
                args.setResourceId(uri_to_load);
                Resource loadedResource = null;
                if (request.getPortletSession().getAttribute(USER_REPO_CONF, 1) == null) {
                    RepoServiceConfigBean repo_conf = new RepoServiceConfigBean();
                    repo_conf.setServiceURL(this.getInitParameter("repo_service_url"));
                    request.getPortletSession().setAttribute(USER_REPO_CONF, (Object)repo_conf, 1);
                }
                URL repoURL = new URL(((RepoServiceConfigBean)request.getPortletSession().getAttribute(USER_REPO_CONF, 1)).getServiceURL());
                this.logger.info((Object)("use repository : " + repoURL.toString()));
                try {
                    ResourceContainer repo = this.getRepoService(repoURL);
                    loadedResource = repo.loadResource(args).getResource();
                    loaded = true;
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                    request.setAttribute(ERROR, (Object)"Unable to get resource on repository service");
                    loaded = false;
                }
                if (loaded && loadedResource instanceof MediaUnit) {
                    unit = (MediaUnit)loadedResource;
                    request.getPortletSession().setAttribute(USER_MEDIA_UNIT, (Object)unit, 1);
                    request.getPortletSession().setAttribute(CURRENT_RESSOURCE_IS_LOADED, (Object)true, 1);
                }
            }
            if (request.getAttribute(ERROR) != null) {
                response.setContentType("text/html");
                PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("error_page_url"));
                rd.include((PortletRequest)request, (PortletResponse)response);
            } else {
                Statements mediaUnitWTMap = null;
                Document doc = (Document)request.getPortletSession().getAttribute(USER_MEDIA_UNIT, 1);
                if (request.getPortletSession().getAttribute(USER_RES_ANNOTS_LOADED, 1) != null && !((Boolean)request.getPortletSession().getAttribute(USER_RES_ANNOTS_LOADED, 1)).booleanValue()) {
                    AdvancedSelector rdfSelector = RDFSelectorFactory.getSelector((boolean)true, (String[])new String[0]);
                    rdfSelector.limitToFirstLevelAnnotation(true);
                    mediaUnitWTMap = rdfSelector.searchFor((Resource)doc, this.rdfProperties.getDisctinctAnnotationsNS());
                    request.getPortletSession().setAttribute(USER_MEDIA_UNIT_WTMAP, (Object)mediaUnitWTMap, 1);
                    request.getPortletSession().setAttribute(USER_RES_ANNOTS_LOADED, (Object)true, 1);
                }
                if (request.getPortletSession().getAttribute(USER_MEDIA_UNIT_WTMAP, 1) != null) {
                    mediaUnitWTMap = (Statements)request.getPortletSession().getAttribute(USER_MEDIA_UNIT_WTMAP, 1);
                    HashMap res_desc = new HashMap();
                    for (WTriple statement : ((IPredicateValuePairs)mediaUnitWTMap.get((Object)doc.getUri())).getStatements()) {
                        LinkedList<String> l = new LinkedList<String>();
                        if (((IPredicateValuePairs)mediaUnitWTMap.get((Object)doc.getUri())).getValue(statement.getPredicate()) instanceof List) {
                            l.addAll((List)((IPredicateValuePairs)mediaUnitWTMap.get((Object)doc.getUri())).getValue(statement.getPredicate()));
                        } else {
                            l.add((String)((IPredicateValuePairs)mediaUnitWTMap.get((Object)doc.getUri())).getValue(statement.getPredicate()));
                        }
                        res_desc.put(statement.getPredicate(), l);
                    }
                    request.setAttribute(META_MAP_DESC, res_desc);
                    request.setAttribute(USER_MEDIA_UNIT_URI, (Object)doc.getUri());
                    request.setAttribute("rdfProperties", (Object)this.rdfProperties.getProperties());
                }
                this.logger.debug((Object)("resource map " + mediaUnitWTMap));
                MetaConfBean res_conf = (MetaConfBean)request.getPortletSession().getAttribute("meta_conf_bean", 1);
                if (res_conf == null) {
                    request.setAttribute("meta_conf_bean", (Object)DEFAULT_META_CONF_BEAN);
                } else {
                    request.setAttribute("meta_conf_bean", (Object)res_conf);
                }
                response.setContentType("text/html");
                PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("view_metat_ajax_page_url"));
                rd.include((PortletRequest)request, (PortletResponse)response);
            }
        }
        this.logger.info((Object)("serveResource reponse time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    private ResourceContainer getRepoService(URL serviceURL) {
        if (!this.repoMap.containsKey(serviceURL)) {
            this.logger.info((Object)("Building repo at [" + serviceURL + "]"));
            this.repoMap.put(serviceURL, ResourceContainerUtil.getResourceContainerService((URL)WSDL_REPO_URL, (URL)serviceURL));
        }
        return (ResourceContainer)this.repoMap.get(serviceURL);
    }

    private String getURIFromPoK(PieceOfKnowledge pok) {
        AdvancedSelector rdfSelector;
        Statements map;
        if (pok != null && (map = (rdfSelector = RDFSelectorFactory.getSelector((boolean)true, (String[])new String[0])).searchFor((Resource)pok, new String[]{POK_PROPERTY_DOC_URI})) != null && !map.entrySet().isEmpty()) {
            return (String)((IPredicateValuePairs)((Map.Entry)map.entrySet().iterator().next()).getValue()).getValue(POK_PROPERTY_DOC_URI);
        }
        return null;
    }
}

