/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.portlet;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.EventResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.model.Resource;

public abstract class WebLabPortlet
extends GenericPortlet {
    private transient Map<QName, QName> reactionEventMap = new HashMap<QName, QName>();
    private transient Map<QName, QName> actionEventMap = new HashMap<QName, QName>();
    private transient Map<QName, String> redirectEventMap = new HashMap<QName, String>();
    public static final String PORTLET_ACTION_NAMESPACE = "{http://weblab.ow2.org/portlet/action}";
    public static final String PORTLET_REACTION_NAMESPACE = "{http://weblab.ow2.org/portlet/reaction}";
    public static final String PORTLET_REDIRECT_NAMESPACE = "{http://weblab.ow2.org/portlet/redirection}";

    public void init() throws PortletException {
        this.initMappings();
    }

    public Map<QName, QName> getReactionEventMap() {
        return this.reactionEventMap;
    }

    public Map<QName, QName> getActionEventMap() {
        return this.actionEventMap;
    }

    public Map<QName, String> getRedirectEventMap() {
        return this.redirectEventMap;
    }

    public QName getReaction(QName specifiedQName) {
        return this.reactionEventMap.get(specifiedQName);
    }

    public void sendEventForAction(String action, Resource resource, ActionResponse actionResponse) {
        if (this.getPortletConfig().getInitParameter(PORTLET_ACTION_NAMESPACE + action) != null && !this.getPortletConfig().getInitParameter(PORTLET_ACTION_NAMESPACE + action).equals("")) {
            QName qnOfAction = QName.valueOf(this.getPortletConfig().getInitParameter(PORTLET_ACTION_NAMESPACE + action));
            actionResponse.setEvent(qnOfAction, (Serializable)resource);
        } else {
            LogFactory.getLog(((Object)((Object)this)).getClass()).info((Object)("Warning : You try to send an event for an undefined action ({http://weblab.ow2.org/portlet/action}" + action + "). Check your portlet.xml file."));
        }
    }

    public void sendEventForAction(String action, Resource resource, EventResponse eventResponse) {
        if (this.getPortletConfig().getInitParameter(PORTLET_ACTION_NAMESPACE + action) != null && !this.getPortletConfig().getInitParameter(PORTLET_ACTION_NAMESPACE + action).equals("")) {
            QName qnOfAction = QName.valueOf(this.getPortletConfig().getInitParameter(PORTLET_ACTION_NAMESPACE + action));
            eventResponse.setEvent(qnOfAction, (Serializable)resource);
        } else {
            LogFactory.getLog(((Object)((Object)this)).getClass()).info((Object)("Warning : You try to send an event for an undefined action ({http://weblab.ow2.org/portlet/action}" + action + "). Check your portlet.xml file."));
        }
    }

    public void sendEventForActionAndRedirect(String action, Resource resource, ActionResponse actionResponse) throws IOException {
        if (this.getPortletConfig().getInitParameter(PORTLET_ACTION_NAMESPACE + action) != null && !this.getPortletConfig().getInitParameter(PORTLET_ACTION_NAMESPACE + action).equals("")) {
            QName qnOfAction = QName.valueOf(this.getPortletConfig().getInitParameter(PORTLET_ACTION_NAMESPACE + action));
            actionResponse.setEvent(qnOfAction, (Serializable)resource);
            String url = this.redirectEventMap.get(QName.valueOf(PORTLET_REDIRECT_NAMESPACE + action));
            if (url == null || url.equals("")) {
                LogFactory.getLog(((Object)((Object)this)).getClass()).info((Object)("Automatic redirection failed. Url null for the event(" + qnOfAction + ") from " + actionResponse.getNamespace() + "."));
            } else {
                actionResponse.sendRedirect(this.redirectEventMap.get(QName.valueOf(PORTLET_REDIRECT_NAMESPACE + action)));
                LogFactory.getLog(((Object)((Object)this)).getClass()).info((Object)("Automatic redirection to url " + url + " after sending the event(" + qnOfAction + ") from " + actionResponse.getNamespace() + "."));
            }
        } else {
            LogFactory.getLog(((Object)((Object)this)).getClass()).info((Object)("Warning : You try to send an event for an undefined action ({http://weblab.ow2.org/portlet/action}" + action + "). Check your portlet.xml file."));
        }
    }

    private void initMappings() {
        Enumeration initParam = this.getPortletConfig().getInitParameterNames();
        while (initParam.hasMoreElements()) {
            String param = (String)initParam.nextElement();
            String value = this.getPortletConfig().getInitParameter(param);
            for (String s : value.split(" ")) {
                if (!param.startsWith(PORTLET_REACTION_NAMESPACE)) continue;
                try {
                    this.reactionEventMap.put(QName.valueOf(s), QName.valueOf(param));
                }
                catch (IllegalArgumentException e) {
                    LogFactory.getLog(((Object)((Object)this)).getClass()).warn((Object)"Invalid reaction event mapping qname. Check the init parameters for event reaction mapping in portlet.xml.");
                }
            }
            for (String s : value.split(" ")) {
                if (!param.startsWith(PORTLET_ACTION_NAMESPACE)) continue;
                try {
                    this.actionEventMap.put(QName.valueOf(s), QName.valueOf(param));
                }
                catch (IllegalArgumentException e) {
                    LogFactory.getLog(((Object)((Object)this)).getClass()).warn((Object)"Invalid action event mapping qname. Check the init parameters for event action mapping in portlet.xml.");
                }
            }
            if (!param.startsWith(PORTLET_REDIRECT_NAMESPACE)) continue;
            try {
                this.redirectEventMap.put(QName.valueOf(param), value);
            }
            catch (IllegalArgumentException e) {
                LogFactory.getLog(((Object)((Object)this)).getClass()).warn((Object)"Invalid redirect event mapping qname. Check the init parameters for event redirection mapping in portlet.xml.");
            }
        }
    }

    public void addRedirection(QName qn, String url) {
        this.redirectEventMap.put(qn, url);
    }

    public void modifyRedirection(QName qn, String url) {
        if (this.redirectEventMap.containsKey(qn)) {
            this.redirectEventMap.put(qn, url);
        } else {
            LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)"Impossible to modify the redirect event map since the key (QName) has not been found");
        }
    }

    public void deleteRedirection(QName qn) {
        if (this.redirectEventMap.containsKey(qn)) {
            this.redirectEventMap.remove(qn);
        } else {
            LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)"Impossible to delete the QName of the redirect event map since the key (QName) has not been found");
        }
    }

    public File getFile(String localPath) throws WebLabCheckedException {
        File f = new File(this.getPortletContext().getRealPath(localPath));
        if (f.exists()) {
            return f;
        }
        throw new WebLabCheckedException("File " + localPath + " doesn't exist");
    }

    public URL getURL(String localPath) throws WebLabCheckedException {
        File f = new File(this.getPortletContext().getRealPath(localPath));
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new WebLabCheckedException("Invalid URL for File" + localPath);
        }
    }
}

