/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.cleaner;

import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.jws.WebService;
import org.apache.commons.logging.LogFactory;
import org.weblab_project.core.exception.WebLabUncheckedException;
import org.weblab_project.core.helper.BeanHelper;
import org.weblab_project.core.helper.PoKHelperExtended;
import org.weblab_project.core.helper.RDFHelperFactory;
import org.weblab_project.core.model.Annotation;
import org.weblab_project.core.model.ComposedUnit;
import org.weblab_project.core.model.LowLevelDescriptor;
import org.weblab_project.core.model.MediaUnit;
import org.weblab_project.core.model.PieceOfKnowledge;
import org.weblab_project.core.model.Resource;
import org.weblab_project.core.model.Segment;
import org.weblab_project.core.model.structure.Cell;
import org.weblab_project.core.model.structure.Line;
import org.weblab_project.core.model.structure.Table;
import org.weblab_project.services.analyser.Analyser;
import org.weblab_project.services.analyser.ProcessException;
import org.weblab_project.services.analyser.types.ProcessArgs;
import org.weblab_project.services.analyser.types.ProcessReturn;
import org.weblab_project.services.exception.WebLabException;

@WebService(endpointInterface="org.weblab_project.services.analyser.Analyser")
public class Cleaner
implements Analyser {
    private Set<String> exactPropsToRemove = new HashSet<String>();
    private Set<Pattern> regexPropsToRemove = new HashSet<Pattern>();
    private boolean removeRDFTypeOnURI = false;
    private boolean initialised = false;
    private static final String REGEX_SET = "regexSet";
    private static final String EXACT_SET = "exactSet";
    private static final String REMOVE_TYPE = "removeType";
    private static final String BEAN = "AnnotationCleaner.xml";
    private static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";

    public ProcessReturn process(ProcessArgs args) throws ProcessException {
        Resource res = this.checkArgs(args);
        this.init();
        if (!this.exactPropsToRemove.isEmpty() || !this.regexPropsToRemove.isEmpty()) {
            this.clean(res);
        }
        ProcessReturn ret = new ProcessReturn();
        ret.setResource(res);
        return ret;
    }

    private void clean(Resource res) {
        if (!res.getAnnotation().isEmpty()) {
            ListIterator li = res.getAnnotation().listIterator();
            PoKHelperExtended ahe = RDFHelperFactory.getPoKHelperExtended((PieceOfKnowledge)new Annotation());
            ahe.setAutoCommitMode(false);
            while (li.hasNext()) {
                ahe.setPoK((PieceOfKnowledge)li.next());
                for (String property : this.exactPropsToRemove) {
                    ahe.removeStatsWithPred(property);
                }
                for (String property : ahe.getPreds()) {
                    for (Pattern p : this.regexPropsToRemove) {
                        Matcher m = p.matcher(property);
                        if (!m.matches()) continue;
                        ahe.removeStatsWithPred(property);
                    }
                }
                int size = ahe.getPreds().size();
                if (size == 0) {
                    li.remove();
                    continue;
                }
                if (size == ahe.getRessOnPredSubj(res.getUri(), RDF_TYPE).size() + ahe.getAnonRessOnPredSubj(res.getUri(), RDF_TYPE).size() + ahe.getLitsOnPredSubj(res.getUri(), RDF_TYPE).size() && this.removeRDFTypeOnURI) {
                    li.remove();
                    continue;
                }
                ahe.commit();
            }
        }
        for (Annotation annot : res.getAnnotation()) {
            this.clean((Resource)annot);
        }
        for (LowLevelDescriptor lld : res.getDescriptor()) {
            this.clean((Resource)lld);
        }
        if (res instanceof MediaUnit) {
            this.cleanMediaUnit((MediaUnit)res);
        }
    }

    private void cleanMediaUnit(MediaUnit mu) {
        ListIterator li = mu.getSegment().listIterator();
        while (li.hasNext()) {
            Segment seg = (Segment)li.next();
            this.clean((Resource)seg);
            if (!seg.getAnnotation().isEmpty()) continue;
            li.remove();
        }
        if (mu instanceof ComposedUnit) {
            for (MediaUnit innerMu : ((ComposedUnit)mu).getMediaUnit()) {
                this.clean((Resource)innerMu);
            }
        } else if (mu instanceof Table) {
            for (Line line : ((Table)mu).getLine()) {
                this.clean((Resource)line);
            }
        } else if (mu instanceof Line) {
            for (Cell cell : ((Line)mu).getCell()) {
                this.clean((Resource)cell);
            }
        } else if (mu instanceof Cell) {
            this.clean((Resource)((Cell)mu).getMediaUnit());
        }
    }

    private Resource checkArgs(ProcessArgs args) throws ProcessException {
        if (args == null) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E1");
            wle.setErrorMessage("Invalid parameter.");
            throw new ProcessException("ProcessArgs was null.", wle);
        }
        if (args.getResource() == null) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E1");
            wle.setErrorMessage("Invalid parameter.");
            throw new ProcessException("Resource of ProcessArgs was null.", wle);
        }
        return args.getResource();
    }

    private synchronized void init() {
        if (!this.initialised) {
            boolean b;
            HashSet regexSet;
            HashSet exactSet;
            BeanHelper bh = BeanHelper.getInstance().getSpecificInstance(BEAN, true);
            try {
                exactSet = (HashSet)bh.getBean(EXACT_SET, Set.class);
            }
            catch (WebLabUncheckedException wlue) {
                LogFactory.getLog(this.getClass()).warn((Object)"Unable to retrieve exact set.", (Throwable)wlue);
                exactSet = new HashSet();
            }
            for (Object obj : exactSet) {
                this.exactPropsToRemove.add(obj.toString().trim());
            }
            try {
                regexSet = (HashSet)bh.getBean(REGEX_SET, Set.class);
            }
            catch (WebLabUncheckedException wlue) {
                LogFactory.getLog(this.getClass()).warn((Object)"Unable to retrieve regex set.", (Throwable)wlue);
                regexSet = new HashSet();
            }
            for (Object obj : regexSet) {
                Pattern p;
                try {
                    p = Pattern.compile(obj.toString().trim());
                }
                catch (PatternSyntaxException pse) {
                    LogFactory.getLog(this.getClass()).warn((Object)("Pattern '" + obj.toString() + "' is invalid."), (Throwable)pse);
                    continue;
                }
                this.regexPropsToRemove.add(p);
            }
            try {
                b = (Boolean)bh.getBean(REMOVE_TYPE, Boolean.class);
            }
            catch (WebLabUncheckedException wlue) {
                LogFactory.getLog(this.getClass()).warn((Object)"Unable to retrieve boolean.", (Throwable)wlue);
                b = false;
            }
            this.removeRDFTypeOnURI = b;
            this.initialised = true;
        }
    }
}

