/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.blremover;

import java.util.List;
import java.util.regex.Pattern;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.weblab_project.core.model.ComposedUnit;
import org.weblab_project.core.model.Document;
import org.weblab_project.core.model.Resource;
import org.weblab_project.core.model.text.Text;
import org.weblab_project.core.util.ComposedUnitUtil;
import org.weblab_project.services.analyser.Analyser;
import org.weblab_project.services.analyser.ProcessException;
import org.weblab_project.services.analyser.types.ProcessArgs;
import org.weblab_project.services.analyser.types.ProcessReturn;
import org.weblab_project.services.exception.WebLabException;

@WebService(endpointInterface="org.weblab_project.services.analyser.Analyser")
public class BlankLineRemoverService
implements Analyser {
    private static Log LOG = LogFactory.getLog(BlankLineRemoverService.class);

    public ProcessReturn process(ProcessArgs args) throws ProcessException {
        LOG.debug((Object)"Start of process method.");
        List<Text> textList = BlankLineRemoverService.checkArgs(args);
        Resource res = args.getResource();
        LOG.info((Object)("Beginning process with MediaUnit: " + res.getUri() + "."));
        Pattern p = Pattern.compile("^\\s+$", 8);
        for (Text text : textList) {
            String textContent = text.getContent();
            textContent = p.matcher(textContent).replaceAll("\n");
            textContent = textContent.replaceAll("[\\r\\n]{2,}|(?:\\r\\n){2,}$", "\n\n");
            textContent = textContent.replace("\r\n", "\n");
            text.setContent(textContent);
        }
        ProcessReturn pr = new ProcessReturn();
        pr.setResource(res);
        LOG.info((Object)("MediaUnit: " + res.getUri() + " successfully processed."));
        return pr;
    }

    private static List<Text> checkArgs(ProcessArgs args) throws ProcessException {
        if (args == null) {
            throw BlankLineRemoverService.createProcessEx("ProcessArgs was null.", "E1", null, null);
        }
        Resource res = args.getResource();
        if (res == null) {
            throw BlankLineRemoverService.createProcessEx("Resource in ProcessArgs was null.", "E1", null, null);
        }
        if (!(res instanceof Document)) {
            throw BlankLineRemoverService.createProcessEx("Resource in ProcessArgs was not a Document, but a " + res.getClass().getName() + ".", "E1", null, "URI of the buggy resource: " + res.getUri() + ".");
        }
        return ComposedUnitUtil.getSelectedSubMediaUnits((ComposedUnit)((ComposedUnit)res), Text.class);
    }

    private static ProcessException createProcessEx(String message, String errorId, Throwable cause, String details) {
        ProcessException pe;
        WebLabException wle = new WebLabException();
        wle.setErrorId(errorId);
        if (errorId.equals("E0")) {
            wle.setErrorMessage("Unexpected error.");
        } else if (errorId.equals("E1")) {
            wle.setErrorMessage("Invalid parameter.");
        } else if (errorId.equals("E2")) {
            wle.setErrorMessage("Insufficient resources.");
        } else if (errorId.equals("E3")) {
            wle.setErrorMessage("Content not available.");
        } else if (errorId.equals("E4")) {
            wle.setErrorMessage("Access denied.");
        } else if (errorId.equals("E5")) {
            wle.setErrorMessage("Unsupported request.");
        } else {
            LOG.warn((Object)("Unknown error ID: " + errorId));
            wle.setErrorMessage("Unknown error.");
        }
        if (cause == null) {
            LOG.error((Object)message);
            pe = new ProcessException(message, wle);
        } else {
            LOG.error((Object)message, cause);
            pe = new ProcessException(message, wle, cause);
        }
        if (details != null) {
            LOG.error((Object)details);
        }
        LOG.debug((Object)"End of process method.");
        return pe;
    }
}

