/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.content.consumer.impl;

import javax.jws.WebService;
import org.ow2.weblab.content.binary.BinaryFolderContentManager;
import org.ow2.weblab.content.text.TextFolderContentManager;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.model.content.BinaryContent;
import org.weblab_project.core.model.content.Content;
import org.weblab_project.core.model.content.TextContent;
import org.weblab_project.services.contentconsumer.ContentConsumer;
import org.weblab_project.services.contentconsumer.SetContentException;
import org.weblab_project.services.contentconsumer.types.SetContentArgs;
import org.weblab_project.services.contentconsumer.types.SetContentReturn;
import org.weblab_project.services.exception.WebLabException;

@WebService(endpointInterface="org.weblab_project.services.contentconsumer.ContentConsumer")
public class ContentConsumerService
implements ContentConsumer {
    protected BinaryFolderContentManager binaryContentManager = null;
    protected TextFolderContentManager textContentManager = null;

    public SetContentReturn setContent(SetContentArgs args) throws SetContentException {
        if (args.getContent() instanceof TextContent) {
            TextContent textContent = (TextContent)args.getContent();
            if (this.textContentManager == null) {
                this.textContentManager = TextFolderContentManager.getInstance();
            }
            try {
                this.textContentManager.saveContent((Content)textContent);
            }
            catch (WebLabCheckedException wlce) {
                WebLabException exp = new WebLabException();
                exp.setErrorId("E0");
                exp.setErrorMessage("Unexpected error");
                throw new SetContentException("An error occurs when saving text content.", exp, (Throwable)wlce);
            }
        } else if (args.getContent() instanceof BinaryContent) {
            BinaryContent binContent = (BinaryContent)args.getContent();
            if (this.binaryContentManager == null) {
                this.binaryContentManager = BinaryFolderContentManager.getInstance();
            }
            try {
                this.binaryContentManager.saveContent((Content)binContent);
            }
            catch (WebLabCheckedException wlce) {
                WebLabException exp = new WebLabException();
                exp.setErrorId("E0");
                exp.setErrorMessage("Unexpected error");
                throw new SetContentException("An error occurs when saving binary content.", exp, (Throwable)wlce);
            }
        } else {
            WebLabException exp = new WebLabException();
            exp.setErrorId("E1");
            exp.setErrorMessage("Invalid parameter");
            throw new SetContentException("Content class is not handled: " + args.getContent().getClass().getName() + ".", exp);
        }
        SetContentReturn ret = new SetContentReturn();
        return ret;
    }
}

