/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.services.content.consumer.impl;

import javax.jws.WebService;

import org.ow2.weblab.content.binary.BinaryFolderContentManager;
import org.ow2.weblab.content.text.TextFolderContentManager;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.model.content.BinaryContent;
import org.weblab_project.core.model.content.TextContent;
import org.weblab_project.services.contentconsumer.ContentConsumer;
import org.weblab_project.services.contentconsumer.SetContentException;
import org.weblab_project.services.contentconsumer.types.SetContentArgs;
import org.weblab_project.services.contentconsumer.types.SetContentReturn;
import org.weblab_project.services.exception.WebLabException;

@WebService(endpointInterface = "org.weblab_project.services.contentconsumer.ContentConsumer")
public class ContentConsumerService implements ContentConsumer {

	protected BinaryFolderContentManager binaryContentManager = null;

	protected TextFolderContentManager textContentManager = null;

	public SetContentReturn setContent(final SetContentArgs args)
			throws SetContentException {
		if (args.getContent() instanceof TextContent) {
			TextContent textContent = (TextContent) args.getContent();
			if (this.textContentManager == null) {
				this.textContentManager = TextFolderContentManager
						.getInstance();
			}
			try {
				this.textContentManager.saveContent(textContent);
			} catch (final WebLabCheckedException wlce) {
				WebLabException exp = new WebLabException();
				exp.setErrorId("E0");
				exp.setErrorMessage("Unexpected error");
				throw new SetContentException("An error occurs "
						+ "when saving text content.", exp, wlce);
			}

		} else if (args.getContent() instanceof BinaryContent) {
			BinaryContent binContent = (BinaryContent) args.getContent();
			if (this.binaryContentManager == null) {
				this.binaryContentManager = BinaryFolderContentManager
						.getInstance();
			}
			try {
				this.binaryContentManager.saveContent(binContent);
			} catch (final WebLabCheckedException wlce) {
				WebLabException exp = new WebLabException();
				exp.setErrorId("E0");
				exp.setErrorMessage("Unexpected error");
				throw new SetContentException("An error occurs "
						+ "when saving binary content.", exp, wlce);
			}
		} else {
			WebLabException exp = new WebLabException();
			exp.setErrorId("E1");
			exp.setErrorMessage("Invalid parameter");
			throw new SetContentException("Content class is not handled: "
					+ args.getContent().getClass().getName() + ".", exp);
		}
		SetContentReturn ret = new SetContentReturn();
		return ret;
	}
}
