/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.content.provider.impl;

import java.io.File;
import javax.jws.WebService;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.content.binary.BinaryFolderContentManager;
import org.ow2.weblab.content.text.TextFolderContentManager;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.model.content.Content;
import org.weblab_project.services.contentprovider.ContentProvider;
import org.weblab_project.services.contentprovider.GetContentException;
import org.weblab_project.services.contentprovider.types.GetContentArgs;
import org.weblab_project.services.contentprovider.types.GetContentReturn;
import org.weblab_project.services.exception.WebLabException;

@WebService(endpointInterface="org.weblab_project.services.contentprovider.ContentProvider")
public class ContentProviderService
implements ContentProvider {
    protected BinaryFolderContentManager binaryFolderContentManager = null;
    protected TextFolderContentManager textFolderContentManager = null;

    public GetContentReturn getContent(GetContentArgs args) throws GetContentException {
        this.checkArgs(args);
        if (this.binaryFolderContentManager == null) {
            this.binaryFolderContentManager = BinaryFolderContentManager.getInstance();
        }
        File file = this.binaryFolderContentManager.getFileFromWLRi(args.getContentId());
        LogFactory.getLog(this.getClass()).debug((Object)("File loaded from WLRI : " + file.getAbsolutePath()));
        GetContentReturn ret = new GetContentReturn();
        if (file.exists()) {
            try {
                ret.setContent((Content)this.binaryFolderContentManager.getContent(args.getContentId(), args.getOffset().intValue(), args.getLimit().intValue()));
            }
            catch (WebLabCheckedException wlce) {
                WebLabException wExp = new WebLabException();
                wExp.setErrorId("E1");
                wExp.setErrorMessage("Invalid parameter.");
                GetContentException exp = new GetContentException("Unable to get binary content.", wExp, (Throwable)wlce);
                throw exp;
            }
        }
        if (this.textFolderContentManager == null) {
            this.textFolderContentManager = TextFolderContentManager.getInstance();
        }
        try {
            ret.setContent((Content)this.textFolderContentManager.getContent(args.getContentId(), args.getOffset().intValue(), args.getLimit().intValue()));
        }
        catch (WebLabCheckedException wlce) {
            WebLabException wExp = new WebLabException();
            wExp.setErrorId("E1");
            wExp.setErrorMessage("Invalid parameter.");
            GetContentException exp = new GetContentException("Unable to get text content.", wExp, (Throwable)wlce);
            throw exp;
        }
        return ret;
    }

    private void checkArgs(GetContentArgs args) throws GetContentException {
        if (args == null) {
            WebLabException wExp = new WebLabException();
            wExp.setErrorId("E1");
            wExp.setErrorMessage("Invalid parameter.");
            GetContentException exp = new GetContentException("GetContentArgs was null.", wExp);
            throw exp;
        }
        if (args.getContentId() == null) {
            WebLabException wExp = new WebLabException();
            wExp.setErrorId("E1");
            wExp.setErrorMessage("Invalid parameter.");
            GetContentException exp = new GetContentException("Content Id was null.", wExp);
            throw exp;
        }
    }
}

