/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.repository.file.impl;

import javax.jws.WebService;

import org.ow2.weblab.repository.file.FileRepository;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.model.Resource;
import org.weblab_project.services.exception.WebLabException;
import org.weblab_project.services.resourcecontainer.GetResourceException;
import org.weblab_project.services.resourcecontainer.ResourceContainer;
import org.weblab_project.services.resourcecontainer.SaveResourceException;
import org.weblab_project.services.resourcecontainer.types.GetResourceArgs;
import org.weblab_project.services.resourcecontainer.types.GetResourceReturn;
import org.weblab_project.services.resourcecontainer.types.SaveResourceArgs;
import org.weblab_project.services.resourcecontainer.types.SaveResourceReturn;


@WebService(endpointInterface = "org.weblab_project.services.resourcecontainer.ResourceContainer")
public class FileRepositoryService implements ResourceContainer {

	protected FileRepository repo;

	public GetResourceReturn getResource(final GetResourceArgs args)
			throws GetResourceException {
		if (this.repo == null) {
			try {
				this.repo = FileRepository.newInstance();
			} catch (final WebLabCheckedException wlce) {
				WebLabException ex = new WebLabException();
				ex.setErrorId("E2");
				ex.setErrorMessage("Insufficient resources.");
				throw new GetResourceException("Unable to load repo.", ex, wlce);
			}
		}
		if (args == null) {
			WebLabException ex = new WebLabException();
			ex.setErrorId("E1");
			ex.setErrorMessage("Invalid parameter.");
			throw new GetResourceException("GetResourceArgs was null.", ex);
		}
		final String resId = args.getResourceId();
		if (resId == null || resId.trim().equals("")) {
			WebLabException ex = new WebLabException();
			ex.setErrorId("E1");
			ex.setErrorMessage("Invalid parameter.");
			throw new GetResourceException("ResourceId in "
					+ "GetResourceArgs was null or empty.", ex);
		}

		GetResourceReturn ret = new GetResourceReturn();
		try {
			ret.setResource(this.repo.getResource(resId));
		} catch (final WebLabCheckedException wlce) {
			WebLabException ex = new WebLabException();
			ex.setErrorId("E1");
			ex.setErrorMessage("Invalid parameter.");
			throw new GetResourceException(wlce.getMessage(), ex, wlce);
		}

		return ret;
	}

	public SaveResourceReturn saveResource(final SaveResourceArgs args)
			throws SaveResourceException {
		if (this.repo == null) {
			try {
				this.repo = FileRepository.newInstance();
			} catch (final WebLabCheckedException wlce) {
				WebLabException ex = new WebLabException();
				ex.setErrorId("E2");
				ex.setErrorMessage("Insufficient resources.");
				throw new SaveResourceException("Unable to load repo.", ex,
						wlce);
			}
		}

		if (args == null) {
			WebLabException ex = new WebLabException();
			ex.setErrorId("E1");
			ex.setErrorMessage("Invalid parameter.");
			throw new SaveResourceException("SaveResourceArgs was null.", ex);
		}
		Resource res = args.getResource();
		if (res == null || res.getUri() == null) {
			WebLabException ex = new WebLabException();
			ex.setErrorId("E1");
			ex.setErrorMessage("Invalid parameter.");
			throw new SaveResourceException("Resource "
					+ "SaveResourceException was null without URI.", ex);
		}

		SaveResourceReturn ret = new SaveResourceReturn();
		try {
			ret.setResourceId(this.repo.saveResource(res));
		} catch (final WebLabCheckedException wlce) {
			WebLabException ex = new WebLabException();
			ex.setErrorId("E1");
			ex.setErrorMessage("Invalid parameter.");
			throw new SaveResourceException(wlce.getMessage(), ex, wlce);
		}
		return ret;
	}

}
