/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.repository.file;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.exception.WebLabRISyntaxException;

public class RepoRI {
    public static final String WLRI_REGEX = "^weblab:(//([^/?#\\n]+))+/(([^/?#\\n][^?#\\n]+)(\\?([^#\\n]+))?)+(#([^\\n]+))?";
    public static final String WLRI_SCHEME = "weblab";
    private URI uri;
    private String idReference;
    private String idResource;
    private String fragment;

    public RepoRI(String uriStr) throws WebLabCheckedException {
        try {
            this.uri = new URI(uriStr);
        }
        catch (URISyntaxException urise) {
            throw new WebLabCheckedException("Unalbe to create URI from: '" + uriStr + "'.", (Throwable)urise);
        }
        if (!this.uri.getScheme().equals(WLRI_SCHEME)) {
            throw new WebLabCheckedException("Scheme must be weblab, founded " + this.uri.getScheme());
        }
        Pattern p = Pattern.compile(WLRI_REGEX);
        Matcher m = p.matcher(uriStr);
        if (!m.matches()) {
            throw new WebLabCheckedException("Unvalid WebLabRI: '" + uriStr + "'.");
        }
        this.idReference = m.group(2);
        this.idResource = m.group(3);
        this.fragment = this.uri.getFragment();
    }

    public void addFragment(String fragment) {
        if (this.uri.getFragment() == null) {
            try {
                this.uri = new URI(this.uri.toString() + "#" + fragment);
            }
            catch (URISyntaxException urise) {
                throw new WebLabRISyntaxException(urise);
            }
        }
        try {
            this.uri = new URI(this.uri.toString() + "-" + fragment);
        }
        catch (URISyntaxException urise) {
            throw new WebLabRISyntaxException(urise);
        }
    }

    public String getIdReference() {
        return this.idReference;
    }

    public String getIdResource() {
        return this.idResource;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String toString() {
        return this.uri.toString();
    }
}

