/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.repository.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.repository.file.RepoRI;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.jaxb.WebLabMarshaler;
import org.weblab_project.core.model.Annotation;
import org.weblab_project.core.model.ComposedUnit;
import org.weblab_project.core.model.MediaUnit;
import org.weblab_project.core.model.Resource;
import org.weblab_project.core.model.Segment;

public class FileRepository {
    protected File pathToFS;
    protected static final String DEFAULT_REPO_ID = "fileRepository";
    protected String repositoryID = "fileRepository";
    protected static final String DEFAULT_FILE_PREFIX = "res_";
    protected String filePrefix = "res_";
    protected static final int DEFAULT_FILE_PER_FOLDER = 100;
    protected int filePerFolder = 100;
    protected File currentFolder;
    protected final WebLabMarshaler wlm = new WebLabMarshaler();

    public Resource getResource(String uri) throws WebLabCheckedException {
        Resource res;
        RepoRI wlRi = new RepoRI(uri);
        try {
            res = this.loadFile(wlRi.getIdResource() + ".xml");
        }
        catch (FileNotFoundException fnfe) {
            throw new WebLabCheckedException("Uri '" + uri + "' is not present in the repository.", (Throwable)fnfe);
        }
        Resource result = this.getResourceInside(res, uri);
        if (result == null) {
            throw new WebLabCheckedException("Uri '" + uri + "' is not present in the repository.");
        }
        return result;
    }

    public String saveResource(Resource resource) throws WebLabCheckedException {
        Resource res = this.changeUri(resource);
        try {
            this.writeFile(new RepoRI(res.getUri()), res);
        }
        catch (FileNotFoundException fnfe) {
            throw new WebLabCheckedException("Unable to write resource: " + resource.getUri() + " into resource: " + res.getUri() + ".", (Throwable)fnfe);
        }
        return res.getUri();
    }

    protected Resource getResourceInside(Resource res, String uri) throws WebLabCheckedException {
        return this.getResourceInside(res, uri, null);
    }

    protected Resource getResourceInside(Resource res, String uri, Resource newRes) throws WebLabCheckedException {
        return this.getResourceInside(res, uri, newRes, null);
    }

    protected Resource getResourceInside(Resource res, String uri, Resource newRes, Resource father) throws WebLabCheckedException {
        if (res.getUri().equals(uri)) {
            if (newRes != null) {
                this.replaceResource(father, res, newRes);
            }
            return res;
        }
        ArrayList listAnnotCopy = new ArrayList(res.getAnnotation());
        Resource ret = null;
        Iterator itAnnot = listAnnotCopy.iterator();
        while (ret == null && itAnnot.hasNext()) {
            ret = this.getResourceInside((Resource)itAnnot.next(), uri, newRes, res);
        }
        if (ret != null) {
            return ret;
        }
        if (res instanceof ComposedUnit) {
            ComposedUnit comp = (ComposedUnit)res;
            ArrayList listMediaUnitCopy = new ArrayList(comp.getMediaUnit());
            Iterator itMed = listMediaUnitCopy.iterator();
            while (ret == null && itMed.hasNext()) {
                ret = this.getResourceInside((Resource)itMed.next(), uri, newRes, res);
            }
            if (ret != null) {
                return ret;
            }
        }
        if (res instanceof MediaUnit) {
            MediaUnit med = (MediaUnit)res;
            ArrayList listSegmentCopy = new ArrayList(med.getSegment());
            Iterator itSeg = listSegmentCopy.iterator();
            while (ret == null && itSeg.hasNext()) {
                ret = this.getResourceInside((Resource)itSeg.next(), uri, newRes, res);
            }
            if (ret != null) {
                return ret;
            }
        }
        return ret;
    }

    protected void replaceResource(Resource father, Resource oldRes, Resource newRes) throws WebLabCheckedException {
        if (newRes instanceof Segment && father instanceof MediaUnit) {
            Segment newSeg = (Segment)newRes;
            MediaUnit fatherMU = (MediaUnit)father;
            int index = fatherMU.getSegment().indexOf(oldRes);
            fatherMU.getSegment().remove(oldRes);
            fatherMU.getSegment().add(index, newSeg);
        } else if (newRes instanceof MediaUnit && father instanceof ComposedUnit) {
            MediaUnit newMed = (MediaUnit)newRes;
            ComposedUnit fatherCU = (ComposedUnit)father;
            int index = fatherCU.getMediaUnit().indexOf(oldRes);
            fatherCU.getMediaUnit().remove(oldRes);
            fatherCU.getMediaUnit().add(index, newMed);
        } else if (newRes instanceof Annotation) {
            Annotation newAnnot = (Annotation)newRes;
            int index = father.getAnnotation().indexOf(oldRes);
            father.getAnnotation().remove(oldRes);
            father.getAnnotation().add(index, newAnnot);
        } else {
            throw new WebLabCheckedException("In the document repository, the uri '" + newRes.getUri() + "' is a '" + oldRes.getClass() + "' and is not replacable by a '" + newRes.getClass() + "'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Resource loadFile(String fileName) throws WebLabCheckedException, FileNotFoundException {
        Resource res;
        FileInputStream fis = new FileInputStream(this.pathToFS.getAbsoluteFile() + "/" + fileName);
        try {
            res = this.wlm.unmarshal((InputStream)fis, Resource.class);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ioe) {
                LogFactory.getLog(this.getClass()).warn((Object)"Unable to close stream.");
            }
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPathToFS(File pathToFS) throws WebLabCheckedException {
        if (pathToFS == null) {
            throw new WebLabCheckedException("Folder is null.");
        }
        if (pathToFS.exists()) {
            if (!pathToFS.isDirectory()) throw new WebLabCheckedException("'" + pathToFS.getAbsolutePath() + "' is not a folder.");
            this.pathToFS = pathToFS;
        } else {
            try {
                if (!pathToFS.mkdirs()) {
                    throw new WebLabCheckedException("Unable to create folder : '" + pathToFS.getAbsolutePath() + "'");
                }
                this.pathToFS = pathToFS;
            }
            catch (SecurityException se) {
                throw new WebLabCheckedException("Unable to create folder: '" + pathToFS.getAbsolutePath() + "'.", (Throwable)se);
            }
        }
        this.currentFolder = this.createNewFolder();
    }

    protected Resource changeUri(Resource res) throws WebLabCheckedException {
        Resource ret;
        RepoRI wlRi;
        try {
            wlRi = new RepoRI(res.getUri());
        }
        catch (WebLabCheckedException wlce) {
            LogFactory.getLog(this.getClass()).warn((Object)("Unable to load a valid WLRI: '" + res.getUri() + "'."), (Throwable)wlce);
            wlRi = null;
        }
        if (wlRi != null && wlRi.getIdReference().equals(this.repositoryID)) {
            File file = new File(this.pathToFS, wlRi.getIdResource() + ".xml");
            if (!file.exists()) {
                wlRi = new RepoRI("weblab://" + this.repositoryID + "/" + this.getUniqueResource());
                ret = this.replaceUri(res, wlRi.toString());
            } else {
                ret = res;
            }
        } else {
            wlRi = new RepoRI("weblab://" + this.repositoryID + "/" + this.getUniqueResource());
            ret = this.replaceUri(res, wlRi.toString());
        }
        return ret;
    }

    protected String getUniqueResource() {
        int max = -1;
        if (this.currentFolder != null) {
            if (this.currentFolder.listFiles().length >= this.filePerFolder) {
                this.currentFolder = this.createNewFolder();
            }
        } else {
            this.currentFolder = this.createNewFolder();
        }
        for (File file : this.currentFolder.listFiles()) {
            int val;
            String fileName = file.getName().substring(0, file.getName().length() - 4);
            if (!fileName.startsWith(this.filePrefix) || (val = Integer.parseInt(fileName.substring(this.filePrefix.length()))) <= max) continue;
            max = val;
        }
        return this.currentFolder.getName() + "/" + this.filePrefix + (max + 1);
    }

    protected File createNewFolder() {
        File folder = new File(this.pathToFS.getAbsolutePath() + "/" + System.currentTimeMillis());
        if (!folder.exists() && !folder.mkdirs()) {
            LogFactory.getLog(this.getClass()).warn((Object)("Unable to create folder '" + folder.getAbsolutePath() + "' RuntimeException may appear later."));
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource replaceUri(Resource res, String uri) throws WebLabCheckedException {
        Resource ret;
        ByteArrayInputStream bais;
        String newXmlStr;
        URI wlRi;
        try {
            wlRi = new URI(res.getUri());
        }
        catch (URISyntaxException urise) {
            throw new WebLabCheckedException("Unvalid URI: '" + res.getUri() + "'.", (Throwable)urise);
        }
        String oldUri = wlRi.toString();
        if (wlRi.getFragment() != null) {
            oldUri = res.getUri().substring(0, res.getUri().indexOf(35));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.wlm.marshalResource(res, (OutputStream)baos);
            newXmlStr = baos.toString("UTF-8").replaceAll(oldUri, uri);
        }
        catch (UnsupportedEncodingException uee) {
            throw new WebLabCheckedException("Unable to handle encoding.", (Throwable)uee);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException ioe) {
                LogFactory.getLog(this.getClass()).warn((Object)"Unable to close stream.", (Throwable)ioe);
            }
        }
        try {
            bais = new ByteArrayInputStream(newXmlStr.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new WebLabCheckedException("Unable to handle encoding.", (Throwable)uee);
        }
        try {
            ret = this.wlm.unmarshal((InputStream)bais, Resource.class);
        }
        finally {
            try {
                bais.close();
            }
            catch (IOException ioe) {
                LogFactory.getLog(this.getClass()).warn((Object)"Unable to close stream.", (Throwable)ioe);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeFile(RepoRI wlRi, Resource res) throws FileNotFoundException, WebLabCheckedException {
        Resource newRes;
        File saveFile = new File(this.pathToFS.getAbsolutePath() + "/" + wlRi.getIdResource() + ".xml");
        if (saveFile.exists() && wlRi.getFragment() != null) {
            newRes = this.loadFile(wlRi.getIdResource() + ".xml");
            this.getResourceInside(newRes, res.getUri(), res);
        } else {
            newRes = res;
        }
        FileOutputStream os = new FileOutputStream(saveFile);
        try {
            this.wlm.marshalResource(newRes, (OutputStream)os);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException ioe) {
                LogFactory.getLog(this.getClass()).warn((Object)"Unable to close stream.", (Throwable)ioe);
            }
        }
    }

    public void setPathToFS(String pathToFS) throws WebLabCheckedException {
        if (pathToFS == null) {
            throw new WebLabCheckedException("Folder is null.");
        }
        this.setPathToFS(new File(pathToFS));
    }

    public String getRepositoryID() {
        return this.repositoryID;
    }

    public void setRepositoryID(String repositoryID) {
        this.repositoryID = repositoryID;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public File getPathToFS() {
        return this.pathToFS;
    }

    public static FileRepository newInstance() throws WebLabCheckedException {
        URL fileUrl;
        block4: {
            String defaultFileName = FileRepository.class.getSimpleName().toLowerCase(Locale.getDefault()) + ".properties";
            try {
                Enumeration<URL> urls = FileRepository.class.getClassLoader().getResources(defaultFileName);
                if (urls.hasMoreElements()) {
                    fileUrl = urls.nextElement();
                    if (urls.hasMoreElements()) {
                        LogFactory.getLog(FileRepository.class).warn((Object)("Founded more than one '" + defaultFileName + "' in the classpath.\nLoaded : '" + fileUrl + "'."));
                    }
                    break block4;
                }
                throw new WebLabCheckedException("No file '" + defaultFileName + "' founded in the classpath.");
            }
            catch (IOException ioe) {
                throw new WebLabCheckedException("No file '" + defaultFileName + "' founded in the classpath.", (Throwable)ioe);
            }
        }
        return FileRepository.newInstance(fileUrl);
    }

    public static FileRepository newInstance(URL fileUrl) throws WebLabCheckedException {
        InputStream fis;
        Properties prop = new Properties();
        FileRepository rep = new FileRepository();
        String propName = FileRepository.class.getSimpleName().toLowerCase(Locale.getDefault());
        try {
            fis = fileUrl.openStream();
        }
        catch (IOException fnfe) {
            throw new WebLabCheckedException("Unable to load properties from file: " + fileUrl, (Throwable)fnfe);
        }
        try {
            prop.load(fis);
        }
        catch (IOException ioe) {
            throw new WebLabCheckedException("Unable to load properties from file: " + fileUrl, (Throwable)ioe);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ioe) {
                LogFactory.getLog(FileRepository.class).warn((Object)"Unable to close stream.", (Throwable)ioe);
            }
        }
        String path = prop.getProperty(propName);
        if (path == null) {
            throw new WebLabCheckedException("Property '" + propName + "' not founded in '" + fileUrl + "'.");
        }
        rep.setPathToFS(path);
        try {
            rep.setFilePerFolder(Integer.parseInt(prop.getProperty("filePerFolder")));
        }
        catch (Exception e) {
            LogFactory.getLog(FileRepository.class).warn((Object)"Unable to load the property 'filePerFolder'.", (Throwable)e);
        }
        return rep;
    }

    public int getFilePerFolder() {
        return this.filePerFolder;
    }

    public void setFilePerFolder(int filePerFolder) {
        this.filePerFolder = filePerFolder;
    }

    public File getCurrentFolder() {
        return this.currentFolder;
    }

    public void setCurrentFolder(File currentFolder) {
        this.currentFolder = currentFolder;
        if (!currentFolder.exists() && !currentFolder.mkdirs()) {
            LogFactory.getLog(this.getClass()).warn((Object)"Unable to create folder. RuntimeException may appears.");
        }
    }
}

