/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.repository.file.impl;

import javax.jws.WebService;
import org.ow2.weblab.repository.file.FileRepository;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.model.Resource;
import org.weblab_project.services.exception.WebLabException;
import org.weblab_project.services.resourcecontainer.GetResourceException;
import org.weblab_project.services.resourcecontainer.ResourceContainer;
import org.weblab_project.services.resourcecontainer.SaveResourceException;
import org.weblab_project.services.resourcecontainer.types.GetResourceArgs;
import org.weblab_project.services.resourcecontainer.types.GetResourceReturn;
import org.weblab_project.services.resourcecontainer.types.SaveResourceArgs;
import org.weblab_project.services.resourcecontainer.types.SaveResourceReturn;

@WebService(endpointInterface="org.weblab_project.services.resourcecontainer.ResourceContainer")
public class FileRepositoryService
implements ResourceContainer {
    protected FileRepository repo;

    public GetResourceReturn getResource(GetResourceArgs args) throws GetResourceException {
        if (this.repo == null) {
            try {
                this.repo = FileRepository.newInstance();
            }
            catch (WebLabCheckedException wlce) {
                WebLabException ex = new WebLabException();
                ex.setErrorId("E2");
                ex.setErrorMessage("Insufficient resources.");
                throw new GetResourceException("Unable to load repo.", ex, (Throwable)wlce);
            }
        }
        if (args == null) {
            WebLabException ex = new WebLabException();
            ex.setErrorId("E1");
            ex.setErrorMessage("Invalid parameter.");
            throw new GetResourceException("GetResourceArgs was null.", ex);
        }
        String resId = args.getResourceId();
        if (resId == null || resId.trim().equals("")) {
            WebLabException ex = new WebLabException();
            ex.setErrorId("E1");
            ex.setErrorMessage("Invalid parameter.");
            throw new GetResourceException("ResourceId in GetResourceArgs was null or empty.", ex);
        }
        GetResourceReturn ret = new GetResourceReturn();
        try {
            ret.setResource(this.repo.getResource(resId));
        }
        catch (WebLabCheckedException wlce) {
            WebLabException ex = new WebLabException();
            ex.setErrorId("E1");
            ex.setErrorMessage("Invalid parameter.");
            throw new GetResourceException(wlce.getMessage(), ex, (Throwable)wlce);
        }
        return ret;
    }

    public SaveResourceReturn saveResource(SaveResourceArgs args) throws SaveResourceException {
        if (this.repo == null) {
            try {
                this.repo = FileRepository.newInstance();
            }
            catch (WebLabCheckedException wlce) {
                WebLabException ex = new WebLabException();
                ex.setErrorId("E2");
                ex.setErrorMessage("Insufficient resources.");
                throw new SaveResourceException("Unable to load repo.", ex, (Throwable)wlce);
            }
        }
        if (args == null) {
            WebLabException ex = new WebLabException();
            ex.setErrorId("E1");
            ex.setErrorMessage("Invalid parameter.");
            throw new SaveResourceException("SaveResourceArgs was null.", ex);
        }
        Resource res = args.getResource();
        if (res == null || res.getUri() == null) {
            WebLabException ex = new WebLabException();
            ex.setErrorId("E1");
            ex.setErrorMessage("Invalid parameter.");
            throw new SaveResourceException("Resource SaveResourceException was null without URI.", ex);
        }
        SaveResourceReturn ret = new SaveResourceReturn();
        try {
            ret.setResourceId(this.repo.saveResource(res));
        }
        catch (WebLabCheckedException wlce) {
            WebLabException ex = new WebLabException();
            ex.setErrorId("E1");
            ex.setErrorMessage("Invalid parameter.");
            throw new SaveResourceException(wlce.getMessage(), ex, (Throwable)wlce);
        }
        return ret;
    }
}

