/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.repository.file.impl;

import javax.jws.WebService;

import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ResourceContainer;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.resourcecontainer.LoadResourceArgs;
import org.ow2.weblab.core.services.resourcecontainer.LoadResourceReturn;
import org.ow2.weblab.core.services.resourcecontainer.SaveResourceArgs;
import org.ow2.weblab.core.services.resourcecontainer.SaveResourceReturn;
import org.ow2.weblab.repository.file.FileRepository;

@WebService(endpointInterface = "org.ow2.weblab.core.services.ResourceContainer")
public class FileRepositoryService implements ResourceContainer {

	protected FileRepository repo;

	public LoadResourceReturn loadResource(final LoadResourceArgs args)
			throws AccessDeniedException, ContentNotAvailableException,
			InsufficientResourcesException, InvalidParameterException,
			ServiceNotConfiguredException, UnexpectedException,
			UnsupportedRequestException {
		if (this.repo == null) {
			try {
				this.repo = FileRepository.newInstance();
			} catch (final WebLabCheckedException wlce) {

				throw new AccessDeniedException("Unable to load repo.", wlce
						.getMessage());
			}
		}
		if (args == null) {
			throw new InvalidParameterException("Unable to load resource.",
					"LoadResourceArgs was null.");
		}
		final String resId = args.getResourceId();
		if (resId == null || resId.trim().equals("")) {
			throw new InvalidParameterException("Unable to load resource.",
					"ResourceId in LoadResourceArgs was null or empty.");
		}

		LoadResourceReturn ret = new LoadResourceReturn();
		try {
			ret.setResource(this.repo.getResource(resId));
		} catch (final WebLabCheckedException wlce) {
			throw new UnexpectedException(wlce.getMessage(), wlce.getMessage());
		}

		return ret;
	}

	public SaveResourceReturn saveResource(final SaveResourceArgs args)
			throws AccessDeniedException, ContentNotAvailableException,
			InsufficientResourcesException, InvalidParameterException,
			ServiceNotConfiguredException, UnexpectedException,
			UnsupportedRequestException {
		if (this.repo == null) {
			try {
				this.repo = FileRepository.newInstance();
			} catch (final WebLabCheckedException wlce) {
				throw new AccessDeniedException("Unable to load repo.", wlce
						.getMessage());
			}
		}

		if (args == null) {
			throw new InvalidParameterException("Unable to load resource.",
					"SaveResourceArgs was null.");
		}

		Resource res = args.getResource();
		if (res == null || res.getUri() == null) {

			throw new InvalidParameterException("Unable to save resource.",
					"Resource SaveResourceException was null without URI.");
		}

		SaveResourceReturn ret = new SaveResourceReturn();
		try {
			ret.setResourceId(this.repo.saveResource(res));
		} catch (final WebLabCheckedException wlce) {
			throw new InvalidParameterException("Unable to save resource.",
					wlce.getMessage());

		}
		return ret;
	}

}
