/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.crawler.folder.impl;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.content.binary.BinaryFolderContentManager;
import org.ow2.weblab.crawler.FolderCrawler;
import org.ow2.weblab.crawler.filter.ExtensionFilter;
import org.ow2.weblab.services.foldercrawling.FolderCrawling;
import org.ow2.weblab.services.foldercrawling.StartCrawlException;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.exception.WebLabUncheckedException;
import org.weblab_project.core.factory.ResourceFactory;
import org.weblab_project.core.helper.PoKHelper;
import org.weblab_project.core.helper.RDFHelperFactory;
import org.weblab_project.core.model.PieceOfKnowledge;
import org.weblab_project.core.model.ResourceCollection;
import org.weblab_project.core.properties.PropertiesLoader;
import org.weblab_project.services.configurable.Configurable;
import org.weblab_project.services.configurable.ConfigureException;
import org.weblab_project.services.configurable.ResetConfigurationException;
import org.weblab_project.services.configurable.types.ConfigureArgs;
import org.weblab_project.services.configurable.types.ConfigureReturn;
import org.weblab_project.services.configurable.types.ResetConfigurationArgs;
import org.weblab_project.services.configurable.types.ResetConfigurationReturn;
import org.weblab_project.services.exception.WebLabException;
import org.weblab_project.services.foldercrawling.types.StartCrawlArgs;
import org.weblab_project.services.foldercrawling.types.StartCrawlReturn;
import org.weblab_project.services.sourcereader.GetResourceException;
import org.weblab_project.services.sourcereader.SourceReader;
import org.weblab_project.services.sourcereader.types.GetResourceArgs;
import org.weblab_project.services.sourcereader.types.GetResourceReturn;

/*
 * Exception performing whole class analysis ignored.
 */
@WebService
@SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.BARE)
public class FolderCrawlerService
implements FolderCrawling,
Configurable,
SourceReader {
    private static final String FOLDER_PROPERTY = "http://weblab-project.org/core/model/property/processing/crawler/folder";
    protected BinaryFolderContentManager contentManager = null;
    public static final String DEFAULT_FOLDER = "toBeCrawled";
    public static final String FOLDERS_FILE = "FolderCrawlerService.config";
    private static final String FOLDERS = "folders";
    private static final String EXTENSIONS = "extensions";
    private static final String REJECT = "reject";
    private static final String RECURSIVE = "recursive";
    protected Map<String, String> props = null;
    protected Map<String, List<String>> usContextAndFolderToCrawl = new HashMap();
    protected Map<String, List<FolderCrawler>> usContextAndFolderCrawler = new HashMap();
    protected List<FolderCrawler> defaultFC = new ArrayList();

    @WebMethod(action="startCrawl")
    @WebResult(name="startCrawlReturn", targetNamespace="http://weblab-project.org/services/foldercrawling/types", partName="return")
    public StartCrawlReturn startCrawl(@WebParam(name="startCrawlArgs", targetNamespace="http://weblab-project.org/services/foldercrawling/types", partName="args") StartCrawlArgs args) throws StartCrawlException {
        LogFactory.getLog(this.getClass()).info((Object)"StartCrawl method called.");
        if (this.contentManager == null) {
            try {
                this.contentManager = BinaryFolderContentManager.getInstance();
            }
            catch (WebLabUncheckedException wlue) {
                WebLabException exp = new WebLabException();
                exp.setErrorId("E0");
                exp.setErrorMessage("Unexpected error");
                throw new StartCrawlException("Unable to get the content manager.", exp, (Throwable)wlue);
            }
        }
        String uc = null;
        if (args != null && args.getUsageContext() != null) {
            uc = args.getUsageContext().getUri();
        }
        if (uc == null) {
            this.defaultFC.clear();
            LogFactory.getLog(this.getClass()).info((Object)"UsageContext was null. Folder will be loaded from config file.");
            List filesToCrawl = this.getFoldersFromConfig();
            boolean recursive = this.getRecursiveFromConfig();
            FileFilter ff = this.getFileFilterFromConfig();
            for (String toCrawl : filesToCrawl) {
                FolderCrawler fc;
                LogFactory.getLog(this.getClass()).info((Object)("Create folder crawler on: " + toCrawl));
                try {
                    fc = new FolderCrawler(this.contentManager, new File(toCrawl), ff, recursive);
                }
                catch (WebLabCheckedException wlce) {
                    LogFactory.getLog(this.getClass()).warn((Object)("Unable to crawl folder: " + toCrawl), (Throwable)wlce);
                    continue;
                }
                this.defaultFC.add(fc);
            }
            for (FolderCrawler fc : this.defaultFC) {
                fc.startCrawl();
            }
        } else if (!this.usContextAndFolderToCrawl.containsKey(uc)) {
            LogFactory.getLog(this.getClass()).info((Object)("No configure done with this usageContext( " + uc + "). Folder will be loaded from config file."));
            List filesToCrawl = this.getFoldersFromConfig();
            boolean recursive = this.getRecursiveFromConfig();
            FileFilter ff = this.getFileFilterFromConfig();
            ArrayList<FolderCrawler> fcList = (ArrayList<FolderCrawler>)this.usContextAndFolderCrawler.get(uc);
            if (fcList == null) {
                fcList = new ArrayList<FolderCrawler>();
            }
            for (String toCrawl : filesToCrawl) {
                FolderCrawler fc;
                try {
                    fc = new FolderCrawler(this.contentManager, new File(toCrawl), ff, recursive);
                }
                catch (WebLabCheckedException wlce) {
                    LogFactory.getLog(this.getClass()).warn((Object)("Unable to crawl folder: " + toCrawl), (Throwable)wlce);
                    continue;
                }
                fc.startCrawl();
                fcList.add(fc);
            }
            this.usContextAndFolderCrawler.put(uc, fcList);
        } else {
            List filesToCrawl = (List)this.usContextAndFolderToCrawl.get(uc);
            if (filesToCrawl == null || filesToCrawl.isEmpty()) {
                LogFactory.getLog(this.getClass()).warn((Object)("No folder to crawl associated with the usageContext (" + uc + ")"));
            } else {
                ArrayList<FolderCrawler> fcList = (ArrayList<FolderCrawler>)this.usContextAndFolderCrawler.get(uc);
                if (fcList == null) {
                    fcList = new ArrayList<FolderCrawler>();
                }
                boolean recursive = this.getRecursiveFromConfig();
                FileFilter ff = this.getFileFilterFromConfig();
                for (String toCrawl : filesToCrawl) {
                    FolderCrawler fc;
                    try {
                        fc = new FolderCrawler(this.contentManager, new File(toCrawl), ff, recursive);
                    }
                    catch (WebLabCheckedException wlce) {
                        LogFactory.getLog(this.getClass()).warn((Object)("Unable to crawl folder: " + toCrawl), (Throwable)wlce);
                        continue;
                    }
                    fc.startCrawl();
                    fcList.add(fc);
                }
                this.usContextAndFolderCrawler.put(uc, fcList);
            }
        }
        return new StartCrawlReturn();
    }

    private boolean getRecursiveFromConfig() {
        boolean rec;
        if (this.props == null) {
            this.loadProps();
        }
        if (this.props.containsKey("recursive")) {
            rec = Boolean.parseBoolean((String)this.props.get("recursive"));
        } else {
            LogFactory.getLog(this.getClass()).warn((Object)"Unable to load recursive from config file. false will be used.");
            rec = false;
        }
        return rec;
    }

    private FileFilter getFileFilterFromConfig() {
        boolean rej;
        if (this.props == null) {
            this.loadProps();
        }
        if (this.props.containsKey("reject")) {
            rej = Boolean.parseBoolean((String)this.props.get("reject"));
        } else {
            LogFactory.getLog(this.getClass()).warn((Object)"Unable to load reject from config file. false will be used.");
            rej = false;
        }
        ArrayList<String> ext = new ArrayList<String>();
        if (this.props.containsKey("extensions")) {
            String[] splitted;
            for (String string : splitted = ((String)this.props.get("extensions")).split(";")) {
                if ((string = string.trim()).equals("")) continue;
                ext.add(string);
            }
            if (ext.isEmpty()) {
                LogFactory.getLog(this.getClass()).info((Object)"Extensions is empty; from FolderCrawlerService.config");
            }
        } else {
            LogFactory.getLog(this.getClass()).warn((Object)"Unable to get extensions from FolderCrawlerService.config");
        }
        return new ExtensionFilter(ext, rej);
    }

    @WebMethod(action="getResource")
    @WebResult(name="getResourceReturn", targetNamespace="http://weblab-project.org/services/sourcereader/types", partName="return")
    public GetResourceReturn getResource(@WebParam(name="getResourceArgs", targetNamespace="http://weblab-project.org/services/sourcereader/types", partName="args") GetResourceArgs args) throws GetResourceException {
        List fcList;
        int limit = -1;
        int offset = 0;
        if (args != null) {
            limit = args.getLimit();
            offset = args.getOffset();
        }
        LogFactory.getLog(this.getClass()).info((Object)("GetCrawledDocuments method called. offset: " + offset + "; limit: " + limit));
        GetResourceReturn ret = new GetResourceReturn();
        if (this.contentManager == null) {
            try {
                this.contentManager = BinaryFolderContentManager.getInstance();
            }
            catch (WebLabUncheckedException wlue) {
                WebLabException exp = new WebLabException();
                exp.setErrorId("E0");
                exp.setErrorMessage("Unexpected error");
                throw new GetResourceException("Unable to get the content manager", exp, (Throwable)wlue);
            }
        }
        String uc = null;
        if (args != null && args.getUsageContext() != null) {
            uc = args.getUsageContext().getUri();
        }
        if (uc == null) {
            fcList = this.defaultFC;
        } else if (this.usContextAndFolderCrawler.containsKey(uc)) {
            fcList = (List)this.usContextAndFolderCrawler.get(uc);
        } else {
            LogFactory.getLog(this.getClass()).warn((Object)("StartCrawl must have been called with this usageContext (" + uc + ") before."));
            WebLabException exp = new WebLabException();
            exp.setErrorId("E5");
            exp.setErrorMessage("Unsupported request");
            throw new GetResourceException("StartCrawl must have been called before.", exp);
        }
        ResourceCollection resCol = FolderCrawlerService.getRCFromList((List)fcList, (int)offset, (int)limit);
        if (resCol.getResource().size() == 0) {
            LogFactory.getLog(this.getClass()).info((Object)"No resources in the resource collection returned by the crawler...");
            LogFactory.getLog(this.getClass()).info((Object)("FoldersCrawler were: " + fcList));
        }
        ret.setResources(resCol);
        return ret;
    }

    private static ResourceCollection getRCFromList(List<FolderCrawler> fcList, int offset, int limit) {
        if (fcList == null || fcList.isEmpty()) {
            LogFactory.getLog(FolderCrawlerService.class).warn((Object)"No folder to crawl");
            return (ResourceCollection)ResourceFactory.createResource((String)"folderCrawlerService", (String)("emptyCollection" + System.currentTimeMillis()), ResourceCollection.class);
        }
        int usedOffset = offset < 0 ? 0 : offset;
        int usedLimit = limit <= 0 ? Integer.MAX_VALUE : limit;
        int cpt = 0;
        ResourceCollection resCol = (ResourceCollection)ResourceFactory.createResource((String)"folderCrawlerService", (String)("tempCollection-" + System.currentTimeMillis()), ResourceCollection.class);
        for (FolderCrawler fc : fcList) {
            if (cpt + fc.getNbFiles() < usedOffset) {
                cpt += fc.getNbFiles();
                continue;
            }
            if (cpt >= usedOffset + usedLimit) break;
            resCol.getResource().addAll(fc.getCrawledDocuments(usedOffset - cpt, usedLimit).getResource());
            cpt += fc.getNbFiles();
        }
        return resCol;
    }

    protected void loadProps() {
        HashSet<String> toLoad = new HashSet<String>();
        toLoad.add("extensions");
        toLoad.add("folders");
        toLoad.add("recursive");
        toLoad.add("reject");
        this.props = PropertiesLoader.loadProperties((String)"FolderCrawlerService.config", toLoad);
    }

    private List<String> getFoldersFromConfig() {
        if (this.props == null) {
            this.loadProps();
        }
        ArrayList<String> folders = new ArrayList<String>();
        if (this.props.containsKey("folders")) {
            String[] splitted;
            for (String string : splitted = ((String)this.props.get("folders")).split(";")) {
                if ((string = string.trim()).equals("")) continue;
                folders.add(string);
            }
            if (folders.isEmpty()) {
                LogFactory.getLog(this.getClass()).warn((Object)("Unable to get folders from FolderCrawlerService.config. ( " + (String)this.props.get("folders") + ") Default folder will be used."));
                folders.add("toBeCrawled");
            }
        } else {
            LogFactory.getLog(this.getClass()).warn((Object)"Unable to load folders from FolderCrawlerService.config. Default folder will be used.");
            folders.add("toBeCrawled");
        }
        return folders;
    }

    @WebMethod(action="configure")
    @WebResult(name="configureReturn", targetNamespace="http://weblab-project.org/services/configurable/types", partName="return")
    public ConfigureReturn configure(@WebParam(name="configureArgs", targetNamespace="http://weblab-project.org/services/configurable/types", partName="args") ConfigureArgs args) throws ConfigureException {
        LogFactory.getLog(this.getClass()).info((Object)"Configure method called.");
        if (args == null || args.getUsageContext() == null || args.getConfiguration() == null || args.getUsageContext().getUri() == null) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E1");
            wle.setErrorMessage("Invalid parameter");
            throw new ConfigureException("ConfigureArgs was invalid (either it self, usageContext, it's uri or configuration was null", wle);
        }
        PoKHelper helper = RDFHelperFactory.getPoKHelper((PieceOfKnowledge)args.getConfiguration());
        ArrayList list = new ArrayList();
        list.addAll(helper.getLitsOnPredSubj(args.getUsageContext().getUri(), "http://weblab-project.org/core/model/property/processing/crawler/folder"));
        list.addAll(helper.getRessOnPredSubj(args.getUsageContext().getUri(), "http://weblab-project.org/core/model/property/processing/crawler/folder"));
        if (list.isEmpty()) {
            WebLabException exp = new WebLabException();
            exp.setErrorId("E1");
            exp.setErrorMessage("Unable to read configuration annotation.");
            throw new ConfigureException("No property 'http://weblab-project.org/core/model/property/processing/crawler/folder' in the configuration annotation.", exp);
        }
        this.usContextAndFolderToCrawl.put(args.getUsageContext().getUri(), list);
        return new ConfigureReturn();
    }

    @WebMethod(action="resetConfiguration")
    @WebResult(name="resetConfigurationReturn", targetNamespace="http://weblab-project.org/services/configurable/types", partName="return")
    public ResetConfigurationReturn resetConfiguration(@WebParam(name="resetConfigurationArgs", targetNamespace="http://weblab-project.org/services/configurable/types", partName="args") ResetConfigurationArgs args) throws ResetConfigurationException {
        LogFactory.getLog(this.getClass()).info((Object)"ResetConfiguration method called.");
        this.defaultFC.clear();
        this.usContextAndFolderCrawler.clear();
        this.usContextAndFolderToCrawl.clear();
        return new ResetConfigurationReturn();
    }
}

