/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.sourcereader.filter;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class FolderAndExtensionFilter
implements FileFilter {
    protected List<String> extensions;
    protected boolean extensionRejectMode = false;
    protected List<String> folders;
    protected boolean folderRejectMode = false;
    protected List<String> folderExt;
    protected boolean folderExtRejectMode = false;

    public FolderAndExtensionFilter(List<String> folders, boolean folderRejectMode, List<String> extensions, boolean extensionRejectMode, List<String> folderExt, boolean folderExtRejectMode) {
        this.extensionRejectMode = extensionRejectMode;
        this.extensions = new ArrayList<String>();
        if (extensions != null) {
            this.extensions.addAll(extensions);
        }
        this.folderRejectMode = folderRejectMode;
        this.folders = new ArrayList<String>();
        if (folders != null) {
            this.folders.addAll(folders);
        }
        this.folderExtRejectMode = folderExtRejectMode;
        this.folderExt = new ArrayList<String>();
        if (folderExt != null) {
            this.folderExt.addAll(folderExt);
        }
    }

    @Override
    public boolean accept(File file) {
        return file.isFile() && this.extensions.contains(FolderAndExtensionFilter.getFileExtension(file)) != this.extensionRejectMode || file.isDirectory() && this.folders.contains(file.getName()) != this.folderRejectMode && this.folderExt.contains(FolderAndExtensionFilter.getFileExtension(file)) != this.folderExtRejectMode;
    }

    public static String getFileExtension(File file) {
        String[] splited = file.getName().split("\\.");
        if (splited.length > 0) {
            return splited[splited.length - 1].toLowerCase(Locale.getDefault());
        }
        return "";
    }
}

