/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.sourcereader;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.services.sourcereader.filter.FolderAndExtensionFilter;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.factory.AnnotationFactory;
import org.weblab_project.core.factory.ResourceFactory;
import org.weblab_project.core.helper.PoKHelper;
import org.weblab_project.core.helper.RDFHelperFactory;
import org.weblab_project.core.jaxb.WebLabMarshaler;
import org.weblab_project.core.model.Annotation;
import org.weblab_project.core.model.Document;
import org.weblab_project.core.model.PieceOfKnowledge;
import org.weblab_project.core.model.Resource;
import org.weblab_project.core.model.ResourceCollection;
import org.weblab_project.core.properties.PropertiesLoader;
import org.weblab_project.services.configurable.Configurable;
import org.weblab_project.services.configurable.ConfigureException;
import org.weblab_project.services.configurable.ResetConfigurationException;
import org.weblab_project.services.configurable.types.ConfigureArgs;
import org.weblab_project.services.configurable.types.ConfigureReturn;
import org.weblab_project.services.configurable.types.ResetConfigurationArgs;
import org.weblab_project.services.configurable.types.ResetConfigurationReturn;
import org.weblab_project.services.exception.WebLabException;
import org.weblab_project.services.sourcereader.GetResourceException;
import org.weblab_project.services.sourcereader.SourceReader;
import org.weblab_project.services.sourcereader.types.GetResourceArgs;
import org.weblab_project.services.sourcereader.types.GetResourceReturn;

@WebService
@SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.BARE)
public class FolderSourceReaderService
implements SourceReader,
Configurable {
    private static final Log logger = LogFactory.getLog(FolderSourceReaderService.class);
    public static final String SERVICE_URI = "http://weblab-project.org/services/FolderSourceReaderConfiguration";
    public static final String WEBLAB_GATHERING_NAMESPACE = "http://weblab-project.org/core/model/property/gathering/";
    public static final String CRAWL_URL_PROPERTY = "http://weblab-project.org/core/model/property/gathering/crawlUrl";
    private static final String SERVICE_CONFIG_FILE = "FolderSourceReaderService.config";
    public static final String DEFAULT_FOLDER_URL_PROPERTY_NAME = "defaultFolderUrl";
    public static final String RECURSIVE_PROPERTY_NAME = "recursive";
    public static final String DELETE_FILE_AFTER_PROPERTY_NAME = "deleteFileAfter";
    public static final String EXTENSIONS_FILTER_PROPERTY_NAME = "extensionsFilter";
    public static final String EXTENSIONS_REJECT_PROPERTY_NAME = "extensionsReject";
    public static final String FOLDERS_FILTER_PROPERTY_NAME = "foldersFilter";
    public static final String FOLDERS_REJECT_PROPERTY_NAME = "foldersReject";
    public static final String FOLDERS_EXTENSIONS_FILTER_PROPERTY_NAME = "foldersExtensionsFilter";
    public static final String FOLDERS_EXTENSIONS_REJECT_PROPERTY_NAME = "foldersExtensionsReject";
    public static final String ANNOT_SOURCE_PROPERTY_NAME = "annotSource";
    public static final String SOURCE_PROPERTY_NAME = "sourceProperty";
    private static final String DEFAULT_USAGE_CONTEXT = "default_context";
    protected static final String CRAWLER_ID = "crawlerFolder";
    private static Map<String, String> usContextAndFolderUriMapping = Collections.synchronizedMap(new HashMap());
    private static Map<String, List<File>> usContextAndFileListMapping = Collections.synchronizedMap(new HashMap());
    private static Map<String, String> props;

    public FolderSourceReaderService() {
        if (props == null) {
            this.loadProps();
        }
    }

    @WebMethod(action="getResource")
    @WebResult(name="getResourceReturn", targetNamespace="http://weblab-project.org/services/sourcereader/types", partName="return")
    public GetResourceReturn getResource(@WebParam(name="getResourceArgs", targetNamespace="http://weblab-project.org/services/sourcereader/types", partName="args") GetResourceArgs args) throws GetResourceException {
        int limit = -1;
        int offset = 0;
        if (args != null) {
            limit = args.getLimit();
            offset = args.getOffset();
        }
        logger.info((Object)("GetResource method called. offset: " + offset + "; limit: " + limit));
        ResourceCollection col = (ResourceCollection)ResourceFactory.createResource((String)CRAWLER_ID, (String)("tempCollection-" + System.currentTimeMillis()), ResourceCollection.class);
        GetResourceReturn ret = new GetResourceReturn();
        ret.setResources(col);
        String urlToCrawl = (String)props.get(DEFAULT_FOLDER_URL_PROPERTY_NAME);
        String usContext = DEFAULT_USAGE_CONTEXT;
        if (args != null && args.getUsageContext() != null && args.getUsageContext().getUri() != null) {
            usContext = args.getUsageContext().getUri();
            urlToCrawl = (String)usContextAndFolderUriMapping.get(args.getUsageContext().getUri());
        } else {
            logger.info((Object)"Default folder URL is used for crawling.");
        }
        logger.info((Object)("URL to crawl: " + urlToCrawl));
        if (!usContextAndFileListMapping.containsKey(usContext)) {
            logger.info((Object)"First call, list files.");
            usContextAndFileListMapping.put(usContext, new ArrayList());
            File folderToCrawl = new File(urlToCrawl);
            this.listAndAddFiles(folderToCrawl, this.getFileFilterFromConfig(), usContext);
        }
        if (((List)usContextAndFileListMapping.get(usContext)).isEmpty()) {
            logger.warn((Object)("Folder (" + urlToCrawl + ") was empty."));
            usContextAndFileListMapping.remove(usContext);
            return ret;
        }
        if (offset >= ((List)usContextAndFileListMapping.get(usContext)).size()) {
            logger.warn((Object)"Every files have already been crawled.");
            usContextAndFileListMapping.remove(usContext);
            return ret;
        }
        if (offset < 0) {
            logger.warn((Object)"Offset was negative, 0 used instead.");
            offset = 0;
        }
        if (limit <= 0) {
            logger.info((Object)"Limit was null or negative. Integer.MAX_VALUE will be used.");
            limit = Integer.MAX_VALUE;
        }
        int cpt = offset;
        boolean toContinue = true;
        do {
            if (cpt < ((List)usContextAndFileListMapping.get(usContext)).size()) {
                String sourceProperty;
                boolean annotSource;
                File file = (File)((List)usContextAndFileListMapping.get(usContext)).get(cpt);
                if (!(file.exists() && file.isFile() && file.canRead())) {
                    ((List)usContextAndFileListMapping.get(usContext)).remove(cpt);
                    logger.warn((Object)("File (" + file + ") is not crawlable, remove from list."));
                    continue;
                }
                if (props.containsKey(ANNOT_SOURCE_PROPERTY_NAME)) {
                    annotSource = Boolean.parseBoolean((String)props.get(ANNOT_SOURCE_PROPERTY_NAME));
                } else {
                    logger.warn((Object)"Unable to load source annotation boolean from config file. false will be used.");
                    annotSource = false;
                }
                if (props.containsKey(SOURCE_PROPERTY_NAME)) {
                    sourceProperty = (String)props.get(SOURCE_PROPERTY_NAME);
                } else {
                    logger.warn((Object)"Unable to load source annotation property from config file. false will be used.");
                    sourceProperty = "http://purl.org/dc/elements/1.1/source";
                }
                logger.debug((Object)("Loading file: " + file.getAbsolutePath()));
                try {
                    Document document = (Document)new WebLabMarshaler().unmarshal(file, Document.class);
                    if (annotSource) {
                        Annotation annot = AnnotationFactory.createAndLinkAnnotation((Resource)document);
                        PoKHelper h = RDFHelperFactory.getPoKHelper((PieceOfKnowledge)annot);
                        h.createLitStat(document.getUri(), sourceProperty, file.getCanonicalPath());
                    }
                    col.getResource().add(document);
                }
                catch (WebLabCheckedException e) {
                    ((List)usContextAndFileListMapping.get(usContext)).remove(cpt);
                    logger.error((Object)("Resource (" + file + ") could not be unmarshaled, remove from list."));
                    continue;
                }
                catch (IOException ioe) {
                    ((List)usContextAndFileListMapping.get(usContext)).remove(cpt);
                    logger.error((Object)("Could not get canonical path for file: " + file.getAbsolutePath() + ", remove from list."));
                    continue;
                }
                if (Boolean.parseBoolean((String)props.get(DELETE_FILE_AFTER_PROPERTY_NAME)) && !file.delete()) {
                    file.deleteOnExit();
                }
                if (++cpt - offset < limit) continue;
                toContinue = false;
                continue;
            }
            toContinue = false;
        } while (toContinue);
        return ret;
    }

    protected void listAndAddFiles(File folderToCrawl, FileFilter filter, String usContextUri) {
        if (folderToCrawl.isDirectory()) {
            logger.debug((Object)("Add content of folder: " + folderToCrawl.getAbsolutePath()));
            for (File file : folderToCrawl.listFiles(filter)) {
                if (!((List)usContextAndFileListMapping.get(usContextUri)).contains(file) && !file.isDirectory()) {
                    logger.trace((Object)("Add file: " + file.getAbsolutePath()));
                    ((List)usContextAndFileListMapping.get(usContextUri)).add(file);
                }
                if (!Boolean.parseBoolean((String)props.get(RECURSIVE_PROPERTY_NAME)) || !file.isDirectory()) continue;
                this.listAndAddFiles(file, filter, usContextUri);
            }
        }
    }

    @WebMethod(action="configure")
    @WebResult(name="configureReturn", targetNamespace="http://weblab-project.org/services/configurable/types", partName="return")
    public ConfigureReturn configure(@WebParam(name="configureArgs", targetNamespace="http://weblab-project.org/services/configurable/types", partName="args") ConfigureArgs args) throws ConfigureException {
        if (args == null || args.getUsageContext() == null || args.getConfiguration() == null || args.getUsageContext().getUri() == null) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E1");
            wle.setErrorMessage("Invalid parameter");
            throw new ConfigureException("ConfigureArgs was invalid (either it self, usageContext, its uri or configuration was null)", wle);
        }
        PoKHelper helper = RDFHelperFactory.getPoKHelper((PieceOfKnowledge)args.getConfiguration());
        List urlLits = helper.getLitsOnPredSubj(SERVICE_URI, CRAWL_URL_PROPERTY);
        if (urlLits.size() == 0) {
            logger.error((Object)"Missing 'http://weblab-project.org/core/model/property/gathering/crawlUrl' property in the configuration.");
            WebLabException exp = new WebLabException();
            exp.setErrorId("E1");
            exp.setErrorMessage("Invalid parameter.");
            throw new ConfigureException("Missing 'http://weblab-project.org/core/model/property/gathering/crawlUrl' property in the configuration.", exp);
        }
        if (urlLits.size() > 1) {
            logger.warn((Object)"More than one property for 'http://weblab-project.org/core/model/property/gathering/crawlUrl' in the configuration, use first.");
        }
        usContextAndFolderUriMapping.put(args.getUsageContext().getUri(), urlLits.get(0));
        return new ConfigureReturn();
    }

    @WebMethod(action="resetConfiguration")
    @WebResult(name="resetConfigurationReturn", targetNamespace="http://weblab-project.org/services/configurable/types", partName="return")
    public ResetConfigurationReturn resetConfiguration(@WebParam(name="resetConfigurationArgs", targetNamespace="http://weblab-project.org/services/configurable/types", partName="args") ResetConfigurationArgs args) throws ResetConfigurationException {
        if (args == null || args.getUsageContext() == null || args.getUsageContext().getUri() == null) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E1");
            wle.setErrorMessage("Invalid parameter");
            throw new ResetConfigurationException("ResetConfigurationArgs was invalid (either it self, usageContext, it's uri or configuration was null", wle);
        }
        usContextAndFolderUriMapping.remove(args.getUsageContext().getUri());
        return new ResetConfigurationReturn();
    }

    private void loadProps() {
        HashSet<String> toLoad = new HashSet<String>();
        toLoad.add(DEFAULT_FOLDER_URL_PROPERTY_NAME);
        toLoad.add(RECURSIVE_PROPERTY_NAME);
        toLoad.add(DELETE_FILE_AFTER_PROPERTY_NAME);
        toLoad.add(EXTENSIONS_FILTER_PROPERTY_NAME);
        toLoad.add(EXTENSIONS_REJECT_PROPERTY_NAME);
        toLoad.add(FOLDERS_FILTER_PROPERTY_NAME);
        toLoad.add(FOLDERS_REJECT_PROPERTY_NAME);
        toLoad.add(FOLDERS_EXTENSIONS_FILTER_PROPERTY_NAME);
        toLoad.add(FOLDERS_EXTENSIONS_REJECT_PROPERTY_NAME);
        toLoad.add(ANNOT_SOURCE_PROPERTY_NAME);
        toLoad.add(SOURCE_PROPERTY_NAME);
        props = PropertiesLoader.loadProperties((String)SERVICE_CONFIG_FILE, toLoad);
    }

    private FileFilter getFileFilterFromConfig() {
        boolean folderExtRej;
        boolean folderRej;
        boolean extRej;
        if (props.containsKey(EXTENSIONS_REJECT_PROPERTY_NAME)) {
            extRej = Boolean.parseBoolean((String)props.get(EXTENSIONS_REJECT_PROPERTY_NAME));
        } else {
            logger.warn((Object)"Unable to load reject from config file. false will be used.");
            extRej = false;
        }
        ArrayList<String> ext = new ArrayList<String>();
        if (props.containsKey(EXTENSIONS_FILTER_PROPERTY_NAME)) {
            for (String string : ((String)props.get(EXTENSIONS_FILTER_PROPERTY_NAME)).split(";")) {
                if ((string = string.trim()).equals("")) continue;
                ext.add(string);
            }
            if (ext.isEmpty()) {
                logger.info((Object)"Extensions is empty; from extensionsFilter");
            }
        } else {
            logger.warn((Object)"Unable to get extensions from extensionsFilter");
        }
        if (props.containsKey(FOLDERS_REJECT_PROPERTY_NAME)) {
            folderRej = Boolean.parseBoolean((String)props.get(FOLDERS_REJECT_PROPERTY_NAME));
        } else {
            logger.warn((Object)"Unable to load reject from config file. false will be used.");
            folderRej = false;
        }
        ArrayList<String> folders = new ArrayList<String>();
        if (props.containsKey(FOLDERS_FILTER_PROPERTY_NAME)) {
            for (String string : ((String)props.get(FOLDERS_FILTER_PROPERTY_NAME)).split(";")) {
                if ((string = string.trim()).equals("")) continue;
                folders.add(string);
            }
            if (folders.isEmpty()) {
                logger.info((Object)"Extensions is empty; from foldersFilter");
            }
        } else {
            logger.warn((Object)"Unable to get extensions from foldersFilter");
        }
        if (props.containsKey(FOLDERS_EXTENSIONS_REJECT_PROPERTY_NAME)) {
            folderExtRej = Boolean.parseBoolean((String)props.get(FOLDERS_EXTENSIONS_REJECT_PROPERTY_NAME));
        } else {
            logger.warn((Object)"Unable to load folder extension reject from config file. false will be used.");
            folderExtRej = false;
        }
        ArrayList<String> foldersExt = new ArrayList<String>();
        if (props.containsKey(FOLDERS_EXTENSIONS_FILTER_PROPERTY_NAME)) {
            for (String string : ((String)props.get(FOLDERS_EXTENSIONS_FILTER_PROPERTY_NAME)).split(";")) {
                if ((string = string.trim()).equals("")) continue;
                foldersExt.add(string);
            }
            if (foldersExt.isEmpty()) {
                logger.info((Object)"Extensions is empty; from foldersExtensionsFilter");
            }
        } else {
            logger.warn((Object)"Unable to get extensions from foldersExtensionsFilter");
        }
        return new FolderAndExtensionFilter(folders, folderRej, ext, extRej, foldersExt, folderExtRej);
    }
}

