/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.gate;

import gate.AnnotationSet;
import gate.Corpus;
import gate.CorpusController;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.creole.ConditionalSerialAnalyserController;
import gate.creole.ConditionalSerialController;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.SerialAnalyserController;
import gate.creole.SerialController;
import gate.persist.PersistenceException;
import gate.util.GateException;
import gate.util.persistence.PersistenceManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.jws.WebService;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.service.gate.Configuration;
import org.ow2.weblab.service.gate.GateHelper;
import org.springframework.core.io.ClassPathResource;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.exception.WebLabUncheckedException;
import org.weblab_project.core.helper.RDFHelperFactory;
import org.weblab_project.core.helper.ResourceHelper;
import org.weblab_project.core.model.MediaUnit;
import org.weblab_project.core.model.Resource;
import org.weblab_project.core.model.text.Text;
import org.weblab_project.core.util.ResourceUtil;
import org.weblab_project.services.analyser.Analyser;
import org.weblab_project.services.analyser.ProcessException;
import org.weblab_project.services.analyser.types.ProcessArgs;
import org.weblab_project.services.analyser.types.ProcessReturn;
import org.weblab_project.services.exception.WebLabException;

/*
 * Exception performing whole class analysis ignored.
 */
@WebService(endpointInterface="org.weblab_project.services.analyser.Analyser")
public class GateService
implements Analyser {
    private static final String GATE_HOME_DIR = "gate";
    private static final String GATE_USER_FILE = "gate.xml";
    private static final String DEFAULT_PLUGIN_DIR = "plugins";
    private final String pluginDirectory;
    private static final String GATE_LANGUAGE_FEATURE = "language";
    private static boolean INITIALISED = false;
    private final String defaultGappFile;
    private final String serviceURI;

    public GateService(String defaultGappFile, String serviceURI) {
        this(defaultGappFile, serviceURI, "plugins");
    }

    public GateService(String defaultGappFile, String serviceURI, String pluginsPath) {
        this.defaultGappFile = defaultGappFile;
        this.serviceURI = serviceURI;
        this.pluginDirectory = pluginsPath;
        this.initGate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessReturn process(ProcessArgs args) throws ProcessException {
        CorpusController controller;
        CorpusController docGate;
        Corpus corpusGate;
        LogFactory.getLog(this.getClass()).info((Object)"Starting process of Gate Analyser");
        List texts = this.checkParameters(args);
        try {
            corpusGate = Factory.newCorpus((String)(this.hashCode() + " " + System.nanoTime()));
        }
        catch (ResourceInstantiationException rie) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E0");
            wle.setErrorMessage("Unexpected error");
            throw new ProcessException("Unable to instanciate new Corpus.", wle, (Throwable)rie);
        }
        ResourceHelper helper = RDFHelperFactory.getResourceHelper((Resource)args.getResource());
        String defaultLanguage = GateService.getLanguage((ResourceHelper)helper, (String)args.getResource().getUri());
        int errorCount = 0;
        HashMap<CorpusController, Text> gateDocsAndText = new HashMap<CorpusController, Text>();
        for (Text text : texts) {
            LogFactory.getLog(this.getClass()).debug((Object)("Text section to process by GateAnalyserComponent: " + text.getUri()));
            LogFactory.getLog(this.getClass()).debug((Object)("Number of segments before GateAnalyserComponent: " + text.getSegment().size()));
            try {
                docGate = Factory.newDocument((String)text.getContent());
            }
            catch (ResourceInstantiationException rie) {
                LogFactory.getLog(this.getClass()).error((Object)"Unable to create a new Gate Document.");
                if (++errorCount < 3) continue;
                WebLabException wle = new WebLabException();
                wle.setErrorId("E0");
                wle.setErrorMessage("Unexpected error");
                throw new ProcessException("Fails three times to instanciate new Gate Document.", wle, (Throwable)rie);
            }
            docGate.setSourceUrl(null);
            String language = GateService.getLanguage((ResourceHelper)helper, (String)text.getUri());
            if (language != null) {
                docGate.getFeatures().put((Object)"language", (Object)language);
            } else if (defaultLanguage != null) {
                docGate.getFeatures().put((Object)"language", (Object)defaultLanguage);
            }
            this.addGateDocumentToCorpus(corpusGate, (Document)docGate);
            gateDocsAndText.put(docGate, text);
        }
        String usageContext = args.getUsageContext() != null ? args.getUsageContext().getUri() : null;
        docGate = controller = this.getController(usageContext);
        synchronized (docGate) {
            controller.setCorpus(corpusGate);
            try {
                controller.execute();
            }
            catch (ExecutionException ee) {
                WebLabException wle = new WebLabException();
                wle.setErrorId("E0");
                wle.setErrorMessage("Unexpected exception.");
                throw new ProcessException("Unable to process pipeline of corpus.", wle, (Throwable)ee);
            }
        }
        for (Map.Entry entry : gateDocsAndText.entrySet()) {
            GateHelper.linkGateAnnotsToText((Text)((Text)entry.getValue()), (AnnotationSet)((Document)entry.getKey()).getAnnotations(), (String)this.serviceURI);
            if (LogFactory.getLog(this.getClass()).isDebugEnabled()) {
                LogFactory.getLog(this.getClass()).debug((Object)("Number of segment after GateExtractionComponent: " + ((Text)entry.getValue()).getSegment().size()));
                try {
                    LogFactory.getLog(this.getClass()).debug((Object)ResourceUtil.saveToXMLString((Resource)((Resource)entry.getValue())));
                }
                catch (WebLabCheckedException wlce) {
                    LogFactory.getLog(this.getClass()).warn((Object)("Unable to serialise to XML the resource: '" + ((Text)entry.getValue()).getUri() + "'."), (Throwable)wlce);
                }
            }
            corpusGate.unloadDocument((Document)entry.getKey());
            Factory.deleteResource((gate.Resource)((gate.Resource)entry.getKey()));
        }
        Factory.deleteResource((gate.Resource)corpusGate);
        ProcessReturn theRet = new ProcessReturn();
        theRet.setResource(args.getResource());
        return theRet;
    }

    private synchronized CorpusController getController(String usageContext) throws ProcessException {
        SerialController genericController;
        CorpusController controller = Configuration.getInstance().getController(usageContext);
        if (controller != null) {
            return controller;
        }
        try {
            genericController = (SerialController)PersistenceManager.loadObjectFromFile((File)this.getGappFile(usageContext));
        }
        catch (IOException ioe) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E2");
            wle.setErrorMessage("Insufficient resources.");
            throw new ProcessException("Unable to load gapp file.", wle, (Throwable)ioe);
        }
        catch (PersistenceException pe) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E0");
            wle.setErrorMessage("Unexpected exception.");
            throw new ProcessException("Unable to load gapp file.", wle, (Throwable)pe);
        }
        catch (ResourceInstantiationException rie) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E0");
            wle.setErrorMessage("Unexpected exception.");
            throw new ProcessException("Unable to load gapp file.", wle, (Throwable)rie);
        }
        if (genericController.getClass().getCanonicalName().equals(SerialAnalyserController.class.getCanonicalName())) {
            controller = (CorpusController)genericController;
        } else {
            ConditionalSerialAnalyserController conditionalPipeline;
            ConditionalSerialController csController = (ConditionalSerialController)genericController;
            try {
                conditionalPipeline = (ConditionalSerialAnalyserController)Factory.createResource((String)ConditionalSerialAnalyserController.class.getCanonicalName());
            }
            catch (ResourceInstantiationException rie) {
                WebLabException wle = new WebLabException();
                wle.setErrorId("E0");
                wle.setErrorMessage("Unexpected exception.");
                throw new ProcessException("Unable to create a '" + ConditionalSerialAnalyserController.class.getCanonicalName() + "' when converting conditional pipeline.", wle, (Throwable)rie);
            }
            conditionalPipeline.setPRs(csController.getPRs());
            conditionalPipeline.setRunningStrategies(csController.getRunningStrategies());
            controller = conditionalPipeline;
            Factory.deleteResource((gate.Resource)csController);
        }
        Configuration.getInstance().setController(usageContext, controller);
        return controller;
    }

    private static String getLanguage(ResourceHelper helper, String uri) {
        List languages = helper.getLitsOnPredSubj(uri, "http://purl.org/dc/elements/1.1/language");
        String language = languages.isEmpty() || ((String)languages.get(0)).toLowerCase().equals("unknown") ? null : ((String)languages.get(0)).toLowerCase();
        return language;
    }

    private File getGappFile(String usageContext) {
        String gappFilePath = Configuration.getInstance().getGateApplicationStateFilePath(usageContext);
        File gappFile = gappFilePath != null ? new File(gappFilePath) : new File(this.defaultGappFile);
        return gappFile;
    }

    private void addGateDocumentToCorpus(Corpus corpusGate, Document docGate) {
        corpusGate.add((Object)docGate);
    }

    private synchronized void initGate() throws WebLabUncheckedException {
        if (!INITIALISED) {
            File gateHome;
            try {
                gateHome = new ClassPathResource("gate").getFile();
            }
            catch (IOException ioe) {
                throw new WebLabUncheckedException("Unable to find 'gate' in classpathresource. Service is not initialised.", (Throwable)ioe);
            }
            LogFactory.getLog(this.getClass()).debug((Object)("Here is the path of your application => " + gateHome.getAbsolutePath()));
            Gate.setGateHome((File)gateHome);
            Gate.setUserConfigFile((File)new File(gateHome, "gate.xml"));
            Gate.setPluginsHome((File)new File(gateHome, this.pluginDirectory));
            Gate.setSiteConfigFile((File)new File(gateHome, "gate.xml"));
            try {
                Gate.init();
            }
            catch (GateException ge) {
                throw new WebLabUncheckedException("Unable to find initialise Gate.", (Throwable)ge);
            }
            INITIALISED = true;
        }
    }

    protected List<Text> checkParameters(ProcessArgs args) throws ProcessException {
        ArrayList<Text> texts = new ArrayList<Text>();
        if (args == null) {
            throw new ProcessException("ProcessArgs was null.", this.createInvalidParameterWLE());
        }
        Resource res = args.getResource();
        if (res == null) {
            throw new ProcessException("Resource in ProcessArg was null.", this.createInvalidParameterWLE());
        }
        if (!(res instanceof MediaUnit)) {
            throw new ProcessException("This service only process MediaUnit; Resource was a: " + res.getClass().getSimpleName() + ".", this.createInvalidParameterWLE());
        }
        if (res instanceof Text) {
            texts.add((Text)res);
        } else {
            texts.addAll(ResourceUtil.getSelectedSubResources((Resource)args.getResource(), Text.class));
        }
        ListIterator textIt = texts.listIterator();
        while (textIt.hasNext()) {
            Text text = (Text)textIt.next();
            if (text.getContent() != null) continue;
            textIt.remove();
        }
        return texts;
    }

    private WebLabException createInvalidParameterWLE() {
        WebLabException wle = new WebLabException();
        wle.setErrorId("E1");
        wle.setErrorMessage("Invalid parameter");
        return wle;
    }
}

