/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.gate;

import gate.CorpusController;
import gate.Factory;
import gate.Resource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class Configuration {
    private static Configuration SINGLETON;
    private Map<String, String> usContextForGateApplicationStateFileName = Collections.synchronizedMap(new HashMap());
    private Map<String, CorpusController> usContextForController = Collections.synchronizedMap(new HashMap());
    private CorpusController defaultController;

    private Configuration() {
    }

    public static synchronized Configuration getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new Configuration();
        }
        return SINGLETON;
    }

    public synchronized String getGateApplicationStateFilePath(String usageContext) {
        return this.usContextForGateApplicationStateFileName.get(usageContext);
    }

    public synchronized void setGateApplicationStateFileName(String usageContext, String fileName) {
        this.usContextForGateApplicationStateFileName.put(usageContext, fileName);
    }

    public synchronized CorpusController getController(String usageContext) {
        if (usageContext == null) {
            return this.defaultController;
        }
        return this.usContextForController.get(usageContext);
    }

    public synchronized void setController(String usageContext, CorpusController pipeline) {
        if (usageContext == null) {
            this.defaultController = pipeline;
        } else {
            this.usContextForController.put(usageContext, pipeline);
        }
    }

    public synchronized void resetConfiguration(String usageContext) {
        if (this.usContextForController.containsKey(usageContext)) {
            Factory.deleteResource((Resource)((Resource)this.usContextForController.get(usageContext)));
        }
        this.usContextForController.remove(usageContext);
        this.usContextForGateApplicationStateFileName.remove(usageContext);
        LogFactory.getLog(this.getClass()).info((Object)("Configuration for usageContext '" + usageContext + "' removed."));
    }

    public synchronized void resetConfiguration() {
        if (this.defaultController != null) {
            Factory.deleteResource((Resource)this.defaultController);
        }
        this.defaultController = null;
        for (CorpusController controller : this.usContextForController.values()) {
            Factory.deleteResource((Resource)controller);
        }
        this.usContextForController.clear();
        this.usContextForGateApplicationStateFileName.clear();
        LogFactory.getLog(this.getClass()).info((Object)"Every configuration were removed.");
    }
}

