/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.gate;

import gate.AnnotationSet;
import gate.FeatureMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.weblab_project.core.comparator.SegmentComparator;
import org.weblab_project.core.factory.AnnotationFactory;
import org.weblab_project.core.factory.SegmentFactory;
import org.weblab_project.core.helper.PoKHelperExtended;
import org.weblab_project.core.helper.RDFHelperFactory;
import org.weblab_project.core.model.Annotation;
import org.weblab_project.core.model.PieceOfKnowledge;
import org.weblab_project.core.model.Resource;
import org.weblab_project.core.model.text.LinearSegment;
import org.weblab_project.core.model.text.Text;
import org.weblab_project.core.properties.PropertiesLoader;

public class GateHelper {
    private static final String GATE_TEMP_NS = "http://weblab-project.org/core/model/property/processing/temp/gate/";
    private static final String GATE_TEMP_NS_PREFIX = "tempGate";
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private static final String PROPERTIES_FILE_NAME = "gate.properties";
    private static final String EXCLUSION_PROPERTY = "exclude";
    private static final String FEATURE_EXCLUSION_PROPERTY = "exludeFeatures";
    private static final String ADD_START_NODE_ID_PROPERTY = "addStartNodeId";
    private static final String ADD_END_NODE_ID_PROPERTY = "addEndNodeId";
    private static final String ADD_ANNOT_ID_PROPERTY = "addAnnotId";
    private static final String SERVICE_URI_PROPERTY = "serviceURI";
    private static Set<String> EXCLUDED_ANNOTATIONS = new HashSet<String>();
    private static Set<String> EXCLUDED_FEATURES = new HashSet<String>();
    private static boolean ADD_START_NODE_ID;
    private static boolean ADD_END_NODE_ID;
    private static boolean ADD_ANNOT_ID;
    private static String SERVICE_URI;
    public static final String GATE_TEMP_ANNOTATION_TYPE = "http://weblab-project.org/core/model/property/processing/temp/gate/type";
    public static final String GATE_TEMP_ANNOTATION_META = "http://weblab-project.org/core/model/property/processing/temp/gate/meta";

    public static void linkGateAnnotsToText(Text text, AnnotationSet annots) {
        HashMap<String, Annotation> annotated = new HashMap<String, Annotation>();
        for (gate.Annotation annot : annots) {
            if (EXCLUDED_ANNOTATIONS.contains(annot.getType())) continue;
            GateHelper.linkGateAnnotToText(text, annot, annotated);
        }
        Collections.sort(text.getSegment(), new SegmentComparator());
    }

    private static void linkGateAnnotToText(Text text, gate.Annotation annotGate, Map<String, Annotation> annotated) {
        PoKHelperExtended pokHelper;
        LinearSegment segment = SegmentFactory.createAndLinkLinearSegment((Text)text, (int)annotGate.getStartNode().getOffset().intValue(), (int)annotGate.getEndNode().getOffset().intValue());
        if (annotated.containsKey(segment.getUri())) {
            Annotation annot = annotated.get(segment.getUri());
            pokHelper = RDFHelperFactory.getPoKHelperExtended((PieceOfKnowledge)annot);
            pokHelper.setAutoCommitMode(false);
        } else {
            Annotation annot = AnnotationFactory.createAndLinkAnnotation((Resource)segment);
            annotated.put(segment.getUri(), annot);
            pokHelper = RDFHelperFactory.getPoKHelperExtended((PieceOfKnowledge)annot);
            pokHelper.setAutoCommitMode(false);
            pokHelper.setNSPrefix(GATE_TEMP_NS_PREFIX, GATE_TEMP_NS);
            if (SERVICE_URI != null) {
                pokHelper.setNSPrefix("wlp", "http://weblab-project.org/core/model/property/processing/");
                pokHelper.createResStat(annot.getUri(), "http://weblab-project.org/core/model/property/processing/isProducedBy", SERVICE_URI);
            }
        }
        GateHelper.reifyMetas(annotGate, segment.getUri(), pokHelper);
        pokHelper.commit();
    }

    private static void reifyMetas(gate.Annotation annotGate, String subject, PoKHelperExtended pokHE) {
        String reifURI = "weblab:gateAnnot/" + annotGate.getType() + "/" + System.nanoTime() + "/" + annotGate.hashCode();
        boolean reified = false;
        FeatureMap featureMap = annotGate.getFeatures();
        if (featureMap != null && !featureMap.isEmpty()) {
            for (Object key : featureMap.keySet()) {
                if (key instanceof String) {
                    Object featureValue;
                    String featKey = ((String)key).trim();
                    if (EXCLUDED_FEATURES.contains(featKey) || (featureValue = featureMap.get((Object)featKey)) == null) continue;
                    GateHelper.reifyLiteralMeta(subject, annotGate.getType(), featKey + "=" + featureValue.toString(), pokHE, reifURI);
                    reified = true;
                    continue;
                }
                LogFactory.getLog(GateHelper.class).warn((Object)("Unable to create feature from key '" + key + "' on gate annotation type '" + annotGate.getType() + "'."));
            }
        }
        if (ADD_START_NODE_ID) {
            GateHelper.reifyLiteralMeta(subject, annotGate.getType(), "gateStartNode=" + annotGate.getStartNode().getId().toString(), pokHE, reifURI);
            reified = true;
        }
        if (ADD_END_NODE_ID) {
            GateHelper.reifyLiteralMeta(subject, annotGate.getType(), "gateEndNode=" + annotGate.getEndNode().getId().toString(), pokHE, reifURI);
            reified = true;
        }
        if (ADD_ANNOT_ID) {
            GateHelper.reifyLiteralMeta(subject, annotGate.getType(), "gateAnnotId=" + annotGate.getId().toString(), pokHE, reifURI);
            reified = true;
        }
        if (!reified) {
            pokHE.createLitStat(subject, GATE_TEMP_ANNOTATION_TYPE, annotGate.getType());
        }
    }

    private static void reifyLiteralMeta(String subject, String object, String reifiedLiteral, PoKHelperExtended pokHE, String reifURI) {
        HashMap<String, String> properFeatures = new HashMap<String, String>(1);
        properFeatures.put(GATE_TEMP_ANNOTATION_META, reifiedLiteral);
        pokHE.createLitStatReif(subject, GATE_TEMP_ANNOTATION_TYPE, object, properFeatures, EMPTY_MAP, EMPTY_MAP, reifURI);
    }

    public static void init() {
        Map props = PropertiesLoader.loadProperties((String)PROPERTIES_FILE_NAME);
        String excludedString = (String)props.get(EXCLUSION_PROPERTY);
        String excludedFeaturesString = (String)props.get(FEATURE_EXCLUSION_PROPERTY);
        String addStartNodeIdString = (String)props.get(ADD_START_NODE_ID_PROPERTY);
        String addEndNodeIdString = (String)props.get(ADD_END_NODE_ID_PROPERTY);
        String addAnnotIdString = (String)props.get(ADD_ANNOT_ID_PROPERTY);
        SERVICE_URI = (String)props.get(SERVICE_URI_PROPERTY);
        if (excludedString != null && !excludedString.isEmpty()) {
            EXCLUDED_ANNOTATIONS.addAll(Arrays.asList(excludedString.split(";")));
        } else {
            LogFactory.getLog(GateHelper.class).warn((Object)"No exclude property found in gate.properties file; nothing will be skipped.");
        }
        if (excludedFeaturesString != null && !excludedFeaturesString.isEmpty()) {
            EXCLUDED_FEATURES.addAll(Arrays.asList(excludedFeaturesString.split(";")));
        } else {
            LogFactory.getLog(GateHelper.class).warn((Object)"No exludeFeatures property found in gate.properties file; nothing will be skipped.");
        }
        if (addAnnotIdString != null) {
            ADD_ANNOT_ID = Boolean.parseBoolean(addAnnotIdString);
        }
        if (addStartNodeIdString != null) {
            ADD_START_NODE_ID = Boolean.parseBoolean(addStartNodeIdString);
        }
        if (addEndNodeIdString != null) {
            ADD_END_NODE_ID = Boolean.parseBoolean(addEndNodeIdString);
        }
    }
}

