/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.service.gate;

import gate.CorpusController;
import gate.Factory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.LogFactory;

public class Configuration {
	private static Configuration SINGLETON;
	private Map<String, String> usContextForGateApplicationStateFileName = Collections.synchronizedMap(new HashMap<String, String>());
	private Map<String, CorpusController> usContextForController = Collections.synchronizedMap(new HashMap<String, CorpusController>());
	private CorpusController defaultController;

	private Configuration() {
		// SINGLETON : no instance is authorized
	}

	public static synchronized Configuration getInstance() {
		if (SINGLETON == null) {
			SINGLETON = new Configuration();
		}
		return SINGLETON;
	}

	public synchronized String getGateApplicationStateFilePath(final String usageContext) {
		return this.usContextForGateApplicationStateFileName.get(usageContext);
	}

	public synchronized void setGateApplicationStateFileName(final String usageContext, final String fileName) {
		this.usContextForGateApplicationStateFileName.put(usageContext, fileName);
	}

	public synchronized CorpusController getController(final String usageContext) {
		if (usageContext == null) {
			return this.defaultController;
		}
		return this.usContextForController.get(usageContext);
	}

	public synchronized void setController(final String usageContext, final CorpusController pipeline) {
		if (usageContext == null) {
			this.defaultController = pipeline;
		} else {
			this.usContextForController.put(usageContext, pipeline);
		}
	}

	public synchronized void resetConfiguration(final String usageContext) {
		if (this.usContextForController.containsKey(usageContext)) {
			Factory.deleteResource(this.usContextForController.get(usageContext));
		}
		this.usContextForController.remove(usageContext);
		this.usContextForGateApplicationStateFileName.remove(usageContext);
		LogFactory.getLog(this.getClass()).info("Configuration for usageContext '" + usageContext + "' removed.");
	}

	public synchronized void resetConfiguration() {
		if (this.defaultController != null) {
			Factory.deleteResource(this.defaultController);
		}
		this.defaultController = null;
		for (CorpusController controller : this.usContextForController.values()) {
			Factory.deleteResource(controller);
		}
		this.usContextForController.clear();
		this.usContextForGateApplicationStateFileName.clear();
		LogFactory.getLog(this.getClass()).info("Every configuration were removed.");
	}

}
