/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.gate;

import gate.AnnotationSet;
import gate.FeatureMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.weblab_project.core.comparator.SegmentComparator;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.factory.AnnotationFactory;
import org.weblab_project.core.factory.SegmentFactory;
import org.weblab_project.core.helper.PoKHelper;
import org.weblab_project.core.helper.PoKHelperExtended;
import org.weblab_project.core.helper.RDFHelperFactory;
import org.weblab_project.core.model.Annotation;
import org.weblab_project.core.model.PieceOfKnowledge;
import org.weblab_project.core.model.Resource;
import org.weblab_project.core.model.text.LinearSegment;
import org.weblab_project.core.model.text.Text;
import org.weblab_project.core.properties.PropertiesLoader;
import org.weblab_project.core.util.TextUtil;

public class GateHelper {
    public static final String GATE_TEMP_NS = "http://weblab-project.org/core/model/property/processing/temp/gate/";
    public static final String GATE_TEMP_NS_PREFIX = "tempGate";
    public static final String GATE_TYPE_BASE_URI = "http://gate.ac.uk/gatemodel#";
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    public static final String PROPERTIES_FILE_NAME = "gate.properties";
    public static final String EXCLUSION_PROPERTY = "gateAnnotationTypesToExclude";
    public static final String FEATURE_EXCLUSION_PROPERTY = "gateFeaturesToExlude";
    public static final String SERVICE_URI_PROPERTY = "addProducedByThisServiceURI";
    public static final String PROCESSING_MODE_PROPERTY = "annotationConversionMode";
    @Deprecated
    public static final String OLD_PROCESSING_MODE = "old";
    public static final String SIMPLE_PROCESSING_MODE = "simple";
    public static final String COMPLETE_PROCESSING_MODE = "complete";
    public static final String VERBOSE_PROPERTY = "verbose";
    private static Set<String> EXCLUDED_ANNOTATIONS = new HashSet<String>();
    private static Set<String> EXCLUDED_FEATURES = new HashSet<String>();
    @Deprecated
    private static boolean OLD_MODE;
    private static boolean ADD_FEATURES;
    private static boolean ADD_IDS;
    private static String SERVICE_URI;
    @Deprecated
    public static final String GATE_TEMP_ANNOTATION_TYPE = "http://weblab-project.org/core/model/property/processing/temp/gate/type";
    @Deprecated
    public static final String GATE_TEMP_ANNOTATION_META = "http://weblab-project.org/core/model/property/processing/temp/gate/meta";

    public static void linkGateAnnotsToText(Text text, AnnotationSet annots) {
        if (OLD_MODE) {
            HashMap<String, Annotation> annotated = new HashMap<String, Annotation>();
            for (gate.Annotation annot : annots) {
                if (EXCLUDED_ANNOTATIONS.contains(annot.getType())) continue;
                GateHelper.linkGateAnnotToText(text, annot, annotated);
            }
        } else {
            Annotation wlAnnot = AnnotationFactory.createAndLinkAnnotation((Resource)text);
            PoKHelperExtended pokhe = RDFHelperFactory.getPoKHelperExtended((PieceOfKnowledge)wlAnnot);
            pokhe.setAutoCommitMode(false);
            pokhe.setNSPrefix("wlp", "http://weblab-project.org/core/model/property/processing/");
            if (ADD_IDS || ADD_FEATURES) {
                pokhe.setNSPrefix(GATE_TEMP_NS_PREFIX, GATE_TEMP_NS);
            }
            if (SERVICE_URI != null) {
                pokhe.createResStat(wlAnnot.getUri(), "http://weblab-project.org/core/model/property/processing/isProducedBy", SERVICE_URI);
            }
            for (gate.Annotation gateAnnot : annots) {
                if (EXCLUDED_ANNOTATIONS.contains(gateAnnot.getType())) continue;
                GateHelper.linkGateAnnotToText(text, gateAnnot, (PoKHelper)pokhe);
            }
            pokhe.commit();
        }
        Collections.sort(text.getSegment(), new SegmentComparator());
    }

    private static void linkGateAnnotToText(Text text, gate.Annotation annotGate, PoKHelper pokh) {
        FeatureMap featureMap;
        String label;
        LinearSegment segment = SegmentFactory.createAndLinkLinearSegment((Text)text, (int)annotGate.getStartNode().getOffset().intValue(), (int)annotGate.getEndNode().getOffset().intValue());
        String instanceURI = "weblab:gateInstance/" + annotGate.getType() + "/" + System.nanoTime() + "/" + annotGate.hashCode();
        String typeURI = GATE_TYPE_BASE_URI + annotGate.getType();
        pokh.createResStat(instanceURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", typeURI);
        pokh.createResStat(segment.getUri(), "http://weblab-project.org/core/model/property/processing/refersTo", instanceURI);
        try {
            label = TextUtil.getSegmentText((Text)text, (LinearSegment)segment);
        }
        catch (WebLabCheckedException wlce) {
            LogFactory.getLog(GateHelper.class).warn((Object)("Unable to retrieve text at segment: " + segment.getUri()), (Throwable)wlce);
            label = "";
        }
        if (!label.trim().isEmpty()) {
            pokh.createLitStat(instanceURI, "http://www.w3.org/2000/01/rdf-schema#label", label.trim());
        }
        if (ADD_FEATURES && (featureMap = annotGate.getFeatures()) != null && !featureMap.isEmpty()) {
            for (Object key : featureMap.keySet()) {
                if (key instanceof String) {
                    Object featureValue;
                    String featKey = ((String)key).trim();
                    if (EXCLUDED_FEATURES.contains(featKey) || (featureValue = featureMap.get((Object)featKey)) == null) continue;
                    pokh.createLitStat(instanceURI, GATE_TEMP_NS + featKey, featureValue.toString());
                    continue;
                }
                LogFactory.getLog(GateHelper.class).warn((Object)("Unable to create feature from key '" + key + "' on gate annotation type '" + annotGate.getType() + "'."));
            }
        }
        if (ADD_IDS) {
            pokh.createLitStat(instanceURI, "http://weblab-project.org/core/model/property/processing/temp/gate/nodeId", annotGate.getId().toString());
            pokh.createLitStat(instanceURI, "http://weblab-project.org/core/model/property/processing/temp/gate/startNodeId", annotGate.getStartNode().getId().toString());
            pokh.createLitStat(instanceURI, "http://weblab-project.org/core/model/property/processing/temp/gate/endNodeId", annotGate.getEndNode().getId().toString());
        }
    }

    private static void linkGateAnnotToText(Text text, gate.Annotation annotGate, Map<String, Annotation> annotated) {
        PoKHelperExtended pokHelper;
        LinearSegment segment = SegmentFactory.createAndLinkLinearSegment((Text)text, (int)annotGate.getStartNode().getOffset().intValue(), (int)annotGate.getEndNode().getOffset().intValue());
        if (annotated.containsKey(segment.getUri())) {
            Annotation annot = annotated.get(segment.getUri());
            pokHelper = RDFHelperFactory.getPoKHelperExtended((PieceOfKnowledge)annot);
            pokHelper.setAutoCommitMode(false);
        } else {
            Annotation annot = AnnotationFactory.createAndLinkAnnotation((Resource)segment);
            annotated.put(segment.getUri(), annot);
            pokHelper = RDFHelperFactory.getPoKHelperExtended((PieceOfKnowledge)annot);
            pokHelper.setAutoCommitMode(false);
            pokHelper.setNSPrefix(GATE_TEMP_NS_PREFIX, GATE_TEMP_NS);
            if (SERVICE_URI != null) {
                pokHelper.setNSPrefix("wlp", "http://weblab-project.org/core/model/property/processing/");
                pokHelper.createResStat(annot.getUri(), "http://weblab-project.org/core/model/property/processing/isProducedBy", SERVICE_URI);
            }
        }
        GateHelper.reifyMetas(annotGate, segment.getUri(), pokHelper);
        pokHelper.commit();
    }

    private static void reifyMetas(gate.Annotation annotGate, String subject, PoKHelperExtended pokHE) {
        String reifURI = "weblab:gateAnnot/" + annotGate.getType() + "/" + System.nanoTime() + "/" + annotGate.hashCode();
        boolean reified = false;
        FeatureMap featureMap = annotGate.getFeatures();
        if (featureMap != null && !featureMap.isEmpty()) {
            for (Object key : featureMap.keySet()) {
                if (key instanceof String) {
                    Object featureValue;
                    String featKey = ((String)key).trim();
                    if (EXCLUDED_FEATURES.contains(featKey) || (featureValue = featureMap.get((Object)featKey)) == null) continue;
                    GateHelper.reifyLiteralMeta(subject, annotGate.getType(), featKey + "=" + featureValue.toString(), pokHE, reifURI);
                    reified = true;
                    continue;
                }
                LogFactory.getLog(GateHelper.class).warn((Object)("Unable to create feature from key '" + key + "' on gate annotation type '" + annotGate.getType() + "'."));
            }
        }
        if (ADD_IDS) {
            GateHelper.reifyLiteralMeta(subject, annotGate.getType(), "gateStartNode=" + annotGate.getStartNode().getId().toString(), pokHE, reifURI);
            GateHelper.reifyLiteralMeta(subject, annotGate.getType(), "gateEndNode=" + annotGate.getEndNode().getId().toString(), pokHE, reifURI);
            GateHelper.reifyLiteralMeta(subject, annotGate.getType(), "gateAnnotId=" + annotGate.getId().toString(), pokHE, reifURI);
            reified = true;
        }
        if (!reified) {
            pokHE.createLitStat(subject, GATE_TEMP_ANNOTATION_TYPE, annotGate.getType());
        }
    }

    private static void reifyLiteralMeta(String subject, String object, String reifiedLiteral, PoKHelperExtended pokHE, String reifURI) {
        HashMap<String, String> properFeatures = new HashMap<String, String>(1);
        properFeatures.put(GATE_TEMP_ANNOTATION_META, reifiedLiteral);
        pokHE.createLitStatReif(subject, GATE_TEMP_ANNOTATION_TYPE, object, properFeatures, EMPTY_MAP, EMPTY_MAP, reifURI);
    }

    public static void init() {
        Map props = PropertiesLoader.loadProperties((String)PROPERTIES_FILE_NAME);
        String excludedString = (String)props.get(EXCLUSION_PROPERTY);
        String excludedFeaturesString = (String)props.get(FEATURE_EXCLUSION_PROPERTY);
        String processingMode = (String)props.get(PROCESSING_MODE_PROPERTY);
        String verboseMode = (String)props.get(VERBOSE_PROPERTY);
        SERVICE_URI = (String)props.get(SERVICE_URI_PROPERTY);
        if (excludedString != null && !excludedString.isEmpty()) {
            EXCLUDED_ANNOTATIONS.addAll(Arrays.asList(excludedString.split(";")));
        } else {
            LogFactory.getLog(GateHelper.class).warn((Object)"No gateAnnotationTypesToExclude property found in gate.properties file; nothing will be skipped.");
        }
        if (excludedFeaturesString != null && !excludedFeaturesString.isEmpty()) {
            EXCLUDED_FEATURES.addAll(Arrays.asList(excludedFeaturesString.split(";")));
        } else {
            LogFactory.getLog(GateHelper.class).warn((Object)"No gateFeaturesToExlude property found in gate.properties file; nothing will be skipped.");
        }
        if (processingMode.equalsIgnoreCase(OLD_PROCESSING_MODE)) {
            OLD_MODE = true;
            ADD_FEATURES = true;
        } else if (processingMode.equalsIgnoreCase(SIMPLE_PROCESSING_MODE)) {
            OLD_MODE = false;
            ADD_FEATURES = false;
        } else if (processingMode.equalsIgnoreCase(COMPLETE_PROCESSING_MODE)) {
            OLD_MODE = false;
            ADD_FEATURES = true;
        } else {
            LogFactory.getLog(GateHelper.class).warn((Object)"No annotationConversionMode property found in gate.properties file; SimpleMode will be used.");
            OLD_MODE = false;
            ADD_FEATURES = false;
        }
        if (verboseMode != null) {
            ADD_IDS = Boolean.parseBoolean(verboseMode);
        }
    }
}

