/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2011 Cassidian SAS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.service.gate;

import org.weblab_project.services.exception.WebLabException;


/**
 * A simple enumeration that enables (through the public field <code>wle</code>) to retrieve every known types of
 * WebLabException
 * <ol>
 * <li>E0: Unexpected error</li>
 * <li>E1: Invalid parameter</li>
 * <li>E2: Insufficient resources</li>
 * <li>E3: Content not available</li>
 * <li>E4: Access denied</li>
 * <li>E5: Unsupported request</li>
 * <li>E6: Service not configured</li>
 * </ol>
 * 
 * @author ymombrun
 * @date 2010-08-13
 */
public enum WebLabExceptions {

	E0("E0", "Unexpected error."),

	E1("E1", "Invalid parameter."),

	E2("E2", "Insufficient resources."),

	E3("E3", "Content not available."),

	E4("E4", "Access denied."),

	E5("E5", "Unsupported request."),

	E6("E6", "Service not configured.");

	/**
	 * The WebLabException that matches the enumeration instance name.
	 */
	public final WebLabException wle;

	/**
	 * Initialises a WebLabException in the instance of WebLabExceptions.
	 * 
	 * @param errorId
	 *            The errorId of the inner WebLabException
	 * @param errorMessage
	 *            The errorMessage of the inner WebLabException
	 */
	private WebLabExceptions(final String errorId, final String errorMessage) {
		final WebLabException tempWLE = new WebLabException();
		tempWLE.setErrorId(errorId);
		tempWLE.setErrorMessage(errorMessage);
		this.wle = tempWLE;
	}
}
