/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.gate;

import gate.CorpusController;
import gate.Factory;
import gate.Resource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class Configuration {
    private static Configuration SINGLETON;
    private final Map<String, String> usContextForGappFilePath = Collections.synchronizedMap(new HashMap());
    private final Map<String, CorpusController> gappFilePathForController = Collections.synchronizedMap(new HashMap());

    private Configuration() {
    }

    public static synchronized Configuration getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new Configuration();
        }
        return SINGLETON;
    }

    public synchronized void configure(String usageContext, String gappFilePath) {
        if (this.isControllerInitialised(usageContext)) {
            this.resetConfiguration(usageContext);
        }
        this.usContextForGappFilePath.put(usageContext, gappFilePath);
    }

    public synchronized void resetConfiguration() {
        for (CorpusController controller : this.gappFilePathForController.values()) {
            Factory.deleteResource((Resource)controller);
        }
        this.gappFilePathForController.clear();
        this.usContextForGappFilePath.clear();
        LogFactory.getLog(this.getClass()).info((Object)"Every configuration were removed.");
        SINGLETON = null;
    }

    public synchronized boolean isConfigured(String usageContext) {
        return this.usContextForGappFilePath.containsKey(usageContext);
    }

    public synchronized boolean isControllerInitialised(String gappFilePath) {
        return this.gappFilePathForController.containsKey(gappFilePath);
    }

    public synchronized CorpusController getController(String gappFilePath) {
        return this.gappFilePathForController.get(gappFilePath);
    }

    public synchronized String getGappFilePathForUsageContext(String usageContext) {
        return this.usContextForGappFilePath.get(usageContext);
    }

    public synchronized void setGappFileForUsageContext(String usageContext, String filePath) {
        this.usContextForGappFilePath.put(usageContext, filePath);
    }

    public synchronized void setControllerForUsageContextAndGapp(String usageContext, CorpusController pipeline) {
        String gappFile = this.usContextForGappFilePath.get(usageContext);
        this.gappFilePathForController.put(gappFile, pipeline);
    }

    public synchronized void resetConfiguration(String usageContext) {
        String gappFile = this.usContextForGappFilePath.remove(usageContext);
        if (gappFile == null) {
            LogFactory.getLog(this.getClass()).warn((Object)("Unable to resetConfiguration on usageContext '" + usageContext + "' since it has not been configured."));
        } else if (this.isControllerInitialised(usageContext) && !this.usContextForGappFilePath.containsValue(gappFile)) {
            Factory.deleteResource((Resource)((Resource)this.gappFilePathForController.get(gappFile)));
        } else {
            LogFactory.getLog(this.getClass()).warn((Object)"Nothing to do since the controller has not been initialised.");
        }
        LogFactory.getLog(this.getClass()).info((Object)("Configuration for usageContext '" + usageContext + "' removed."));
    }
}

