/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.gate;

import gate.Corpus;
import gate.CorpusController;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.util.GateException;
import gate.util.persistence.PersistenceManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.service.gate.Configuration;
import org.ow2.weblab.service.gate.WebLabExceptions;
import org.ow2.weblab.service.gate.converter.GateConverter;
import org.ow2.weblab.service.gate.converter.GateToWebLab;
import org.springframework.core.io.ClassPathResource;
import org.weblab_project.core.exception.WebLabUncheckedException;
import org.weblab_project.core.helper.RDFHelperFactory;
import org.weblab_project.core.helper.ResourceHelper;
import org.weblab_project.core.model.MediaUnit;
import org.weblab_project.core.model.Resource;
import org.weblab_project.core.model.text.Text;
import org.weblab_project.core.model.user.UsageContext;
import org.weblab_project.core.util.ResourceUtil;
import org.weblab_project.services.analyser.Analyser;
import org.weblab_project.services.analyser.ProcessException;
import org.weblab_project.services.analyser.types.ProcessArgs;
import org.weblab_project.services.analyser.types.ProcessReturn;

@WebService(endpointInterface="org.weblab_project.services.analyser.Analyser")
public class GateService
implements Analyser {
    private static final String UNKNOWN = "unknown";
    private static final String GATE_HOME_DIR = "gate";
    private static final String GATE_USER_FILE = "gate.xml";
    private static final String GATE_PLUGINS_DIR = "plugins";
    private static final String DEFAULT_GAPP_FILE = "default.gapp";
    private static final String GATE_LANGUAGE_FEATURE = "language";
    private static boolean INITIALISED = false;
    private final File defaultGappFile;
    private final GateConverter converter;
    private final Log log = LogFactory.getLog(this.getClass());

    public GateService() throws IOException {
        this(new ClassPathResource(DEFAULT_GAPP_FILE).getFile());
    }

    public GateService(File defaultGappFile) throws IOException {
        this(defaultGappFile, new File(new ClassPathResource(GATE_HOME_DIR).getFile(), GATE_PLUGINS_DIR));
    }

    public GateService(File defaultGappFile, File pluginsPath) throws IOException {
        this(defaultGappFile, pluginsPath, new GateToWebLab());
    }

    public GateService(File defaultGappFile, File pluginsPath, GateConverter converter) throws IOException {
        this.defaultGappFile = defaultGappFile;
        this.converter = converter;
        this.initGate(pluginsPath);
        LogFactory.getLog(this.getClass()).info((Object)"Gate Service successully initialised.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessReturn process(ProcessArgs args) throws ProcessException {
        Text text2;
        Corpus corpusGate;
        this.log.debug((Object)"Early starting of Gate Analyser");
        List<Text> texts = this.checkParameters(args);
        if (texts.isEmpty()) {
            this.log.warn((Object)("No text content found in resource '" + args.getResource().getUri() + "'. Nothing done."));
            ProcessReturn theRet = new ProcessReturn();
            theRet.setResource(args.getResource());
            return theRet;
        }
        this.log.info((Object)("Starting the processing of resource '" + args.getResource().getUri() + "' with Gate."));
        try {
            corpusGate = Factory.newCorpus((String)(args.getResource().getUri() + " " + System.nanoTime()));
        }
        catch (ResourceInstantiationException rie) {
            this.log.error((Object)"Unable to instanciate new Corpus.", (Throwable)rie);
            throw new ProcessException("Unable to instanciate new Corpus.", WebLabExceptions.E0.wle, (Throwable)rie);
        }
        ResourceHelper helper = RDFHelperFactory.getResourceHelper((Resource)args.getResource());
        String docDefaultLanguage = this.getLanguage(helper, args.getResource().getUri());
        HashMap<Document, Text> gateDocsAndText = new HashMap<Document, Text>();
        for (Text text2 : texts) {
            Document docGate;
            this.log.debug((Object)("Text section to process by GateAnalyserComponent: " + text2.getUri()));
            this.log.debug((Object)("Number of segments before GateAnalyserComponent: " + text2.getSegment().size()));
            try {
                docGate = Factory.newDocument((String)text2.getContent());
            }
            catch (ResourceInstantiationException rie) {
                this.log.warn((Object)("Unable to create a new Gate Document for text '" + text2.getUri() + ". Skipping it."), (Throwable)rie);
                continue;
            }
            String language = this.getLanguage(helper, text2.getUri(), docDefaultLanguage);
            docGate.getFeatures().put((Object)GATE_LANGUAGE_FEATURE, (Object)language);
            this.addGateDocumentToCorpus(corpusGate, docGate);
            gateDocsAndText.put(docGate, text2);
        }
        texts.clear();
        if (corpusGate.isEmpty()) {
            Factory.deleteResource((gate.Resource)corpusGate);
            ProcessException pe = new ProcessException("Unable to instanciate Gate documents for each text section of resource " + args.getResource().getUri() + ".", WebLabExceptions.E0.wle);
            this.log.error((Object)pe.getMessage(), (Throwable)pe);
            throw pe;
        }
        CorpusController controller = this.getController(args.getUsageContext());
        text2 = controller;
        synchronized (text2) {
            controller.setCorpus(corpusGate);
            try {
                controller.execute();
            }
            catch (ExecutionException ee) {
                Factory.deleteResource((gate.Resource)corpusGate);
                this.log.error((Object)"Unable to process pipeline of corpus.", (Throwable)ee);
                ProcessException pe = new ProcessException("Unable to process pipeline of corpus.", WebLabExceptions.E0.wle, (Throwable)ee);
                throw pe;
            }
        }
        this.log.info((Object)("Answer received from Gate. Starting annotation convertion for Resource '" + args.getResource().getUri() + "'."));
        this.converter.convertInformation(corpusGate, args.getResource(), gateDocsAndText);
        ProcessReturn theRet = new ProcessReturn();
        theRet.setResource(args.getResource());
        this.log.info((Object)("Resource '" + args.getResource().getUri() + "' successfully processed with Gate Analyser"));
        return theRet;
    }

    private synchronized CorpusController getController(UsageContext uc) throws ProcessException {
        CorpusController controller;
        String usageContext = uc == null ? "" : (uc.getUri() == null ? "" : uc.getUri());
        if (!Configuration.getInstance().isConfigured(usageContext)) {
            Configuration.getInstance().setGappFileForUsageContext(usageContext, this.defaultGappFile.getPath());
        }
        String gappFile = Configuration.getInstance().getGappFilePathForUsageContext(usageContext);
        if (Configuration.getInstance().isControllerInitialised(gappFile)) {
            controller = Configuration.getInstance().getController(gappFile);
        } else {
            try {
                controller = (CorpusController)PersistenceManager.loadObjectFromFile((File)new File(gappFile));
            }
            catch (IOException ioe) {
                this.log.error((Object)"Unable to load gapp file.", (Throwable)ioe);
                throw new ProcessException("Unable to load gapp file.", WebLabExceptions.E2.wle, (Throwable)ioe);
            }
            catch (PersistenceException pe) {
                this.log.error((Object)"Unable to load gapp file.", (Throwable)pe);
                throw new ProcessException("Unable to load gapp file.", WebLabExceptions.E0.wle, (Throwable)pe);
            }
            catch (ResourceInstantiationException rie) {
                this.log.error((Object)"Unable to load gapp file.", (Throwable)rie);
                throw new ProcessException("Unable to load gapp file.", WebLabExceptions.E0.wle, (Throwable)rie);
            }
            Configuration.getInstance().setControllerForUsageContextAndGapp(usageContext, controller);
        }
        return controller;
    }

    private String getLanguage(ResourceHelper helper, String uri) {
        return this.getLanguage(helper, uri, null);
    }

    private String getLanguage(ResourceHelper helper, String uri, String defaultValue) {
        List languages = helper.getLitsOnPredSubj(uri, "http://purl.org/dc/elements/1.1/language");
        String language = languages.isEmpty() || ((String)languages.get(0)).equalsIgnoreCase(UNKNOWN) ? defaultValue : ((String)languages.get(0)).toLowerCase();
        return language;
    }

    private void addGateDocumentToCorpus(Corpus corpusGate, Document docGate) {
        corpusGate.add((Object)docGate);
    }

    private synchronized void initGate(File pluginsdir) throws IOException {
        if (!INITIALISED) {
            File gateHome = new ClassPathResource(GATE_HOME_DIR).getFile();
            this.log.debug((Object)("Here is the path of your application => " + gateHome.getAbsolutePath()));
            Gate.setGateHome((File)gateHome);
            Gate.setUserConfigFile((File)new File(gateHome, GATE_USER_FILE));
            Gate.setPluginsHome((File)pluginsdir);
            Gate.setSiteConfigFile((File)new File(gateHome, GATE_USER_FILE));
            try {
                Gate.init();
            }
            catch (GateException ge) {
                this.log.warn((Object)"Error when initialising Gate.", (Throwable)ge);
                throw new WebLabUncheckedException("Unable to find initialise Gate.", (Throwable)ge);
            }
            INITIALISED = true;
        }
    }

    protected List<Text> checkParameters(ProcessArgs args) throws ProcessException {
        List<Text> texts;
        if (args == null) {
            throw new ProcessException("ProcessArgs was null.", WebLabExceptions.E1.wle);
        }
        Resource res = args.getResource();
        if (res == null) {
            throw new ProcessException("Resource in ProcessArg was null.", WebLabExceptions.E1.wle);
        }
        if (!(res instanceof MediaUnit)) {
            throw new ProcessException("This service only process MediaUnit; Resource was a: " + res.getClass().getSimpleName() + ".", WebLabExceptions.E1.wle);
        }
        if (res instanceof Text) {
            texts = new LinkedList<Text>();
            texts.add((Text)res);
        } else {
            texts = ResourceUtil.getSelectedSubResources((Resource)args.getResource(), Text.class);
        }
        ListIterator textIt = texts.listIterator();
        while (textIt.hasNext()) {
            Text text = (Text)textIt.next();
            if (text.getContent() != null) continue;
            textIt.remove();
        }
        return texts;
    }
}

