/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.gate.converter;

import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.service.gate.converter.GateConverter;
import org.weblab_project.core.comparator.SegmentComparator;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.factory.AnnotationFactory;
import org.weblab_project.core.factory.SegmentFactory;
import org.weblab_project.core.helper.PoKHelper;
import org.weblab_project.core.helper.PoKHelperExtended;
import org.weblab_project.core.helper.RDFHelperFactory;
import org.weblab_project.core.model.Annotation;
import org.weblab_project.core.model.PieceOfKnowledge;
import org.weblab_project.core.model.Resource;
import org.weblab_project.core.model.text.LinearSegment;
import org.weblab_project.core.model.text.Text;
import org.weblab_project.core.properties.PropertiesLoader;
import org.weblab_project.core.util.ResourceUtil;
import org.weblab_project.core.util.TextUtil;

public class GateToWebLab
implements GateConverter {
    public static final String PROPERTIES_FILE_NAME = "gatetoweblab.properties";
    public static final String SKIPPED_ANNOTATIONS_PROPERTY = "skippedAnnotations";
    public static final String SKIPPED_FEATURES_PROPERTY = "skippedFeatures";
    public static final String SERVICE_URI_PROPERTY = "serviceUri";
    public static final String MAX_ANNOTS_PROPERTY = "maxNumberOfAnnots";
    public static final String INCLUDE_FEATURES_PROPERTY = "includeFeatures";
    public static final String INCLUDE_IDS_PROPERTY = "includeIds";
    private static final String GATE_PREFIX = "gate";
    private static final String GATE_URI = "http://gate.ac.uk/gatemodel#";
    private static final String INSTANCE_URI_PREFIX = "weblab:gateInstance/";
    private static final String END_NODE_ID = "http://gate.ac.uk/gatemodel#endNodeId";
    private static final String START_NODE_ID = "http://gate.ac.uk/gatemodel#startNodeId";
    private static final String NODE_ID = "http://gate.ac.uk/gatemodel#nodeId";
    private final Set<String> excludedAnnotations;
    private final Set<String> excludedFeatures;
    private final boolean addFeatures;
    private final boolean addIds;
    private final String serviceURI;
    private final int maxNumberOfAnnots;
    private final Log log = LogFactory.getLog(this.getClass());

    public GateToWebLab() {
        Map props = PropertiesLoader.loadProperties((String)PROPERTIES_FILE_NAME);
        this.log.debug((Object)("Property file loaded. " + props));
        this.serviceURI = (String)props.get(SERVICE_URI_PROPERTY);
        String excludedString = (String)props.get(SKIPPED_ANNOTATIONS_PROPERTY);
        if (excludedString != null && !excludedString.isEmpty()) {
            this.excludedAnnotations = new HashSet<String>(Arrays.asList(excludedString.split(";")));
        } else {
            this.log.warn((Object)"No skippedAnnotations property found in gatetoweblab.properties file; nothing will be skipped.");
            this.excludedAnnotations = Collections.emptySet();
        }
        String excludedFeaturesString = (String)props.get(SKIPPED_FEATURES_PROPERTY);
        if (excludedFeaturesString != null && !excludedFeaturesString.isEmpty()) {
            this.excludedFeatures = new HashSet<String>(Arrays.asList(excludedFeaturesString.split(";")));
        } else {
            this.log.warn((Object)"No skippedFeatures property found in gatetoweblab.properties file; nothing will be skipped.");
            this.excludedFeatures = Collections.emptySet();
        }
        String includeFeatures = (String)props.get(INCLUDE_FEATURES_PROPERTY);
        if (includeFeatures != null) {
            this.addFeatures = Boolean.parseBoolean(includeFeatures);
        } else {
            this.log.warn((Object)"No includeFeatures property found in gatetoweblab.properties file; Features will not be added.");
            this.addFeatures = false;
        }
        String verboseMode = (String)props.get(INCLUDE_IDS_PROPERTY);
        if (verboseMode != null) {
            this.addIds = Boolean.parseBoolean(verboseMode);
        } else {
            this.log.warn((Object)"No includeIds property found in gatetoweblab.properties file; Verbose mode will not be activated.");
            this.addIds = false;
        }
        String maxNumberOfSegmentsString = (String)props.get(MAX_ANNOTS_PROPERTY);
        if (maxNumberOfSegmentsString != null) {
            int value;
            try {
                value = Integer.parseInt(maxNumberOfSegmentsString);
                if (value == 0) {
                    value = -1;
                }
            }
            catch (NumberFormatException nfe) {
                this.log.warn((Object)("Unable to parse maxNumberOfAnnots property found in gatetoweblab.properties. Read value was: '" + maxNumberOfSegmentsString + "'; No limit will be used."));
                value = -1;
            }
            this.maxNumberOfAnnots = value;
        } else {
            this.log.warn((Object)"No maxNumberOfAnnots property found in gatetoweblab.properties file; No limit will be used.");
            this.maxNumberOfAnnots = -1;
        }
        props.clear();
    }

    @Override
    public void convertInformation(Corpus corpusGate, Resource resource, Map<Document, Text> gateDocsAndText) {
        Iterator<Map.Entry<Document, Text>> it = gateDocsAndText.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Document, Text> entry = it.next();
            this.linkGateAnnotsToText(entry.getValue(), entry.getKey().getAnnotations());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Number of segment after GateExtractionComponent: " + entry.getValue().getSegment().size()));
                try {
                    this.log.debug((Object)ResourceUtil.saveToXMLString((Resource)((Resource)entry.getValue())));
                }
                catch (WebLabCheckedException wlce) {
                    this.log.warn((Object)("Unable to serialise to XML the resource: '" + entry.getValue().getUri() + "'."), (Throwable)wlce);
                }
            }
            corpusGate.unloadDocument(entry.getKey());
            Factory.deleteResource((gate.Resource)((gate.Resource)entry.getKey()));
            it.remove();
        }
        gateDocsAndText.clear();
        Factory.deleteResource((gate.Resource)corpusGate);
    }

    private void linkGateAnnotsToText(Text text, AnnotationSet annots) {
        int nbAnnots = 0;
        Annotation wlAnnot = AnnotationFactory.createAndLinkAnnotation((Resource)text);
        PoKHelperExtended pokhe = RDFHelperFactory.getPoKHelperExtended((PieceOfKnowledge)wlAnnot);
        pokhe.setAutoCommitMode(false);
        pokhe.setNSPrefix("wlp", "http://weblab-project.org/core/model/property/processing/");
        if (this.addFeatures || this.addIds) {
            pokhe.setNSPrefix(GATE_PREFIX, GATE_URI);
        }
        if (this.serviceURI != null) {
            pokhe.createResStat(wlAnnot.getUri(), "http://weblab-project.org/core/model/property/processing/isProducedBy", this.serviceURI);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Gate Annotation set: " + annots));
        }
        for (gate.Annotation gateAnnot : annots) {
            if (this.excludedAnnotations.contains(gateAnnot.getType())) continue;
            if (this.maxNumberOfAnnots < 0 || nbAnnots <= this.maxNumberOfAnnots) {
                this.linkGateAnnotToText(text, gateAnnot, (PoKHelper)pokhe);
                ++nbAnnots;
                continue;
            }
            this.log.warn((Object)("Too many annotations created on a single media-unit (" + nbAnnots + "). Return as it is."));
            break;
        }
        if (nbAnnots > 0) {
            try {
                pokhe.commit();
            }
            catch (Exception e) {
                this.log.error((Object)("Unable to serialise RDF model for text '" + text.getUri() + "'."), (Throwable)e);
                this.log.debug((Object)annots);
            }
            Collections.sort(text.getSegment(), new SegmentComparator());
        } else {
            text.getAnnotation().remove(wlAnnot);
        }
    }

    private void linkGateAnnotToText(Text text, gate.Annotation annotGate, PoKHelper pokh) {
        FeatureMap featureMap;
        String label;
        LinearSegment segment = SegmentFactory.createAndLinkLinearSegment((Text)text, (int)annotGate.getStartNode().getOffset().intValue(), (int)annotGate.getEndNode().getOffset().intValue());
        String instanceURI = INSTANCE_URI_PREFIX + annotGate.getType() + '#' + System.nanoTime();
        String typeURI = GATE_URI + annotGate.getType();
        try {
            label = TextUtil.getSegmentText((Text)text, (LinearSegment)segment);
        }
        catch (WebLabCheckedException wlce) {
            this.log.warn((Object)("Unable to retrieve text at segment: " + segment.getUri() + " - " + segment.getStart() + " - " + segment.getEnd() + ". Removing it."), (Throwable)wlce);
            text.getSegment().remove(segment);
            return;
        }
        pokh.createResStat(instanceURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", typeURI);
        pokh.createResStat(segment.getUri(), "http://weblab-project.org/core/model/property/processing/refersTo", instanceURI);
        if (!label.trim().isEmpty()) {
            pokh.createLitStat(instanceURI, "http://www.w3.org/2000/01/rdf-schema#label", label.trim());
        }
        if (this.addFeatures && (featureMap = annotGate.getFeatures()) != null && !featureMap.isEmpty()) {
            for (Map.Entry entry : featureMap.entrySet()) {
                if (entry.getKey() instanceof String) {
                    String featureName = ((String)entry.getKey()).trim();
                    if (this.excludedFeatures.contains(featureName) || entry.getValue() == null || entry.getValue() instanceof Collection && ((Collection)entry.getValue()).isEmpty()) continue;
                    pokh.createLitStat(instanceURI, GATE_URI + featureName, entry.getValue().toString());
                    continue;
                }
                this.log.warn((Object)("Unable to create feature from entry '" + entry + "' on gate annotation type '" + annotGate.getType() + "'."));
            }
        }
        if (this.addIds) {
            pokh.createLitStat(instanceURI, NODE_ID, annotGate.getId().toString());
            pokh.createLitStat(instanceURI, START_NODE_ID, annotGate.getStartNode().getId().toString());
            pokh.createLitStat(instanceURI, END_NODE_ID, annotGate.getEndNode().getId().toString());
        }
    }
}

