/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.gate;

import java.io.File;
import java.util.List;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.service.gate.Configuration;
import org.ow2.weblab.service.gate.WebLabExceptions;
import org.weblab_project.core.helper.PoKHelper;
import org.weblab_project.core.helper.RDFHelperFactory;
import org.weblab_project.core.model.PieceOfKnowledge;
import org.weblab_project.services.configurable.Configurable;
import org.weblab_project.services.configurable.ConfigureException;
import org.weblab_project.services.configurable.ResetConfigurationException;
import org.weblab_project.services.configurable.types.ConfigureArgs;
import org.weblab_project.services.configurable.types.ConfigureReturn;
import org.weblab_project.services.configurable.types.ResetConfigurationArgs;
import org.weblab_project.services.configurable.types.ResetConfigurationReturn;

@WebService(endpointInterface="org.weblab_project.services.configurable.Configurable")
public class GateConfiguratorService
implements Configurable {
    public static String DEFAULT_SERVICE_URI = "http://weblab-project.org/webservices/gateservice";
    public static final String GAPP_FILE_PATH_PROPERTY = "http://weblab-project.org/core/model/property/processing/gate/gappFilePath";
    private String serviceURI;
    private final Log log;

    public GateConfiguratorService() {
        this(DEFAULT_SERVICE_URI);
    }

    public GateConfiguratorService(String serviceURI) {
        this.serviceURI = serviceURI;
        this.log = LogFactory.getLog(this.getClass());
    }

    public ConfigureReturn configure(ConfigureArgs args) throws ConfigureException {
        this.log.info((Object)"Configure method called.");
        PoKHelper helper = this.checkArgs(args);
        List gappFilePaths = helper.getLitsOnPredSubj(this.serviceURI, GAPP_FILE_PATH_PROPERTY);
        if (gappFilePaths.isEmpty()) {
            throw new ConfigureException("PieceOfKnowledge of used for configuration does not contains required statement: (S,P,O) = ('" + this.serviceURI + "', '" + GAPP_FILE_PATH_PROPERTY + "', PathToGappFile)", WebLabExceptions.E1.wle);
        }
        String gappFilePath = (String)gappFilePaths.get(0);
        if (gappFilePaths.size() > 1) {
            this.log.warn((Object)("More than one statement (S,P,O) = ('" + this.serviceURI + "', '" + GAPP_FILE_PATH_PROPERTY + "', PathToGappFile) found in configuration pok."));
        }
        this.checkFile(gappFilePath);
        Configuration.getInstance().configure(args.getUsageContext().getUri(), gappFilePath);
        this.log.info((Object)("GappFile affected : " + gappFilePath));
        return new ConfigureReturn();
    }

    private void checkFile(String gappFilePath) throws ConfigureException {
        File file = new File(gappFilePath);
        if (!file.exists()) {
            throw new ConfigureException("GappFile '" + file.getAbsolutePath() + "' does not exists.", WebLabExceptions.E2.wle);
        }
        if (!file.isFile()) {
            throw new ConfigureException("GappFile '" + file.getAbsolutePath() + "' is not a file.", WebLabExceptions.E2.wle);
        }
        if (!file.canRead()) {
            throw new ConfigureException("GappFile '" + file.getAbsolutePath() + "' cannot be read.", WebLabExceptions.E2.wle);
        }
    }

    private PoKHelper checkArgs(ConfigureArgs args) throws ConfigureException {
        if (args == null) {
            throw new ConfigureException("ConfigureArgs was null", WebLabExceptions.E1.wle);
        }
        if (args.getUsageContext() == null) {
            throw new ConfigureException("UsageContext was null", WebLabExceptions.E1.wle);
        }
        if (args.getConfiguration() == null) {
            throw new ConfigureException("Configuration was null", WebLabExceptions.E1.wle);
        }
        if (args.getUsageContext().getUri() == null) {
            throw new ConfigureException("URI of UsageContext was null", WebLabExceptions.E1.wle);
        }
        return RDFHelperFactory.getPoKHelper((PieceOfKnowledge)args.getConfiguration());
    }

    public ResetConfigurationReturn resetConfiguration(ResetConfigurationArgs args) throws ResetConfigurationException {
        this.log.info((Object)"ResetConfiguration method called.");
        if (args == null) {
            throw new ResetConfigurationException("ResetConfigurationArgs was null", WebLabExceptions.E1.wle);
        }
        if (args.getUsageContext() == null || args.getUsageContext().getUri() == null) {
            this.log.info((Object)"UsageContext was either null or without URI. Clear the whole configuration.");
            Configuration.getInstance().resetConfiguration();
        }
        Configuration.getInstance().resetConfiguration(args.getUsageContext().getUri());
        this.log.info((Object)"Configuration reset.");
        return new ResetConfigurationReturn();
    }
}

