/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.gate;

import gate.Corpus;
import gate.CorpusController;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.util.GateException;
import gate.util.persistence.PersistenceManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.jws.WebService;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.util.ResourceUtil;
import org.ow2.weblab.core.helper.RDFHelperFactory;
import org.ow2.weblab.core.helper.ResourceHelper;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.Text;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.analyser.ProcessArgs;
import org.ow2.weblab.core.services.analyser.ProcessReturn;
import org.ow2.weblab.service.gate.Configuration;
import org.ow2.weblab.service.gate.converter.GateConverter;
import org.ow2.weblab.service.gate.converter.GateToWebLab;
import org.springframework.core.io.ClassPathResource;

@WebService(endpointInterface="org.ow2.weblab.core.services.Analyser")
public class GateService
implements Analyser {
    private static final String UNKNOWN = "unknown";
    private static final String GATE_HOME_DIR = "gate";
    private static final String GATE_USER_FILE = "gate.xml";
    private static final String GATE_PLUGINS_DIR = "plugins";
    private static final String DEFAULT_GAPP_FILE = "default.gapp";
    private static final String GATE_LANGUAGE_FEATURE = "language";
    private static boolean INITIALISED = false;
    private final File defaultGappFile;
    private final GateConverter converter;

    public GateService() throws IOException, WebLabCheckedException {
        this(new ClassPathResource(DEFAULT_GAPP_FILE).getFile());
    }

    public GateService(File defaultGappFile) throws IOException, WebLabCheckedException {
        this(defaultGappFile, new File(new ClassPathResource(GATE_HOME_DIR).getFile(), GATE_PLUGINS_DIR));
    }

    public GateService(File defaultGappFile, File pluginsPath) throws IOException, WebLabCheckedException {
        this(defaultGappFile, pluginsPath, new GateToWebLab());
    }

    public GateService(File defaultGappFile, File pluginsPath, GateConverter converter) throws IOException, WebLabCheckedException {
        if (defaultGappFile != null) {
            if (!defaultGappFile.exists()) {
                LogFactory.getLog(this.getClass()).warn((Object)("defaultGappFile " + defaultGappFile.getPath() + " does not exist."));
                throw new IOException("defaultGappFile " + defaultGappFile.getPath() + " does not exist.");
            }
            if (!defaultGappFile.isFile()) {
                LogFactory.getLog(this.getClass()).warn((Object)("defaultGappFile " + defaultGappFile.getPath() + " is not a file."));
                throw new IOException("defaultGappFile " + defaultGappFile.getPath() + " is not a file.");
            }
            if (!defaultGappFile.canRead()) {
                LogFactory.getLog(this.getClass()).warn((Object)("defaultGappFile " + defaultGappFile.getPath() + " is not readable."));
                throw new IOException("defaultGappFile " + defaultGappFile.getPath() + " is not readable.");
            }
        }
        this.defaultGappFile = defaultGappFile;
        if (converter == null) {
            throw new WebLabCheckedException("GateConverter class was null.");
        }
        this.converter = converter;
        this.initGate(pluginsPath);
        LogFactory.getLog(this.getClass()).info((Object)"Gate Service successully initialised.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessReturn process(ProcessArgs args) throws UnexpectedException, InvalidParameterException, InsufficientResourcesException {
        CorpusController controller;
        Corpus corpusGate;
        LogFactory.getLog(this.getClass()).debug((Object)"Early starting of Gate Analyser");
        List<Text> texts = this.checkParameters(args);
        if (texts.isEmpty()) {
            LogFactory.getLog(this.getClass()).warn((Object)("No text content found in resource '" + args.getResource().getUri() + "'. Nothing done."));
            ProcessReturn theRet = new ProcessReturn();
            theRet.setResource(args.getResource());
            return theRet;
        }
        LogFactory.getLog(this.getClass()).info((Object)("Starting the processing of resource '" + args.getResource().getUri() + "' with Gate."));
        try {
            corpusGate = Factory.newCorpus((String)(args.getResource().getUri() + " " + System.nanoTime()));
        }
        catch (ResourceInstantiationException rie) {
            throw new UnexpectedException("Unable to instanciate new Corpus.", "Unable to instanciate new Corpus.");
        }
        ResourceHelper helper = RDFHelperFactory.getResourceHelper((Resource)args.getResource());
        String docDefaultLanguage = this.getLanguage(helper, args.getResource().getUri());
        HashMap<Document, Text> gateDocsAndText = new HashMap<Document, Text>();
        for (Text text : texts) {
            Document docGate;
            LogFactory.getLog(this.getClass()).debug((Object)("Text section to process by GateAnalyserComponent: " + text.getUri()));
            LogFactory.getLog(this.getClass()).debug((Object)("Number of segments before GateAnalyserComponent: " + text.getSegment().size()));
            try {
                docGate = Factory.newDocument((String)text.getContent());
            }
            catch (ResourceInstantiationException rie) {
                LogFactory.getLog(this.getClass()).warn((Object)("Unable to create a new Gate Document for text '" + text.getUri() + ". Skipping it."), (Throwable)rie);
                continue;
            }
            String language = this.getLanguage(helper, text.getUri(), docDefaultLanguage);
            if (language != null) {
                docGate.getFeatures().put((Object)GATE_LANGUAGE_FEATURE, (Object)language);
            }
            this.addGateDocumentToCorpus(corpusGate, docGate);
            gateDocsAndText.put(docGate, text);
        }
        texts.clear();
        if (corpusGate.isEmpty()) {
            Factory.deleteResource((gate.Resource)corpusGate);
            UnexpectedException ue = new UnexpectedException("Unable to instanciate Gate documents for each text section of resource " + args.getResource().getUri() + ".", "Unable to instanciate Gate documents for each text section of resource " + args.getResource().getUri() + ".");
            LogFactory.getLog(this.getClass()).error((Object)ue);
            throw ue;
        }
        try {
            controller = this.getController(args.getUsageContext());
        }
        catch (InsufficientResourcesException ire) {
            Factory.deleteResource((gate.Resource)corpusGate);
            throw ire;
        }
        catch (UnexpectedException ue) {
            Factory.deleteResource((gate.Resource)corpusGate);
            throw ue;
        }
        CorpusController ue = controller;
        synchronized (ue) {
            controller.setCorpus(corpusGate);
            try {
                controller.execute();
            }
            catch (ExecutionException ee) {
                Factory.deleteResource((gate.Resource)corpusGate);
                LogFactory.getLog(this.getClass()).error((Object)("ExecutionException on the controller. UsageContext was '" + args.getUsageContext() + "'. Resource was '" + args.getResource() + "'."), (Throwable)ee);
                throw new UnexpectedException("Unable to process pipeline of corpus.", "Unable to process pipeline of corpus.", (Throwable)ee);
            }
        }
        LogFactory.getLog(this.getClass()).info((Object)("Answer received from Gate. Starting annotation convertion for Resource '" + args.getResource().getUri() + "'."));
        this.converter.convertInformation(corpusGate, args.getResource(), gateDocsAndText);
        ProcessReturn theRet = new ProcessReturn();
        theRet.setResource(args.getResource());
        LogFactory.getLog(this.getClass()).info((Object)("Resource '" + args.getResource().getUri() + "' successfully processed with Gate Analyser"));
        return theRet;
    }

    private synchronized CorpusController getController(String uc) throws InsufficientResourcesException, UnexpectedException {
        String usageContext = uc == null ? "" : uc;
        CorpusController controller = Configuration.getInstance().getController(usageContext);
        if (controller != null) {
            return controller;
        }
        File gappFile = this.getGappFile(usageContext);
        try {
            controller = (CorpusController)PersistenceManager.loadObjectFromFile((File)gappFile);
        }
        catch (IOException ioe) {
            throw new InsufficientResourcesException("Unable to load gapp file " + gappFile + ".", "Unable to load gapp file " + gappFile + ".", (Throwable)ioe);
        }
        catch (PersistenceException pe) {
            throw new UnexpectedException("Unable to load gapp file " + gappFile + ".", "Unable to load gapp file " + gappFile + ".", (Throwable)pe);
        }
        catch (ResourceInstantiationException rie) {
            throw new UnexpectedException("Unable to load gapp file " + gappFile + ".", "Unable to load gapp file " + gappFile + ".", (Throwable)rie);
        }
        Configuration.getInstance().setController(usageContext, controller);
        return controller;
    }

    private String getLanguage(ResourceHelper helper, String uri) {
        return this.getLanguage(helper, uri, null);
    }

    private String getLanguage(ResourceHelper helper, String uri, String defaultValue) {
        List languages = helper.getLitsOnPredSubj(uri, "http://purl.org/dc/elements/1.1/language");
        String language = languages.isEmpty() || ((String)languages.get(0)).equalsIgnoreCase(UNKNOWN) ? defaultValue : ((String)languages.get(0)).toLowerCase();
        return language;
    }

    private File getGappFile(String usageContext) {
        String gappFilePath = Configuration.getInstance().getGappFilePath(usageContext);
        File gappFile = gappFilePath != null ? new File(gappFilePath) : this.defaultGappFile;
        return gappFile;
    }

    private void addGateDocumentToCorpus(Corpus corpusGate, Document docGate) {
        corpusGate.add((Object)docGate);
    }

    private synchronized void initGate(File pluginsdir) throws IOException, WebLabCheckedException {
        if (!INITIALISED) {
            if (!pluginsdir.exists()) {
                LogFactory.getLog(this.getClass()).warn((Object)("pluginsdir " + pluginsdir.getPath() + " does not exist."));
                throw new IOException("pluginsdir " + pluginsdir.getPath() + " does not exist.");
            }
            if (!pluginsdir.isDirectory()) {
                LogFactory.getLog(this.getClass()).warn((Object)("pluginsdir " + pluginsdir.getPath() + " is not a directory."));
                throw new IOException("pluginsdir " + pluginsdir.getPath() + " is not a file.");
            }
            if (!pluginsdir.canRead()) {
                LogFactory.getLog(this.getClass()).warn((Object)("pluginsdir " + pluginsdir.getPath() + " is not readable."));
                throw new IOException("pluginsdir " + pluginsdir.getPath() + " is not readable.");
            }
            File gateHome = new ClassPathResource(GATE_HOME_DIR).getFile();
            if (!gateHome.exists()) {
                LogFactory.getLog(this.getClass()).warn((Object)("gateHome " + gateHome.getPath() + " does not exist."));
                throw new IOException("gateHome " + gateHome.getPath() + " does not exist.");
            }
            if (!gateHome.isDirectory()) {
                LogFactory.getLog(this.getClass()).warn((Object)("gateHome " + gateHome.getPath() + " is not a directory."));
                throw new IOException("gateHome " + gateHome.getPath() + " is not a file.");
            }
            if (!gateHome.canRead()) {
                LogFactory.getLog(this.getClass()).warn((Object)("gateHome " + gateHome.getPath() + " is not readable."));
                throw new IOException("gateHome " + gateHome.getPath() + " is not readable.");
            }
            LogFactory.getLog(this.getClass()).debug((Object)("Here is the path of your application => " + gateHome.getAbsolutePath()));
            Gate.setGateHome((File)gateHome);
            Gate.setUserConfigFile((File)new File(gateHome, GATE_USER_FILE));
            Gate.setPluginsHome((File)pluginsdir);
            Gate.setSiteConfigFile((File)new File(gateHome, GATE_USER_FILE));
            try {
                Gate.init();
            }
            catch (GateException ge) {
                LogFactory.getLog(this.getClass()).warn((Object)"Error when initialising Gate.", (Throwable)ge);
                throw new WebLabCheckedException("Unable to find initialise Gate.", (Throwable)ge);
            }
            INITIALISED = true;
        }
    }

    protected List<Text> checkParameters(ProcessArgs args) throws InvalidParameterException {
        List<Text> texts;
        if (args == null) {
            throw new InvalidParameterException("ProcessArgs was null.", "ProcessArgs was null.");
        }
        Resource res = args.getResource();
        if (res == null) {
            throw new InvalidParameterException("Resource in ProcessArg was null.", "Resource in ProcessArg was null.");
        }
        if (!(res instanceof MediaUnit)) {
            throw new InvalidParameterException("This service only process MediaUnit; Resource was a: " + res.getClass().getSimpleName() + ".", "This service only process MediaUnit; Resource was a: " + res.getClass().getSimpleName() + ".");
        }
        if (res instanceof Text) {
            texts = new LinkedList<Text>();
            texts.add((Text)res);
        } else {
            texts = ResourceUtil.getSelectedSubResources((Resource)args.getResource(), Text.class);
        }
        ListIterator textIt = texts.listIterator();
        while (textIt.hasNext()) {
            Text text = (Text)textIt.next();
            if (text.getContent() != null) continue;
            textIt.remove();
        }
        return texts;
    }
}

