/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.exposer;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Map;
import javax.jws.WebService;
import org.apache.commons.logging.LogFactory;
import org.weblab_project.core.factory.AnnotationFactory;
import org.weblab_project.core.helper.PoKHelper;
import org.weblab_project.core.helper.RDFHelperFactory;
import org.weblab_project.core.helper.ResourceHelper;
import org.weblab_project.core.model.Annotation;
import org.weblab_project.core.model.Document;
import org.weblab_project.core.model.PieceOfKnowledge;
import org.weblab_project.core.model.Resource;
import org.weblab_project.core.properties.PropertiesLoader;
import org.weblab_project.services.analyser.Analyser;
import org.weblab_project.services.analyser.ProcessException;
import org.weblab_project.services.analyser.types.ProcessArgs;
import org.weblab_project.services.analyser.types.ProcessReturn;
import org.weblab_project.services.exception.WebLabException;

/*
 * Exception performing whole class analysis ignored.
 */
@WebService(endpointInterface="org.weblab_project.services.analyser.Analyser")
public class LocalFileExposer
implements Analyser {
    protected final String sourceUri;
    protected final boolean sourceIsResource;
    protected final String exposedAsUri;
    protected final int nbStartCharToReplace;
    protected final String byString;
    protected final boolean annotateAsUri;
    protected final boolean urlEncodeBetweenSlashes;
    protected final String urlEncoding;
    protected final String replacementForSpace;
    public static final String CONFIG_FILE = "local-file-exposer.config";

    public LocalFileExposer() {
        Map props = PropertiesLoader.loadProperties((String)"local-file-exposer.config");
        if (props.containsKey("sourceUri")) {
            this.sourceUri = (String)props.get("sourceUri");
        } else {
            LogFactory.getLog(this.getClass()).info((Object)"No sourceUri loaded from file: local-file-exposer.config. http://purl.org/dc/elements/1.1/source used instead.");
            this.sourceUri = "http://purl.org/dc/elements/1.1/source";
        }
        if (props.containsKey("sourceIsResource")) {
            this.sourceIsResource = Boolean.parseBoolean((String)props.get("sourceIsResource"));
        } else {
            LogFactory.getLog(this.getClass()).info((Object)"No sourceIsResource loaded from file: local-file-exposer.config. false used instead.");
            this.sourceIsResource = false;
        }
        if (props.containsKey("exposedAsUri")) {
            this.exposedAsUri = (String)props.get("exposedAsUri");
        } else {
            LogFactory.getLog(this.getClass()).info((Object)"No exposedAsUri loaded from file: local-file-exposer.config. http://weblab-project.org/core/model/property/processing/isExposedAs used instead.");
            this.exposedAsUri = "http://weblab-project.org/core/model/property/processing/isExposedAs";
        }
        if (props.containsKey("nbStartCharToReplace")) {
            int value = 0;
            try {
                value = Integer.parseInt((String)props.get("nbStartCharToReplace"));
            }
            catch (NumberFormatException nfe) {
                LogFactory.getLog(this.getClass()).warn((Object)"nbStartCharToReplace not loaded from file: local-file-exposer.config. 0 used instead.", (Throwable)nfe);
            }
            this.nbStartCharToReplace = value;
        } else {
            LogFactory.getLog(this.getClass()).info((Object)"No nbStartCharToReplace loaded from file: local-file-exposer.config. 0 used instead.");
            this.nbStartCharToReplace = 0;
        }
        if (props.containsKey("byString")) {
            this.byString = (String)props.get("byString");
        } else {
            LogFactory.getLog(this.getClass()).info((Object)"No byString loaded from file: local-file-exposer.config. \"\" used instead.");
            this.byString = "";
        }
        if (props.containsKey("annotateAsUri")) {
            this.annotateAsUri = Boolean.parseBoolean((String)props.get("annotateAsUri"));
        } else {
            LogFactory.getLog(this.getClass()).info((Object)"No annotateAsUri loaded from file: local-file-exposer.config. false used instead.");
            this.annotateAsUri = false;
        }
        if (props.containsKey("urlEncodeBetweenSlashes")) {
            this.urlEncodeBetweenSlashes = Boolean.parseBoolean((String)props.get("urlEncodeBetweenSlashes"));
        } else {
            LogFactory.getLog(this.getClass()).info((Object)"No urlEncodeBetweenSlashes loaded from file: local-file-exposer.config. true used instead.");
            this.urlEncodeBetweenSlashes = true;
        }
        if (props.containsKey("urlEncoding")) {
            this.urlEncoding = (String)props.get("urlEncoding");
        } else {
            LogFactory.getLog(this.getClass()).info((Object)"No urlEncoding loaded from file: local-file-exposer.config. ISO-8859-1 used instead.");
            this.urlEncoding = "ISO-8859-1";
        }
        if (props.containsKey("replacementForSpace")) {
            this.replacementForSpace = (String)props.get("replacementForSpace");
        } else {
            LogFactory.getLog(this.getClass()).info((Object)"No replacementForSpace loaded from file: local-file-exposer.config. %20 used instead.");
            this.replacementForSpace = "%20";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProcessReturn process(ProcessArgs args) throws ProcessException {
        String tempSource;
        Document doc = LocalFileExposer.checkArgs((ProcessArgs)args);
        ResourceHelper rh = RDFHelperFactory.getResourceHelper((Resource)doc);
        HashSet sources = this.sourceIsResource ? new HashSet(rh.getRessOnPredSubj(doc.getUri(), this.sourceUri)) : new HashSet(rh.getLitsOnPredSubj(doc.getUri(), this.sourceUri));
        if (sources.isEmpty()) {
            LogFactory.getLog(this.getClass()).warn((Object)("No '" + this.sourceUri + "' property found in resource '" + doc.getUri() + "'. Nothing is done."));
            ProcessReturn pr = new ProcessReturn();
            pr.setResource((Resource)doc);
            return pr;
        }
        String originalSource = (String)sources.iterator().next();
        if (sources.size() > 1) {
            LogFactory.getLog(this.getClass()).warn((Object)("More than one value found for property '" + this.sourceUri + "' in resource '" + doc.getUri() + "'."));
            LogFactory.getLog(this.getClass()).debug((Object)("Values found were '" + sources + "'."));
            LogFactory.getLog(this.getClass()).debug((Object)("'" + originalSource + "' will be used."));
        }
        StringBuilder finalSource = new StringBuilder();
        if (this.nbStartCharToReplace > 1) {
            if (originalSource.length() <= this.nbStartCharToReplace) {
                LogFactory.getLog(this.getClass()).warn((Object)("Source found (" + originalSource + ") is smaller than the number of character to replace (" + String.valueOf(this.nbStartCharToReplace) + "). Nothing is done."));
                ProcessReturn pr = new ProcessReturn();
                pr.setResource((Resource)doc);
                return pr;
            }
            finalSource.append(this.byString);
            tempSource = originalSource.substring(this.nbStartCharToReplace);
        } else {
            LogFactory.getLog(this.getClass()).debug((Object)"nbStartCharToReplace is smaller that one; no replacement is done.");
            tempSource = originalSource;
        }
        tempSource = tempSource.replace('\\', '/');
        if (this.urlEncodeBetweenSlashes) {
            try {
                String[] splitted = tempSource.split("/");
                for (int i = 0; i < splitted.length; ++i) {
                    finalSource.append("/");
                    finalSource.append(URLEncoder.encode(splitted[i], this.urlEncoding));
                }
            }
            catch (UnsupportedEncodingException uee) {
                LogFactory.getLog(this.getClass()).fatal((Object)uee);
                WebLabException wle = new WebLabException();
                wle.setErrorId("E0");
                wle.setErrorMessage("Unexpected error.");
                throw new ProcessException("Encoding '" + this.urlEncoding + "' is not supported.", wle, (Throwable)uee);
            }
        }
        String exposedAs = finalSource.toString().replace("+", this.replacementForSpace);
        Annotation annot = AnnotationFactory.createAndLinkAnnotation((Resource)doc);
        PoKHelper pokH = RDFHelperFactory.getPoKHelper((PieceOfKnowledge)annot);
        if (this.annotateAsUri) {
            pokH.createResStat(doc.getUri(), this.exposedAsUri, exposedAs);
        } else {
            pokH.createLitStat(doc.getUri(), this.exposedAsUri, exposedAs);
        }
        ProcessReturn pr = new ProcessReturn();
        pr.setResource((Resource)doc);
        return pr;
    }

    private static Document checkArgs(ProcessArgs args) throws ProcessException {
        WebLabException wle = new WebLabException();
        wle.setErrorId("E1");
        wle.setErrorMessage("Invalid parameter.");
        if (args == null) {
            throw new ProcessException("ProcessArgs was null", wle);
        }
        if (args.getResource() == null) {
            throw new ProcessException("Resource was null", wle);
        }
        if (!(args.getResource() instanceof Document)) {
            throw new ProcessException("Resource was not a Document but a: " + args.getResource().getClass().getName(), wle);
        }
        if (args.getResource().getAnnotation().isEmpty()) {
            throw new ProcessException("Document does not contains any Annotation.", wle);
        }
        return (Document)args.getResource();
    }
}

