/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.language;

import de.spieleck.app.cngram.NGram;
import de.spieleck.app.cngram.NGramMetric;
import de.spieleck.app.cngram.NGramProfile;
import de.spieleck.app.cngram.NGramProfileImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ow2.weblab.service.language.NGramProfilesPatched;

/*
 * Exception performing whole class analysis ignored.
 */
public class NGramProfilesPatched {
    public static final String NOLANGNAME = "--";
    public static final char END_CHAR = '\u0000';
    public static final DecimalFormat DF = new DecimalFormat("+0.00;-0.00");
    public static final double LOWSTATSAFETY = 0.5;
    List<NGramProfile> profiles = null;
    private HashSet<NGram> allNGrams = new HashSet(10000);
    private int firstNGrams;
    private int maxLen = -1;
    Trie myTrie = null;
    float[][] vals;
    private int mode;

    public NGramProfilesPatched() throws IOException {
        this(1);
    }

    public NGramProfilesPatched(int mode) throws IOException {
        InputStream ip = NGramProfile.class.getResourceAsStream("profiles.lst");
        BufferedReader br = new BufferedReader(new InputStreamReader(ip));
        this.mode = mode;
        this.init(br);
    }

    public NGramProfilesPatched(BufferedReader br) throws IOException {
        this.init(br);
    }

    private void init(BufferedReader br) throws IOException {
        String line;
        this.profiles = new ArrayList();
        this.firstNGrams = 0;
        while ((line = br.readLine()) != null) {
            if (line.charAt(0) == '#') continue;
            InputStream is = NGramProfile.class.getResourceAsStream(line + "." + "ngp");
            NGramProfileImpl np = new NGramProfileImpl(line);
            np.load(is);
            this.profiles.add(np);
            Iterator iter = np.getSorted();
            while (iter.hasNext()) {
                NGram ng = (NGram)iter.next();
                if (ng.length() > this.maxLen) {
                    this.maxLen = ng.length();
                }
                ++this.firstNGrams;
                this.allNGrams.add(ng);
            }
        }
        this.myTrie = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ranker getRanker() {
        if (this.myTrie == null) {
            List list = this.profiles;
            synchronized (list) {
                if (this.myTrie == null) {
                    Object[] ngs = new String[this.allNGrams.size()];
                    Iterator it = this.allNGrams.iterator();
                    int j = 0;
                    while (it.hasNext()) {
                        NGram ng = (NGram)it.next();
                        ngs[j++] = NGramProfilesPatched.reverse((CharSequence)ng);
                    }
                    Arrays.sort(ngs);
                    String[] ng1 = new String[this.allNGrams.size()];
                    for (int i = 0; i < ngs.length; ++i) {
                        ng1[i] = NGramProfilesPatched.reverse((CharSequence)ngs[i]);
                    }
                    this.myTrie = NGramProfilesPatched.createTrie((String[])ngs, (int)0, (int)0, (int)ngs.length);
                    this.vals = new float[ngs.length][this.profiles.size()];
                    int[] lengthes = new int[ngs.length];
                    for (int k = 0; k < this.profiles.size(); ++k) {
                        int ngl;
                        NGram ng;
                        int i;
                        NGramProfile ngp = (NGramProfile)this.profiles.get(k);
                        double[] norm = new double[this.maxLen + 1];
                        int[] count = new int[this.maxLen + 1];
                        for (i = 0; i < ngs.length; ++i) {
                            ng = ngp.get((CharSequence)ng1[i]);
                            if (ng == null || !((double)ng.getCount() > 0.5)) continue;
                            lengthes[i] = ngl = ng.length();
                            double raw1 = (double)ng.getCount() - 0.5;
                            int n = ngl;
                            count[n] = count[n] + 1;
                            int n2 = ngl;
                            norm[n2] = norm[n2] + raw1;
                            this.vals[i][k] = (float)raw1;
                        }
                        i = 1;
                        while (i <= this.maxLen) {
                            int n = i;
                            norm[n] = norm[n] * ((1.0 + (double)count[i]) / (double)count[i]);
                            int n3 = i++;
                            norm[n3] = norm[n3] + 1.0;
                        }
                        for (i = 0; i < ngs.length; ++i) {
                            ng = ngp.get((CharSequence)ng1[i]);
                            if (ng == null || ng.getCount() <= 0) continue;
                            ngl = ng.length();
                            double trans = (double)this.vals[i][k] / norm[ngl];
                            this.vals[i][k] = (float)trans;
                        }
                    }
                    for (int i = 0; i < ngs.length; ++i) {
                        double sum = 0.0;
                        for (int k = 0; k < this.profiles.size(); ++k) {
                            double h = this.vals[i][k];
                            sum += h;
                        }
                        double av = sum / (double)this.profiles.size();
                        double n = this.modeTrans(av, ng1[i].length()) / av / 100.0 * -Math.log(av);
                        for (int k = 0; k < this.profiles.size(); ++k) {
                            this.vals[i][k] = (float)(((double)this.vals[i][k] - av) * n);
                        }
                    }
                }
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private double modeTrans(double x, int l) {
        switch (this.mode) {
            case 1: 
            case 10: {
                if (l == 1) {
                    return x;
                }
                double f = 1.0 / (double)(l + 1);
                return Math.pow(x / f, f);
            }
            case 9: {
                double f = 1.0 / (double)(l + 1);
                return Math.pow(x, f) / Math.sqrt(f);
            }
            case 8: {
                double f = 1.0 / (double)(l + 1);
                return Math.pow(x, f) / Math.sqrt(f);
            }
            case 7: {
                double f = 1.0 / (double)(l + 1);
                return Math.pow(x, f) / f;
            }
            case 6: {
                double f = 1.0 / (double)l;
                return Math.pow(x, f) / Math.sqrt(f);
            }
            case 5: {
                double f = 1.0 / (double)l;
                return Math.pow(x, f) / f;
            }
            case 3: {
                double f = 1.0 / (double)l;
                return Math.pow(x, f);
            }
            case 2: {
                double f = 1.0 / (double)l;
                return Math.pow(x / f, f);
            }
            case 4: {
                double f = 1.0 / (double)l;
                return Math.pow(x * f, f);
            }
        }
        return x;
    }

    public String getProfileName(int i) {
        if (i < 0 || i >= this.profiles.size()) {
            return "--";
        }
        return ((NGramProfile)this.profiles.get(i)).getName();
    }

    static boolean isSeparator(char ch) {
        return ch <= ' ' || Character.isWhitespace(ch) || Character.isDigit(ch) || ".!?:,;".indexOf(ch) >= 0;
    }

    private static String reverse(CharSequence seq) {
        StringBuilder sb = new StringBuilder(seq.length());
        for (int i = 0; i < seq.length(); ++i) {
            sb.insert(0, seq.charAt(i));
        }
        return sb.toString();
    }

    private static Trie createTrie(String[] array, int pos, int start, int end) {
        int goLeft;
        int goRight;
        if (start >= end) {
            return null;
        }
        int mid = (start + end) / 2;
        Trie nt = new Trie();
        nt.split = array[mid].charAt(pos);
        for (goRight = mid; goRight < end && NGramProfilesPatched.charAt((CharSequence)array[goRight], (int)pos) == nt.split; ++goRight) {
        }
        for (goLeft = mid; goLeft > start && NGramProfilesPatched.charAt((CharSequence)array[goLeft - 1], (int)pos) == nt.split; --goLeft) {
        }
        int goLeft2 = goLeft;
        if (array[goLeft].length() == pos + 1) {
            nt.id = goLeft;
            ++goLeft2;
        }
        nt.center = NGramProfilesPatched.createTrie((String[])array, (int)(pos + 1), (int)goLeft2, (int)goRight);
        nt.left = NGramProfilesPatched.createTrie((String[])array, (int)pos, (int)start, (int)goLeft);
        nt.right = NGramProfilesPatched.createTrie((String[])array, (int)pos, (int)goRight, (int)end);
        return nt;
    }

    public static final char charAt(CharSequence cs, int pos) {
        if (pos < cs.length()) {
            return cs.charAt(pos);
        }
        return '\u0000';
    }

    public RankResult rank(NGramMetric metric, NGramProfile profile) {
        this.profiles.iterator();
        double[] scores = new double[this.profiles.size()];
        for (int i = 0; i < this.profiles.size(); ++i) {
            scores[i] = metric.diff(profile, (NGramProfile)this.profiles.get(i));
        }
        return new SimpleRankResult(this, scores, false);
    }

    public int getProfileCount() {
        return this.profiles.size();
    }

    public Set<NGram> getAllNGrams() {
        return this.allNGrams;
    }

    public NGramProfilesPatched(File folder) throws IOException {
        this.init(folder);
    }

    protected void init(File folder) throws IOException {
        this.profiles = new ArrayList();
        this.firstNGrams = 0;
        for (File file : folder.listFiles()) {
            String name = file.getName();
            if (!name.endsWith(".ngp")) continue;
            NGramProfileImpl np = new NGramProfileImpl(name.replace(".ngp", ""));
            np.load((InputStream)new FileInputStream(file));
            this.profiles.add(np);
            Iterator iterator = np.getSorted();
            while (iterator.hasNext()) {
                NGram ng = (NGram)iterator.next();
                if (ng.length() > this.maxLen) {
                    this.maxLen = ng.length();
                }
                ++this.firstNGrams;
                this.allNGrams.add(ng);
            }
        }
        this.myTrie = null;
    }
}

