/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.language;

import de.spieleck.app.cngram.NGram;
import de.spieleck.app.cngram.NGramMetric;
import de.spieleck.app.cngram.NGramProfile;
import de.spieleck.app.cngram.NGramProfileImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class NGramProfilesPatched {
    public static final String NOLANGNAME = "--";
    public static final char END_CHAR = '\u0000';
    public static final DecimalFormat DF = new DecimalFormat("+0.00;-0.00");
    public static final double LOWSTATSAFETY = 0.5;
    List<NGramProfile> profiles = null;
    private HashSet<NGram> allNGrams = new HashSet(10000);
    private int firstNGrams;
    private int maxLen = -1;
    Trie myTrie = null;
    float[][] vals;
    private int mode;

    public NGramProfilesPatched() throws IOException {
        this(1);
    }

    public NGramProfilesPatched(int mode) throws IOException {
        InputStream ip = NGramProfile.class.getResourceAsStream("profiles.lst");
        BufferedReader br = new BufferedReader(new InputStreamReader(ip));
        this.mode = mode;
        this.init(br);
    }

    public NGramProfilesPatched(BufferedReader br) throws IOException {
        this.init(br);
    }

    private void init(BufferedReader br) throws IOException {
        String line;
        this.profiles = new ArrayList<NGramProfile>();
        this.firstNGrams = 0;
        while ((line = br.readLine()) != null) {
            if (line.charAt(0) == '#') continue;
            InputStream is = NGramProfile.class.getResourceAsStream(line + "." + "ngp");
            NGramProfileImpl np = new NGramProfileImpl(line);
            np.load(is);
            this.profiles.add((NGramProfile)np);
            Iterator iter = np.getSorted();
            while (iter.hasNext()) {
                NGram ng = (NGram)iter.next();
                if (ng.length() > this.maxLen) {
                    this.maxLen = ng.length();
                }
                ++this.firstNGrams;
                this.allNGrams.add(ng);
            }
        }
        this.myTrie = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ranker getRanker() {
        if (this.myTrie == null) {
            List<NGramProfile> list = this.profiles;
            synchronized (list) {
                if (this.myTrie == null) {
                    Object[] ngs = new String[this.allNGrams.size()];
                    Iterator<NGram> it = this.allNGrams.iterator();
                    int j = 0;
                    while (it.hasNext()) {
                        NGram ng = it.next();
                        ngs[j++] = NGramProfilesPatched.reverse((CharSequence)ng);
                    }
                    Arrays.sort(ngs);
                    String[] ng1 = new String[this.allNGrams.size()];
                    for (int i = 0; i < ngs.length; ++i) {
                        ng1[i] = NGramProfilesPatched.reverse((CharSequence)ngs[i]);
                    }
                    this.myTrie = NGramProfilesPatched.createTrie((String[])ngs, 0, 0, ngs.length);
                    this.vals = new float[ngs.length][this.profiles.size()];
                    int[] lengthes = new int[ngs.length];
                    for (int k = 0; k < this.profiles.size(); ++k) {
                        int ngl;
                        NGram ng;
                        int i;
                        NGramProfile ngp = this.profiles.get(k);
                        double[] norm = new double[this.maxLen + 1];
                        int[] count = new int[this.maxLen + 1];
                        for (i = 0; i < ngs.length; ++i) {
                            ng = ngp.get((CharSequence)ng1[i]);
                            if (ng == null || !((double)ng.getCount() > 0.5)) continue;
                            lengthes[i] = ngl = ng.length();
                            double raw1 = (double)ng.getCount() - 0.5;
                            int n = ngl;
                            count[n] = count[n] + 1;
                            int n2 = ngl;
                            norm[n2] = norm[n2] + raw1;
                            this.vals[i][k] = (float)raw1;
                        }
                        i = 1;
                        while (i <= this.maxLen) {
                            int n = i;
                            norm[n] = norm[n] * ((1.0 + (double)count[i]) / (double)count[i]);
                            int n3 = i++;
                            norm[n3] = norm[n3] + 1.0;
                        }
                        for (i = 0; i < ngs.length; ++i) {
                            ng = ngp.get((CharSequence)ng1[i]);
                            if (ng == null || ng.getCount() <= 0) continue;
                            ngl = ng.length();
                            double trans = (double)this.vals[i][k] / norm[ngl];
                            this.vals[i][k] = (float)trans;
                        }
                    }
                    for (int i = 0; i < ngs.length; ++i) {
                        double sum = 0.0;
                        for (int k = 0; k < this.profiles.size(); ++k) {
                            double h = this.vals[i][k];
                            sum += h;
                        }
                        double av = sum / (double)this.profiles.size();
                        double n = this.modeTrans(av, ng1[i].length()) / av / 100.0 * -Math.log(av);
                        for (int k = 0; k < this.profiles.size(); ++k) {
                            this.vals[i][k] = (float)(((double)this.vals[i][k] - av) * n);
                        }
                    }
                }
            }
        }
        return new Ranker(){
            private double[] score;
            private double[] rscore;
            private boolean flushed;
            {
                this.score = new double[NGramProfilesPatched.this.profiles.size() + 1];
                this.rscore = new double[NGramProfilesPatched.this.profiles.size() + 1];
                this.flushed = false;
                this.reset();
            }

            @Override
            public RankResult getRankResult() {
                int i;
                this.flush();
                double[] pscore = new double[NGramProfilesPatched.this.profiles.size()];
                double sum = 0.0;
                for (i = 0; i <= NGramProfilesPatched.this.profiles.size(); ++i) {
                    sum += this.rscore[i];
                }
                for (i = 0; i < NGramProfilesPatched.this.profiles.size(); ++i) {
                    pscore[i] = this.rscore[i] / sum;
                }
                return new SimpleRankResult(pscore, true);
            }

            @Override
            public void reset() {
                for (int i = 0; i < this.score.length; ++i) {
                    this.score[i] = 0.0;
                    this.rscore[i] = 0.0;
                }
                this.score[this.score.length - 1] = 0.0;
                this.rscore[this.score.length - 1] = 0.5;
            }

            @Override
            public void flush() {
                if (!this.flushed) {
                    this.flushed = true;
                    double maxValue = -1.0;
                    for (int i = 0; i < this.score.length; ++i) {
                        maxValue = Math.max(maxValue, this.score[i]);
                    }
                    double limit = maxValue / 2.0;
                    double f = 1.0 / (maxValue - limit);
                    int i = 0;
                    while (i < this.score.length) {
                        double delta = this.score[i] - limit;
                        if (delta > 0.0) {
                            int n = i;
                            this.rscore[n] = this.rscore[n] + delta * f;
                        }
                        int n = i++;
                        this.score[n] = this.score[n] / 2.0;
                    }
                }
            }

            @Override
            public void account(CharSequence seq, int pos) {
                Trie currentNode = NGramProfilesPatched.this.myTrie;
                int p2 = pos;
                while (currentNode != null) {
                    int ch;
                    if (p2 == -1) {
                        ch = 32;
                    } else {
                        ch = Character.toLowerCase(seq.charAt(p2));
                        if (NGramProfilesPatched.isSeparator((char)ch)) {
                            ch = 32;
                        }
                    }
                    Trie t2 = currentNode.subtree((char)ch);
                    if (t2 == null) break;
                    if (t2.id >= 0) {
                        this.flushed = false;
                        for (int i = 0; i < NGramProfilesPatched.this.profiles.size(); ++i) {
                            int n = i;
                            this.score[n] = this.score[n] + (double)NGramProfilesPatched.this.vals[t2.id][i];
                        }
                    }
                    if (p2-- == -1) break;
                    currentNode = t2.center;
                }
                char startChar = seq.charAt(pos);
                boolean startSep = NGramProfilesPatched.isSeparator(startChar);
                double max = 0.0;
                for (int i = 0; i < this.score.length; ++i) {
                    max = Math.max(max, this.score[i]);
                }
                if (startSep && max > 1.0) {
                    this.flush();
                }
            }

            @Override
            public void account(CharSequence seq) {
                for (int i = 0; i < seq.length(); ++i) {
                    this.account(seq, i);
                }
            }

            @Override
            public void account(Reader reader) throws IOException {
                String line;
                BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
                while ((line = br.readLine()) != null) {
                    this.account(line);
                }
            }
        };
    }

    private double modeTrans(double x, int l) {
        switch (this.mode) {
            case 1: 
            case 10: {
                if (l == 1) {
                    return x;
                }
                double f = 1.0 / (double)(l + 1);
                return Math.pow(x / f, f);
            }
            case 9: {
                double f = 1.0 / (double)(l + 1);
                return Math.pow(x, f) / Math.sqrt(f);
            }
            case 8: {
                double f = 1.0 / (double)(l + 1);
                return Math.pow(x, f) / Math.sqrt(f);
            }
            case 7: {
                double f = 1.0 / (double)(l + 1);
                return Math.pow(x, f) / f;
            }
            case 6: {
                double f = 1.0 / (double)l;
                return Math.pow(x, f) / Math.sqrt(f);
            }
            case 5: {
                double f = 1.0 / (double)l;
                return Math.pow(x, f) / f;
            }
            case 3: {
                double f = 1.0 / (double)l;
                return Math.pow(x, f);
            }
            case 2: {
                double f = 1.0 / (double)l;
                return Math.pow(x / f, f);
            }
            case 4: {
                double f = 1.0 / (double)l;
                return Math.pow(x * f, f);
            }
        }
        return x;
    }

    public String getProfileName(int i) {
        if (i < 0 || i >= this.profiles.size()) {
            return NOLANGNAME;
        }
        return this.profiles.get(i).getName();
    }

    static boolean isSeparator(char ch) {
        return ch <= ' ' || Character.isWhitespace(ch) || Character.isDigit(ch) || ".!?:,;".indexOf(ch) >= 0;
    }

    private static String reverse(CharSequence seq) {
        StringBuilder sb = new StringBuilder(seq.length());
        for (int i = 0; i < seq.length(); ++i) {
            sb.insert(0, seq.charAt(i));
        }
        return sb.toString();
    }

    private static Trie createTrie(String[] array, int pos, int start, int end) {
        int goLeft;
        int goRight;
        if (start >= end) {
            return null;
        }
        int mid = (start + end) / 2;
        Trie nt = new Trie();
        nt.split = array[mid].charAt(pos);
        for (goRight = mid; goRight < end && NGramProfilesPatched.charAt(array[goRight], pos) == nt.split; ++goRight) {
        }
        for (goLeft = mid; goLeft > start && NGramProfilesPatched.charAt(array[goLeft - 1], pos) == nt.split; --goLeft) {
        }
        int goLeft2 = goLeft;
        if (array[goLeft].length() == pos + 1) {
            nt.id = goLeft;
            ++goLeft2;
        }
        nt.center = NGramProfilesPatched.createTrie(array, pos + 1, goLeft2, goRight);
        nt.left = NGramProfilesPatched.createTrie(array, pos, start, goLeft);
        nt.right = NGramProfilesPatched.createTrie(array, pos, goRight, end);
        return nt;
    }

    public static final char charAt(CharSequence cs, int pos) {
        if (pos < cs.length()) {
            return cs.charAt(pos);
        }
        return '\u0000';
    }

    public RankResult rank(NGramMetric metric, NGramProfile profile) {
        this.profiles.iterator();
        double[] scores = new double[this.profiles.size()];
        for (int i = 0; i < this.profiles.size(); ++i) {
            scores[i] = metric.diff(profile, this.profiles.get(i));
        }
        return new SimpleRankResult(scores, false);
    }

    public int getProfileCount() {
        return this.profiles.size();
    }

    public Set<NGram> getAllNGrams() {
        return this.allNGrams;
    }

    public NGramProfilesPatched(File folder) throws IOException {
        this.init(folder);
    }

    protected void init(File folder) throws IOException {
        this.profiles = new ArrayList<NGramProfile>();
        this.firstNGrams = 0;
        for (File file : folder.listFiles()) {
            String name = file.getName();
            if (!name.endsWith(".ngp")) continue;
            NGramProfileImpl np = new NGramProfileImpl(name.replace(".ngp", ""));
            np.load((InputStream)new FileInputStream(file));
            this.profiles.add((NGramProfile)np);
            Iterator iterator = np.getSorted();
            while (iterator.hasNext()) {
                NGram ng = (NGram)iterator.next();
                if (ng.length() > this.maxLen) {
                    this.maxLen = ng.length();
                }
                ++this.firstNGrams;
                this.allNGrams.add(ng);
            }
        }
        this.myTrie = null;
    }

    public static interface Ranker {
        public RankResult getRankResult();

        public void reset();

        public void flush();

        public void account(CharSequence var1, int var2);

        public void account(CharSequence var1);

        public void account(Reader var1) throws IOException;
    }

    public static interface RankResult {
        public NGramProfilesPatched getProfiles();

        public int getLength();

        public double getScore(int var1);

        public String getName(int var1);
    }

    private class SimpleRankResult
    implements RankResult {
        private double[] scores;
        private NGramProfile[] profs;
        private double remain;

        public SimpleRankResult(double[] scorex, boolean inverse) {
            this.scores = new double[scorex.length];
            System.arraycopy(scorex, 0, this.scores, 0, scorex.length);
            this.profs = new NGramProfile[this.scores.length];
            this.remain = 1.0;
            for (int i = 0; i < this.scores.length; ++i) {
                NGramProfile prof = NGramProfilesPatched.this.profiles.get(i);
                double m = this.scores[i];
                this.remain -= m;
                int j = i;
                while (--j >= 0 && inverse ^ m < this.scores[j]) {
                    this.scores[j + 1] = this.scores[j];
                    this.profs[j + 1] = this.profs[j];
                }
                this.scores[j + 1] = m;
                this.profs[j + 1] = prof;
            }
        }

        @Override
        public NGramProfilesPatched getProfiles() {
            return NGramProfilesPatched.this;
        }

        @Override
        public double getScore(int pos) {
            if (pos == this.getLength()) {
                return this.remain;
            }
            int p = pos;
            if (p < 0) {
                p += this.getLength();
            }
            return this.scores[p];
        }

        @Override
        public String getName(int pos) {
            if (pos == this.getLength()) {
                return NGramProfilesPatched.NOLANGNAME;
            }
            int p = pos;
            if (p < 0) {
                p += this.getLength();
            }
            return this.profs[p].getName();
        }

        @Override
        public int getLength() {
            return this.profs.length;
        }
    }

    private static final class Trie {
        static int count = 0;
        char split;
        Trie left;
        Trie right;
        Trie center;
        int id = -1;

        public Trie() {
            ++count;
        }

        public Trie subtree(char c) {
            Trie current = this;
            do {
                if (c != current.split) continue;
                return current;
            } while ((current = c > current.split ? current.right : current.left) != null);
            return null;
        }
    }
}

