/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service;

import java.io.File;
import java.util.Map;
import javax.jws.WebService;
import org.apache.commons.codec.digest.DigestUtils;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.exception.WebLabUncheckedException;
import org.weblab_project.core.jaxb.WebLabMarshaler;
import org.weblab_project.core.model.Resource;
import org.weblab_project.core.properties.PropertiesLoader;
import org.weblab_project.services.exception.WebLabException;
import org.weblab_project.services.resourcecontainer.GetResourceException;
import org.weblab_project.services.resourcecontainer.ResourceContainer;
import org.weblab_project.services.resourcecontainer.SaveResourceException;
import org.weblab_project.services.resourcecontainer.types.GetResourceArgs;
import org.weblab_project.services.resourcecontainer.types.GetResourceReturn;
import org.weblab_project.services.resourcecontainer.types.SaveResourceArgs;
import org.weblab_project.services.resourcecontainer.types.SaveResourceReturn;

@WebService(endpointInterface="org.weblab_project.services.resourcecontainer.ResourceContainer")
public class SimpleRepo
implements ResourceContainer {
    public static final String PROPERTIES_FILE = "simple-repo.properties";
    public static final String REPO_PATH_PROPERTY = "path";
    private final File repoBase;
    private final WebLabMarshaler reader;
    private final WebLabMarshaler writer;

    public SimpleRepo() {
        Map props = PropertiesLoader.loadProperties((String)PROPERTIES_FILE);
        String path = (String)props.get(REPO_PATH_PROPERTY);
        if (path == null) {
            throw new WebLabUncheckedException("Property path not found or empty in file simple-repo.properties.");
        }
        this.repoBase = new File(path);
        this.repoBase.mkdirs();
        this.reader = new WebLabMarshaler();
        this.writer = new WebLabMarshaler();
    }

    public GetResourceReturn getResource(GetResourceArgs args) throws GetResourceException {
        String uri = this.checkGetResourceArgs(args);
        File file = this.uriToFile(uri);
        Resource res = this.readFile(file, uri);
        GetResourceReturn grr = new GetResourceReturn();
        grr.setResource(res);
        return grr;
    }

    public SaveResourceReturn saveResource(SaveResourceArgs args) throws SaveResourceException {
        Resource res = this.checkSaveResourceArgs(args);
        File file = this.uriToFile(res.getUri());
        this.writeFile(file, res);
        SaveResourceReturn srr = new SaveResourceReturn();
        srr.setResourceId(res.getUri());
        return srr;
    }

    private synchronized void writeFile(File file, Resource res) throws SaveResourceException {
        try {
            this.writer.marshalResource(res, file);
        }
        catch (WebLabCheckedException wlce) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E0");
            wle.setErrorMessage("Unexpected error.");
            throw new SaveResourceException("Error when marshalling the resource with URI '" + res.getUri() + "'.", wle, (Throwable)wlce);
        }
    }

    private Resource checkSaveResourceArgs(SaveResourceArgs args) throws SaveResourceException {
        if (args == null) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E1");
            wle.setErrorMessage("Invalid parameter.");
            throw new SaveResourceException("SaveResourceArgs was null", wle);
        }
        Resource res = args.getResource();
        if (res == null) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E1");
            wle.setErrorMessage("Invalid parameter.");
            throw new SaveResourceException("Resource in SaveResourceArgs was null", wle);
        }
        if (res.getUri() == null) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E1");
            wle.setErrorMessage("Invalid parameter.");
            throw new SaveResourceException("URI of the Resource in SaveResourceArgs was null", wle);
        }
        return res;
    }

    private synchronized Resource readFile(File file, String uri) throws GetResourceException {
        if (!file.exists()) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E1");
            wle.setErrorMessage("Invalid parameter.");
            throw new GetResourceException("No resource with '" + uri + "' as URI found.", wle);
        }
        try {
            return this.reader.unmarshal(file, Resource.class);
        }
        catch (WebLabCheckedException wlce) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E0");
            wle.setErrorMessage("Unexpected error.");
            throw new GetResourceException("Error when unmarshalling the file with URI '" + uri + "'.", wle, (Throwable)wlce);
        }
    }

    private File uriToFile(String uri) {
        String sha = DigestUtils.sha256Hex((String)uri);
        File folder = new File(this.repoBase, sha.substring(0, 1));
        folder.mkdirs();
        File file = new File(folder, sha + ".xml");
        return file;
    }

    private String checkGetResourceArgs(GetResourceArgs args) throws GetResourceException {
        if (args == null) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E1");
            wle.setErrorMessage("Invalid parameter.");
            throw new GetResourceException("GetResourceArgs was null", wle);
        }
        String uri = args.getResourceId();
        if (uri == null) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E1");
            wle.setErrorMessage("Invalid parameter.");
            throw new GetResourceException("ResourceId GetResourceArgs was null", wle);
        }
        return uri;
    }
}

