/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MoreLikeThisParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.CustomMoreLikeThisHandler;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.SolrPluginUtils;
import org.slf4j.Logger;

public class CustomMoreLikeThisHandler
extends RequestHandlerBase {
    private static final Pattern splitList = Pattern.compile(",| ");

    public void init(NamedList args) {
        super.init(args);
    }

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        Iterable streams;
        SolrParams params = req.getParams();
        SolrIndexSearcher searcher = req.getSearcher();
        Reader reader = null;
        String q = params.get("q");
        if ((q == null || q.trim().length() < 1) && (streams = req.getContentStreams()) != null) {
            Iterator iter = streams.iterator();
            if (iter.hasNext()) {
                reader = ((ContentStream)iter.next()).getReader();
            }
            if (iter.hasNext()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "MoreLikeThis does not support multiple ContentStreams");
            }
        }
        MoreLikeThisHelper mlt = new MoreLikeThisHelper(params, searcher);
        List filters = SolrPluginUtils.parseFilterQueries((SolrQueryRequest)req);
        MoreLikeThisParams.TermStyle termStyle = MoreLikeThisParams.TermStyle.get((String)params.get("mlt.interestingTerms"));
        ArrayList interesting = termStyle == MoreLikeThisParams.TermStyle.NONE ? null : new ArrayList(mlt.mlt.getMaxQueryTerms());
        String fl = params.get("fl");
        int flags = 0;
        if (fl != null) {
            flags |= SolrPluginUtils.setReturnFields((String)fl, (SolrQueryResponse)rsp);
        }
        int start = params.getInt("start", 0);
        int rows = params.getInt("rows", 10);
        DocListAndSet mltDocs = null;
        if (reader != null) {
            mltDocs = mlt.getMoreLikeThis(reader, start, rows, filters, interesting, flags);
        } else if (q != null) {
            DocIterator iterator;
            boolean includeMatch = params.getBool("mlt.match.include", true);
            int matchOffset = params.getInt("mlt.match.offset", 0);
            Query query = QueryParsing.parseQuery((String)q, (String)params.get("df"), (SolrParams)params, (IndexSchema)req.getSchema());
            DocList match = searcher.getDocList(query, null, null, matchOffset, 1, flags);
            if (includeMatch) {
                rsp.add("match", (Object)match);
            }
            if ((iterator = match.iterator()).hasNext()) {
                int id = iterator.nextDoc();
                mltDocs = mlt.getMoreLikeThis(id, start, rows, filters, interesting, flags);
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "MoreLikeThis requires either a query (?q=) or text to find similar documents.");
        }
        if (mltDocs == null) {
            mltDocs = new DocListAndSet();
        }
        rsp.add("response", (Object)mltDocs.docList);
        if (interesting != null) {
            if (termStyle == MoreLikeThisParams.TermStyle.DETAILS) {
                NamedList it = new NamedList();
                for (InterestingTerm t : interesting) {
                    it.add(t.term.toString(), (Object)Float.valueOf(t.boost));
                }
                rsp.add("interestingTerms", (Object)it);
            } else {
                ArrayList<String> it = new ArrayList<String>(interesting.size());
                for (InterestingTerm t : interesting) {
                    it.add(t.term.text());
                }
                rsp.add("interestingTerms", it);
            }
        }
        if (params.getBool("facet", false)) {
            if (mltDocs.docSet == null) {
                rsp.add("facet_counts", null);
            } else {
                SimpleFacets f = new SimpleFacets(req, mltDocs.docSet, params);
                rsp.add("facet_counts", (Object)f.getFacetCounts());
            }
        }
        try {
            NamedList dbg = SolrPluginUtils.doStandardDebug((SolrQueryRequest)req, (String)q, (Query)mlt.mltquery, (DocList)mltDocs.docList);
            if (null != dbg) {
                if (null != filters) {
                    dbg.add("filter_queries", (Object)req.getParams().getParams("fq"));
                    ArrayList<String> fqs = new ArrayList<String>(filters.size());
                    for (Query fq : filters) {
                        fqs.add(QueryParsing.toString((Query)fq, (IndexSchema)req.getSchema()));
                    }
                    dbg.add("parsed_filter_queries", fqs);
                }
                rsp.add("debug", (Object)dbg);
            }
        }
        catch (Exception e) {
            SolrException.logOnce((Logger)SolrCore.log, (String)"Exception during debug", (Throwable)e);
            rsp.add("exception_during_debug", (Object)SolrException.toStr((Throwable)e));
        }
    }

    public String getVersion() {
        return "$Revision: 801768 $";
    }

    public String getDescription() {
        return "Solr MoreLikeThis";
    }

    public String getSourceId() {
        return "$Id: CustomMoreLikeThisHandler.java 801768 2009-08-06 18:47:16Z yonik $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.4/src/java/org/apache/solr/handler/CustomMoreLikeThisHandler.java $";
    }

    public URL[] getDocs() {
        try {
            return new URL[]{new URL("http://wiki.apache.org/solr/MoreLikeThis")};
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    static /* synthetic */ Pattern access$000() {
        return splitList;
    }
}

