/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.duplicates;

import java.io.File;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceContext;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.update.processor.TextProfileSignature;
import org.ow2.weblab.services.indexer.impl.SolrIndexer;
import org.ow2.weblab.services.searcher.impl.SolrSearcher;
import org.ow2.weblab.services.solr.SolrComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.factory.AnnotationFactory;
import org.weblab_project.core.helper.PoKHelper;
import org.weblab_project.core.helper.RDFHelperFactory;
import org.weblab_project.core.model.Annotation;
import org.weblab_project.core.model.MediaUnit;
import org.weblab_project.core.model.PieceOfKnowledge;
import org.weblab_project.services.analyser.Analyser;
import org.weblab_project.services.analyser.ProcessException;
import org.weblab_project.services.analyser.types.ProcessArgs;
import org.weblab_project.services.analyser.types.ProcessReturn;
import org.weblab_project.services.exception.WebLabException;

/*
 * Exception performing whole class analysis ignored.
 */
@WebService(endpointInterface="org.weblab_project.services.analyser.Analyser")
public class DuplicatesDetectorService
implements Analyser {
    private static final Logger logger = LoggerFactory.getLogger(DuplicatesDetectorService.class);
    @Resource
    protected WebServiceContext wsContext;
    private SolrComponent comp;

    public ProcessReturn process(ProcessArgs args) throws ProcessException {
        MediaUnit unit = DuplicatesDetectorService.checkArgs((ProcessArgs)args);
        logger.info("Process method of DuplicatesDetectorService called for Document: " + unit.getUri());
        boolean docIsAlreadyPresent = false;
        this.comp = SolrComponent.getInstance();
        try {
            this.comp.open(this.getWebAppPath());
            String sigString = DuplicatesDetectorService.getFuzzyHashing((MediaUnit)unit);
            logger.info("Signature of doc to process: " + sigString);
            QueryResponse qr = this.comp.search("signature:" + sigString, 0, 1);
            if (qr.getResults() != null && qr.getResults().size() > 0) {
                for (SolrDocument hit : qr.getResults()) {
                    docIsAlreadyPresent = true;
                    logger.info("Duplicate document found: " + String.valueOf(hit.getFieldValue("id")));
                }
            } else {
                logger.info("No near duplicates found, add document to index.");
                this.comp.addDocument((org.weblab_project.core.model.Resource)unit);
                this.comp.flushIndexBuffer();
            }
            if (docIsAlreadyPresent) {
                logger.info("Document (" + unit.getUri() + ") is a duplicate.");
                Annotation annot = AnnotationFactory.createAndLinkAnnotation((org.weblab_project.core.model.Resource)unit);
                PoKHelper pokHlp = RDFHelperFactory.getPoKHelper((PieceOfKnowledge)annot);
                pokHlp.createLitStat(unit.getUri(), "http://weblab-project.org/core/model/property/processing/canBeIgnored", "true");
            } else {
                logger.info("Document (" + unit.getUri() + ") is a new document.");
            }
        }
        catch (WebLabCheckedException e) {
            WebLabException exp = new WebLabException();
            exp.setErrorId("E0");
            exp.setErrorMessage("Unexpected error");
            throw new ProcessException("Error when calling solr index.", exp, (Throwable)e);
        }
        ProcessReturn pr = new ProcessReturn();
        pr.setResource((org.weblab_project.core.model.Resource)unit);
        return pr;
    }

    private static String getFuzzyHashing(MediaUnit unit) {
        TextProfileSignature tps = new TextProfileSignature();
        tps.init(SolrParams.toSolrParams((NamedList)new NamedList()));
        tps.add("text");
        tps.add(SolrComponent.extractTextFromResource((org.weblab_project.core.model.Resource)unit));
        byte[] signature = tps.getSignature();
        char[] arr = new char[signature.length << 1];
        int i = 0;
        while (i < signature.length) {
            byte b = signature[i];
            int idx = i << 1;
            arr[idx] = StrUtils.HEX_DIGITS[b >> 4 & 0xF];
            arr[idx + 1] = StrUtils.HEX_DIGITS[b & 0xF];
            ++i;
        }
        return new String(arr);
    }

    private static MediaUnit checkArgs(ProcessArgs args) throws ProcessException {
        WebLabException wle = new WebLabException();
        wle.setErrorId("E1");
        wle.setErrorMessage("Invalid parameter");
        if (args == null) {
            LogFactory.getLog(SolrIndexer.class).error((Object)"IndexArgs was null.");
            throw new ProcessException("IndexArgs was null.", wle);
        }
        if (args.getResource() == null) {
            LogFactory.getLog(SolrIndexer.class).error((Object)"Args must contain a non-null Resource to index");
            throw new ProcessException("Args must contain a non-null Resource to index", wle);
        }
        if (!(args.getResource() instanceof MediaUnit)) {
            LogFactory.getLog(SolrIndexer.class).error((Object)"Resource to index as not a MediaUnit.");
            throw new ProcessException("Resource to index as not a MediaUnit.", wle);
        }
        return (MediaUnit)args.getResource();
    }

    private String getWebAppPath() throws WebLabCheckedException {
        String appPath = "./src/main/resources";
        if (this.wsContext != null) {
            ServletContext ctx = (ServletContext)this.wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
            appPath = ctx.getRealPath("WEB-INF/classes");
        } else {
            LogFactory.getLog(SolrSearcher.class).warn((Object)"Webservice context not available returning current local path as default web app path");
        }
        File f = new File(appPath);
        if (!f.exists()) {
            throw new WebLabCheckedException("Webapp path [" + appPath + "] does not exists...");
        }
        return appPath;
    }

    public WebServiceContext getWsContext() {
        return this.wsContext;
    }

    public void setWsContext(WebServiceContext wsContext) {
        this.wsContext = wsContext;
    }
}

