/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.searcher.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceContext;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.ow2.weblab.services.searcher.impl.SolrSearcherConfig;
import org.ow2.weblab.services.solr.SolrComponent;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.factory.ResourceFactory;
import org.weblab_project.core.helper.BeanHelper;
import org.weblab_project.core.model.PieceOfKnowledge;
import org.weblab_project.core.model.query.Query;
import org.weblab_project.core.model.query.ResultSet;
import org.weblab_project.core.model.query.StringQuery;
import org.weblab_project.core.util.PoKUtil;
import org.weblab_project.core.util.ResourceUtil;
import org.weblab_project.services.searcher.SearchException;
import org.weblab_project.services.searcher.Searcher;
import org.weblab_project.services.searcher.types.SearchArgs;
import org.weblab_project.services.searcher.types.SearchReturn;

@WebService(endpointInterface="org.weblab_project.services.searcher.Searcher")
public class FastSolrSearcher
implements Searcher {
    @Resource
    protected WebServiceContext wsContext;
    private static int resultsCpt = 0;
    private SolrSearcherConfig conf;
    private SolrComponent solrComponent;

    public FastSolrSearcher() {
        if (this.conf == null) {
            this.conf = (SolrSearcherConfig)BeanHelper.getInstance().getSpecificInstance("SearcherBean.xml", true).getBean("SearcherConfig", SolrSearcherConfig.class);
        }
        if (this.solrComponent == null) {
            this.solrComponent = SolrComponent.getInstance();
        }
    }

    public SearchReturn search(SearchArgs arg0) throws SearchException {
        Query q = arg0.getQuery();
        SearchReturn re = new SearchReturn();
        re.setResultSet(this.search(q, arg0.getOffset(), arg0.getLimit()));
        return re;
    }

    public ResultSet search(Query q, int offset, int limit) throws SearchException {
        StringQuery query = null;
        if (!(q instanceof StringQuery)) {
            throw new SearchException("This service " + this.getClass().getSimpleName() + " can only process " + StringQuery.class.getSimpleName() + " and not " + q.getClass().getSimpleName(), null);
        }
        query = (StringQuery)q;
        try {
            LogFactory.getLog(this.getClass()).debug((Object)("query request : " + query.getRequest()));
            LogFactory.getLog(this.getClass()).debug((Object)("Query input : " + ResourceUtil.saveToXMLString((org.weblab_project.core.model.Resource)query)));
        }
        catch (WebLabCheckedException e) {
            LogFactory.getLog(this.getClass()).debug((Object)"Error when logging query input", (Throwable)e);
        }
        int resultId = resultsCpt++;
        ResultSet results = (ResultSet)ResourceFactory.createResource((String)"eads.indexsearch.solr", (String)("result" + resultId), ResultSet.class);
        PieceOfKnowledge pok = (PieceOfKnowledge)ResourceFactory.createResource((String)"eads.indexsearch.solr", (String)("pok" + resultId), PieceOfKnowledge.class);
        results.setPok(pok);
        try {
            this.solrComponent.open(this.getWebAppPath(), "core0");
            QueryResponse res = this.solrComponent.search(query.getRequest(), offset, limit);
            int resCpt = 0;
            SolrDocumentList resultDocs = res.getResults();
            Map highlightings = res.getHighlighting();
            StringBuffer buf = new StringBuffer();
            buf.append("<rdf:RDF ");
            buf.append("\t\txmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" ");
            buf.append("\t\txmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" ");
            buf.append("\t\txmlns:dc=\"http://purl.org/dc/elements/1.1/\" ");
            buf.append("\t\txmlns:dct=\"http://purl.org/dc/terms/\" ");
            buf.append("\t\txmlns:wl=\"http://weblab-project.org/core/model/property/\" ");
            buf.append("\t\txmlns:wls=\"http://weblab-project.org/core/model/property/retrieval/\">");
            buf.append("<rdf:Description rdf:about=\"weblab://eads.indexsearch.lucene/result" + resultId + "\">");
            buf.append("\t<rdf:type rdf:resource=\"http://weblab-project.org/core/model/class/ResultSet\"/>");
            for (Map.Entry<String, String> local : this.conf.getResultSetLabels().entrySet()) {
                buf.append("\t<rdfs:label xml:lang=\"" + local.getKey() + "\">" + local.getValue() + "</rdfs:label>");
            }
            buf.append("    <wl:offset> " + offset + " </wl:offset>");
            buf.append("\t<wl:hasNumberOfResults> " + resultDocs.getNumFound() + "</wl:hasNumberOfResults>");
            buf.append("\t<wl:isResultOf rdf:resource=\"" + q.getUri() + "\" />");
            buf.append("</rdf:Description>");
            for (SolrDocument hit : resultDocs) {
                String resourceUri = String.valueOf(hit.getFieldValue("id"));
                String hitUri = "weblab://eads.indexsearch.solr/hit" + resCpt;
                buf.append("<rdf:Description rdf:about=\"" + hitUri + "\" >");
                buf.append("<rdf:type rdf:resource=\"" + this.conf.getHitClass() + "\" />");
                buf.append("<wls:hasRank>" + (offset + resCpt + 1) + "</wls:hasRank>");
                buf.append("<wls:hasScore>" + hit.getFieldValue("score") + "</wls:hasScore>");
                if (highlightings != null && ((Map)highlightings.get(hit.getFieldValue("id"))).size() > 0) {
                    List hitHighlightingList = (List)((Map)highlightings.get(hit.getFieldValue("id"))).get("text");
                    StringBuffer snippet = new StringBuffer();
                    for (String hl : hitHighlightingList) {
                        snippet.append(hl);
                    }
                    buf.append("<wls:hasDescription>" + snippet.toString() + "</wls:hasDescription>");
                }
                buf.append("<wls:isLinkedTo rdf:resource=\"" + resourceUri + "\" />");
                buf.append("<wls:inResultSet rdf:resource=\"" + results.getUri() + "\" />");
                buf.append("</rdf:Description>");
                ++resCpt;
            }
            buf.append("</rdf:RDF>");
            PoKUtil.setPoKData((PieceOfKnowledge)pok, (String)buf.toString());
        }
        catch (WebLabCheckedException e) {
            throw new SearchException("Cannot retrieve the results to query [" + query.getRequest() + "]", null);
        }
        return results;
    }

    private String getWebAppPath() throws WebLabCheckedException {
        String appPath = "./src/main/resources/";
        if (this.wsContext != null) {
            ServletContext ctx = (ServletContext)this.wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
            appPath = ctx.getRealPath("WEB-INF/");
        } else {
            LogFactory.getLog(FastSolrSearcher.class).warn((Object)"Webservice context not available returning current local path as default web app path");
        }
        File f = new File(appPath);
        if (!f.exists()) {
            throw new WebLabCheckedException("Webapp path [" + appPath + "] does not exists...");
        }
        return appPath;
    }
}

