/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.util.search;

import java.util.Map;

public class SearcherConfig {

	public static final String ISO_8601_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
	/**
	 * Default id pok
	 */
	public static final String DEFAULT_IDPOK = "pok";
	/**
	 * Default id hit
	 */
	public static final String DEFAULT_IDHIT = "hit";
	/**
	 * Summary key
	 */
	public static final String SUMMARY_KEY = "summary";
	/**
	 * Exalead produced from key
	 */
	public static final String PRODUCED_FROM_KEY = "isProducedFrom";
	/**
	 * Results key
	 */
	public static final String RESULTS_FROM_KEY = "isResultOf";
	/**
	 * Results number key
	 */
	public static final String NB_RESULTS_KEY = "hasNumberOfResults";
	/**
	 * Offset key
	 */
	public static final String OFFSET_KEY = "offset";
	/**
	 * Rank key
	 */
	public static final String HAS_RANK_KEY = "hasRank";
	/**
	 * Score key
	 */
	public static final String SCORE_KEY = "hasScore";
	/**
	 * Description key
	 */
	public static final String DESCRIPTION_KEY = "hasDescription";
	/**
	 * Linked to key
	 */
	public static final String LINKED_TO_KEY = "isLinkedTo";
	/**
	 * in result set key
	 */
	public static final String IN_RESULT_SET_KEY = "inResultSet";
	/**
	 * default name for indexer configuration bean
	 */
	public static final String DEFAULT_BEAN_NAME = "SearcherConfig";
	/**
	 * Field/properties mapping for the properties that will be retrieved in the document
	 */
	protected Map<String, String> properties;
	/**
	 * Map of String to be used as namespace prefix in the RDF/XML
	 */
	protected Map<String, String> nsPrefixProperties;
	/**
	 * Hit class
	 */
	protected String hitClass;

	public SearcherConfig() {
		super();
	}

	/**
	 * @return the properties
	 */
	public Map<String, String> getProperties() {
		return this.properties;
	}

	/**
	 * @param properties the properties to set
	 */
	public void setProperties(Map<String, String> properties) {
		this.properties = properties;
	}

	/**
	 * @return the nsPrefixProperties
	 */
	public Map<String, String> getNsPrefixProperties() {
		return this.nsPrefixProperties;
	}

	/**
	 * @param nsPrefixProperties the nsPrefixProperties to set
	 */
	public void setNsPrefixProperties(Map<String, String> nsPrefixProperties) {
		this.nsPrefixProperties = nsPrefixProperties;
	}

	/**
	 * @return the hitClass
	 */
	public String getHitClass() {
		return this.hitClass;
	}

	/**
	 * @param hitClass the hitClass to set
	 */
	public void setHitClass(String hitClass) {
		this.hitClass = hitClass;
	}

}